// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const FLOCK_INSTALL_PING_URL =
  "http://install-stats.flock.com/%MICROEDITION%/%USERUUID%";

const FLOCK_DEFAULT_FEEDS_OPML = "chrome://flock/locale/feeds/opml/default.opml";
Components.utils.import("resource:///modules/FlockPrefsUtils.jsm");

var brandingOverlay = {

  onLoad: function bo_onLoad() {
    var firstRunForBrowser = brandingOverlay.isFirstRunForComponent("browser_startup");
    var firstRunForFeeds = brandingOverlay.isFirstRunForComponent("feeds_startup");
    if (firstRunForBrowser) {
      FlockPrefsUtils.setCharPref("flock.firstrun.time", String(Date.now()));

      var aus = Components.classes["@mozilla.org/updates/update-service;1"]
                .getService(Components.interfaces.flockIApplicationUpdateService);
      aus.startupPing();

      var metrics = Components.classes["@flock.com/metrics-service;1"]
                    .getService(Components.interfaces.flockIMetricsService);
      metrics.doFirstRun();

      brandingOverlay.sendInstallPing();

      brandingOverlay.setupDefaultMedia();
    }

    if (firstRunForFeeds) {
      feedUtils.loadFeedsFromLocalOPML(FLOCK_DEFAULT_FEEDS_OPML);
    }

    brandingOverlay.updateWebDetectiveFiles();
    brandingOverlay.incrementFlockLaunchCount();
  },

  isFirstRunForComponent: function bo_isFirstRunForComponent (aComponentName) {
    var key = "flock.firstrun.components." + aComponentName + ".completed";
    if (!FlockPrefsUtils.getBoolPref(key)) {
      FlockPrefsUtils.setBoolPref(key, true);
      return true;
    }
    return false;
  },

  setupDefaultMedia: function bo_setupDefaultMedia() {
    var faves_coop = Components.classes["@flock.com/singleton;1"]
                               .getService(Components.interfaces.flockISingleton)
                               .getSingleton("chrome://flock/content/common/load-faves-coop.js")
                               .wrappedJSObject;
    var context = {
      coop: faves_coop
    };
    Components.classes["@mozilla.org/moz/jssubscript-loader;1"]
              .getService(Components.interfaces.mozIJSSubScriptLoader)
              .loadSubScript("chrome://flock/locale/photo/defaultMedia.js",
                             context);
  },

  sendInstallPing: function bo_sendInstallPing() {
//@line 77 "/home/build/tinderbuild_blue/src/flock/mozilla/flock/base/branding/flock/content/overlay.js"
    try {
      var formatter =
        Components.classes["@mozilla.org/toolkit/URLFormatterService;1"]
                  .getService(Components.interfaces.nsIURLFormatter);

      var url = formatter.formatURL(FLOCK_INSTALL_PING_URL);

      var req =
        Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"]
                  .createInstance(Components.interfaces.nsIXMLHttpRequest);
      req.mozBackgroundRequest = true;
      req.open("GET", url);
      req.send(null);
    } catch (ex) {
      // Something failed, just ignore and let first run continue
    }
//@line 94 "/home/build/tinderbuild_blue/src/flock/mozilla/flock/base/branding/flock/content/overlay.js"
  },

  updateWebDetectiveFiles: function bo_updateWebDetectiveFiles() {
//@line 98 "/home/build/tinderbuild_blue/src/flock/mozilla/flock/base/branding/flock/content/overlay.js"
    if (!FlockPrefsUtils.getBoolPref("flock.webdetective.upgraded")) {
      var wd = Components.classes["@flock.com/web-detective;1"]
                         .getService(Components.interfaces.flockIWebDetective);
      wd.checkForUpdates(true, null);

      FlockPrefsUtils.setBoolPref("flock.webdetective.upgraded", true);
    }
//@line 106 "/home/build/tinderbuild_blue/src/flock/mozilla/flock/base/branding/flock/content/overlay.js"
  },

  incrementFlockLaunchCount: function bo_incrementFlockLaunchCount(){
    var launchCount = FlockPrefsUtils.getIntPref("flock.launch_count");
    FlockPrefsUtils.setIntPref("flock.launch_count", 1);
  }

}

top.addEventListener("load", brandingOverlay.onLoad, false);
