// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

var BlogBrowserController = {
  cmd_flock_blogBlogThis: flock_blogBlogThisCommand,
  cmd_flock_blogNewPost: flock_blogNewPost,
  supportsCommand: function bCC_supportsCommand(aCmd) {
    return (this[aCmd] != null);
  },
  isCommandEnabled: function bCC_isCommandEnabled(aCmd) {
    return (this[aCmd] && this[aCmd].isEnabled());
  },
  doCommand: function bCC_doCommand(aCmd) {
    this[aCmd].exec();
  }
}

function flock_blogBrowserSetupEditorCommands() {
  top.controllers.appendController(BlogBrowserController);
  // TO - do not call top.focus(), in XP it throws the window
  //      into a confused state.
  //top.focus();
}

function flock_blogBrowserCleanupEditorCommands() {
  top.controllers.removeController(BlogBrowserController);
}

var blogButtonDNDObserver = {
  canHandleMultipleItems: true,

  onDragOver: function(aEvent, aFlavor, aSession) {
  },

  onDragEnter: function(aEvent, aSession) {
  },

  onDragExit: function(aEvent, aSession) {
  },

  onDrop: function(aEvent, aDropData, aSession) {
    var dropData = aDropData.dataList[0].dataList[0];
    
    var supports = dropData.supports;
    var contentType = dropData.flavour.contentType;
    var url;

    function getURLFromFile(aFile) {
      var ios = Components.classes["@mozilla.org/network/io-service;1"]
                .getService(Components.interfaces.nsIIOService);
      var fileHandler =
        ios.getProtocolHandler("file")
           .QueryInterface(Components.interfaces.nsIFileProtocolHandler);
      return fileHandler.getURLSpecFromFile(aFile);
    }

    if (contentType == "application/x-moz-file") {
      // File: if it's a photo, try to upload it
      try {
        var file = supports.QueryInterface(Components.interfaces.nsIFile);
        url = getURLFromFile(file);
      } catch(e) {}

      if (!FlockMedia.getUploadSvc().hasOnePhotoAccount()) {
        FlockMedia.getUploadSvc().promptForAccount();
        return;
      }

      var editWindow = flock_blog.service.openEditor(null, null, null);
      var photoUploadListener = {
        onMediaImportStart: function(aFilename, aCount) {
        },

        onMediaImportFinish: function(aUpload, aCount) {
          var target = editWindow.document.getElementById("edit");
          UploadUIUtils.launchSinglePhotoUpload(aUpload, target);
       },

        onMediaImportError: function (aFilename) {
          var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                .getService(Components.interfaces.nsIPromptService);
          promptService.alert(editWindow, 'The photo "' + aFilename + '" could not be uploaded because it is invalid.');
        }
      }
      FlockMedia.getUploadSvc().importSingleMediaItem(photoUploadListener, url);
    }
    else {
      // Not a file
      var richnDndSvc = Components.classes["@flock.com/rich-dnd-service;1"]
                        .getService(Components.interfaces.flockIRichDNDService);
      // Get the transferable
      var transferable = richnDndSvc.getRichSelection(aSession,
                                                      contentType,
                                                      dropData.data);
      if (transferable) {
        // Now get the content from it
        var flavors = ["text/x-flock-htmlcitation",
                       "text/html",
                       "text/unicode"];
        var message = richnDndSvc.getMessageFromTransferable(transferable,
                                                             flavors.length,
                                                             flavors);
        flock_blog.service.openEditor(message.subject, message.body, null);
      }
    }
  },

  onDragStart: function(aEvent, aTransferData, aAction) {},

  getSupportedFlavours: function() {
    var flavors = new FlavourSet();
    flavors.appendFlavour("application/x-flock-rich-content");
    flavors.appendFlavour("text/html");
    flavors.appendFlavour("application/x-moz-file", "nsIFile");
    return flavors;
  }
}

window.addEventListener("load", flock_blogBrowserSetupEditorCommands, false);
window.addEventListener("unload", flock_blogBrowserCleanupEditorCommands, false);
