// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

// the default object definitions for the Favorites datastore
// passed into this environment are Coop (the type) and coop (the instance)

const FLOCK_NS = "http://flock.com/rdf#";
const NSCP_NS = "http://home.netscape.com/NC-rdf#";
const RDF_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
const WEB_NS = "http://home.netscape.com/WEB-rdf#";
const FOAF_NS = "http://xmlns.com/foaf/0.1/";

coop.Identity = coop.add_type (FLOCK_NS + "Identity", {
  inherits_from: FLOCK_NS + "WebObject",
  fields: {
    serviceId: FLOCK_NS + "serviceId",
    accountId: FLOCK_NS + "accountId",
    avatar: FLOCK_NS + "avatar",
    status: FLOCK_NS + "status",
    statusMessage: FLOCK_NS + "statusMessage",
    statusMessageUrl: FLOCK_NS + "statusMessageUrl",
    lastUpdate: FLOCK_NS + "lastUpdate",
    lastUpdateType: FLOCK_NS + "lastUpdateType",
    friendOf: FLOCK_NS + "friendOf",
    unseenMedia: FLOCK_NS + "unseenMedia",
    totalMedia: FLOCK_NS + "totalMedia",
    lastUploadedMedia: FLOCK_NS + "lastUploadedMedia",
    screenName: FLOCK_NS + "screenName"
  },
  field_types: {
    lastUpdate: Coop.integer,
    friendOf: Coop.object,
    unseenMedia: Coop.stringinteger,
    totalMedia: Coop.stringinteger
  },
  field_defaults: {
    flockType: "identity",
    rdftype: FLOCK_NS + "Identity",
    lastProfileUpdate: 0,
    unseenMedia: 0,
    totalMedia: 0,
    isIndexable: true,
    lastUploadedMedia: ""
  },
  field_multiple: {
    friendOf: true
  },
  target_ds: coop.PeopleDS
});

coop.Identity.prototype.getAccount = function Identity_getAccount() {
 var parents = this.getParents();
 for each (var parent in parents) {
   if (parent.flockType == "FriendsList") {
     return parent.account;
   }
 }
 return null;
};

coop.FriendsList = coop.add_type (FLOCK_NS + "FriendsList", {
  inherits_from: FLOCK_NS + "Object",
  fields: {
    account: FLOCK_NS + "account"
  },
  field_types: {
    account: Coop.object
  },
   field_defaults: {
    flockType: "FriendsList",
    rdftype: FLOCK_NS + "FriendsList"
  },
  container: "Seq",
  target_ds: coop.PeopleDS
});

coop.FriendActivityLog = coop.add_type(FLOCK_NS + "FriendActivityLog", {
  inherits_from: FLOCK_NS + "Object",
  fields: {
    account: FLOCK_NS + "account"
  },
  field_types: {
    account: Coop.object
  },
  field_defaults: {
    flockType: "FriendActivityLog",
    rdftype: FLOCK_NS + "FriendActivityLog"
  },
  container: "Seq"
});

coop.FriendActivity = coop.add_type(FLOCK_NS + "FriendActivity", {
  inherits_from: FLOCK_NS + "Object",
  fields: {
    updateType: FLOCK_NS + "updateType",
    updateDate: FLOCK_NS + "updateDate",
    updateValue: FLOCK_NS + "updateValue",
    updateURL: FLOCK_NS + "updateURL",
    identity: FLOCK_NS + "Identity"
  },
  field_types: {
    updateDate: Coop.date,
    identity: Coop.object
  },
  field_defaults: {
    flockType: "FriendActivity",
    rdftype: FLOCK_NS + "FriendActivity",
    updateValue: new Date(0)
  }
});

coop.Person = coop.add_type(FLOCK_NS+"Person", {
  inherits_from: FLOCK_NS + "Object",
  fields: {
    nameIdentity: FLOCK_NS + "nameIdentity",
    avatarIdentity: FLOCK_NS + "avatarIdentity",
    statusMessageIdentity: FLOCK_NS + "statusMessageIdentity",
    unseenMedia: FLOCK_NS + "unseenMedia"
  },
  field_types: {
    nameIdentity: Coop.object,
    avatarIdentity: Coop.object,
    statusMessageIdentity: Coop.object,
    unseenMedia: Coop.stringinteger
  },
  field_defaults: {
    rdftype: FLOCK_NS + "Person",
    flockType: "person",
    unseenMedia: 0
  },
  container: "Seq",
  target_ds: coop.PeopleDS
});

coop.Foaf = coop.add_type(FLOCK_NS+'Foaf', {
  inherits_from: FLOCK_NS+'Object',
  fields: {
    name: NSCP_NS+'Name',
    serviceId: FLOCK_NS+'serviceId',
    accountId: FLOCK_NS+'accountId',
    account: FLOCK_NS+'account',
    avatar: FLOCK_NS+'avatar',
    status: FLOCK_NS+'status',
    statusMessage: FLOCK_NS+'statusMessage',
    enabledAction: FLOCK_NS+'enabledAction',
    friendOf: FLOCK_NS+'friendOf',
    datevalue: FLOCK_NS+'datevalue'
  },
  field_types: {
    enabledAction: Coop.object,
    friendOf: Coop.object,
    account: Coop.object,
    datevalue: Coop.date
  },
  field_defaults: {
    flockType: 'identity',
    rdftype: FLOCK_NS+'Identity',
    datevalue: new Date(0),
    isTransient: false
  },
  field_multiple: {
    enabledAction: true,
    account: true,
    friendOf: true
  },
  container: 'Seq',
  target_ds: coop.TransientDS
});

coop.FoafPerson = coop.add_type (FLOCK_NS+'FoafPerson', {
  inherits_from: FLOCK_NS+'Object',
  fields: {
    avatar: FLOCK_NS+'avatar',
    primaryIdentity: FLOCK_NS+'primaryIdentity'
  },
  field_types: {
    primaryIdentity: Coop.object
  },
  field_defaults: {
    flockType: 'person',
    rdftype: FLOCK_NS+'Person',
    isTransient: false
  },
  container: 'Seq',
  target_ds: coop.TransientDS
});
