//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

function $(aID) { return document.getElementById(aID); }

var importOPML = {};

importOPML.accept = function() {
    var url = $("fileName").value;
    if (feedUtils.isValidURL(url)) {
        var listener = Components.classes["@flock.com/opml-subscribe-listener-mark-read;1"].createInstance(Components.interfaces.flockIOpmlSubscribeListener);
        try {
            feedUtils.loadFeedsFromLocalOPML(url, listener, null);
            return true;
        } catch(e) {
            $("error").removeAttribute("hidden");
            return false;
        }
    } else {
        $("error").removeAttribute("hidden");
        return false;
    }
    return false;
}

importOPML.showFilePicker = function() {
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, $("importOPML").getAttribute("filePickerText"), nsIFilePicker.modeOpen);
    fp.appendFilter($("importOPML").getAttribute("opmlFileTypeText"),"*.opml");
    fp.appendFilters(nsIFilePicker.filterXML);
    fp.appendFilters(nsIFilePicker.filterAll);
    var res = fp.show();
    if (res == nsIFilePicker.returnOK) {
        var file = fp.file;
        var url = feedUtils.getURLFromFile(file);
        $("fileName").value = url;
    }

}
