//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

const OOBE_ENABLED = "flock.oobe.enabled";
const OOBE_DIALOG = "chrome://flock/content/oobe/oobeDialog.xul";
const OOBE_DIALOG_CONFIRM = "chrome://flock/content/oobe/oobeDialogConfirm.xul";
const OOBE_DONT_SHOW = "flock.oobe.dontshow";
const STARTUP_HOMEPAGE = "startup.homepage_welcome_url";
const OOBE_FIRST_RUN_COMPLETED = "flock.firstrun.components.OOBE.completed";
const CU = Components.utils;

CU.import("resource:///modules/FlockStringBundleHelpers.jsm");
CU.import("resource:///modules/FlockPrefsUtils.jsm");

var oobeDialog = {
  init: function initFunction() {
    // OOBE Enabled?
    var prefService = CC["@mozilla.org/preferences-service;1"]
                      .getService(CI.nsIPrefBranch);
    if (!FlockPrefsUtils.getBoolPref(OOBE_ENABLED)) {
      return; 
    }

    // Did they really want to see this?
    if (prefService.getPrefType(OOBE_DONT_SHOW) &&
        prefService.getBoolPref(OOBE_DONT_SHOW))
    {
      return;
    }

    // Make sure we actually have an active browser window open before
    // launching the dialog, otherwise schedule ourselves again.
    // This condition may happen if other onload handlers are pumping
    // main loop events due to synchronous operations.
    var browserWindow = CC["@mozilla.org/appshell/window-mediator;1"]
                        .getService(CI.nsIWindowMediator)
                        .getMostRecentWindow("navigator:browser");
    var ww = CC["@mozilla.org/embedcomp/window-watcher;1"]
             .getService(CI.nsIWindowWatcher);
    if (!browserWindow || ww.activeWindow != browserWindow) {
      setTimeout("oobeDialog.init()", 250);
      return;
    }

    // Make sure we're the only instance
    var hiddenWindow = CC["@mozilla.org/appshell/appShellService;1"]
                       .getService(CI.nsIAppShellService)
                       .hiddenDOMWindow;

    // Don't try to open dialog if it's already open
    if (hiddenWindow.oobeDialogOpen) {
      return;
    }
    
    if (hiddenWindow.oobeDialogStatus) {
      return;
    }
    hiddenWindow.oobeDialogStatus = "ready";
    hiddenWindow.oobeDialogOpen = true;

    if (!detectFlash()) {
      return;
    }

    var retVals = {
      dontShow: null
    };

    CC["@flock.com/metrics-service;1"]
    .getService(CI.flockIMetricsService)
    .report("OOBEDialog-Open", {aChapter:"intro",source:"startup"});

    // Launch the dialog
    window.openDialog(OOBE_DIALOG,
                      "oobeDialog",
                      "resizable=0,modal,centerscreen",
                      null,
                      retVals);

    if (retVals.dontShow) {
      window.openDialog(OOBE_DIALOG_CONFIRM,
                        "oobeDialog",
                        "resizable=no,modal,centerscreen",
                        null,
                        null);
    }
  },
  delayedLoad: function delayedLoadFunction() {
    // Give time to other GUI components to draw before showing OOBE
    setTimeout("oobeDialog.init()", 500);
  }
};

// OOBE instrumentation
var firstRunForOOBECompleted
  = FlockPrefsUtils.getBoolPref(OOBE_FIRST_RUN_COMPLETED);
if (!firstRunForOOBECompleted) {
  FlockPrefsUtils.setBoolPref(OOBE_FIRST_RUN_COMPLETED, true);
  var oobe1 = false;
  var oobe2 = false;
  var metricsSvc = Components.classes["@flock.com/metrics-service;1"]
                             .getService(Components.interfaces
                                                   .flockIMetricsService);

  // OOBE 1?
  if (FlockPrefsUtils.getBoolPref(OOBE_ENABLED) &&
      !FlockPrefsUtils.getBoolPref(OOBE_DONT_SHOW))
  {
    oobe1 = true;
  }

  // OOBE 2?
  if (FlockPrefsUtils.getCharPref(STARTUP_HOMEPAGE) == "about:flock") {
    oobe2 = true;
  }

  if (oobe1 && oobe2) {
    // Both OOBE
    metricsSvc.report("OOBE-Payload","oobe1and2");
  } else if (oobe1) {
    metricsSvc.report("OOBE-Payload","oobe1");
  } else if (oobe2) {
    metricsSvc.report("OOBE-Payload","oobe2");
  }

  // Does the user not have flash or disabled it?
  if (!detectFlash()) {
    metricsSvc.report("OOBE-Flash-Detected","false");
  }
}

window.addEventListener("load",
                        function(e) { oobeDialog.delayedLoad() },
                        false);
