//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

const OOBE_ENABLED = "flock.oobe.enabled";
const OOBE_DIALOG = "chrome://flock/content/oobe/oobeDialog.xul";
const OOBE_DONT_SHOW = "flock.oobe.dontshow";
const CC = Components.classes;
const CI = Components.interfaces;
const CU = Components.utils;

CU.import("resource:///modules/FlockStringBundleHelpers.jsm");
CU.import("resource:///modules/FlockPrefsUtils.jsm");

var oobeDialogLauncher = {
  init: function oobeDialogLauncher_init() {
    // OOBE enabled?
    if (FlockPrefsUtils.getBoolPref(OOBE_ENABLED) &&
        detectFlash())
    {
      // Launch the dialog
      setTimeout("oobeDialogLauncher.open()", 0);
    }

    // Instrumentation
    CC["@flock.com/metrics-service;1"].getService(CI.flockIMetricsService)
                                      .report("OOBEPage-Opened", null);
  },
  uninit: function oobeLauncher_uninit() {
    CC["@flock.com/metrics-service;1"].getService(CI.flockIMetricsService)
                                      .report("OOBEPage-Close", null);
  },
  open: function oobeDialogLauncher_open() {
    var hiddenWindow = CC["@mozilla.org/appshell/appShellService;1"]
                       .getService(CI.nsIAppShellService)
                       .hiddenDOMWindow;
    // Check if dialog is already open
    if (!hiddenWindow.oobeDialogOpen) {
      hiddenWindow.oobeDialogOpen = true;
      window.openDialog(OOBE_DIALOG,
                        "oobeDialog",
                        "resizable=0,modal,centerscreen",
                        null,
                        null);
      hiddenWindow.oobeDialogOpen = false;
    }
  }
};

window.addEventListener("load",
                        function(e) { oobeDialogLauncher.init(); },
                        false);
window.addEventListener("unload",
                        function(e) { oobeDialogLauncher.uninit(); },
                        false);
