//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

Components.utils.import("resource:///modules/FlockCryptoHash.jsm");

const FLOCK_PREF_PHOTO_RESIZE = "flock.photo.resize";
const FLOCK_PREF_PHOTO_RESIZE_DIMENSIONS = "flock.photo.resize.dimensions";

const FLOCK_IO_CHUNKSIZE = 65536 * 4;
const FLOCK_THUMB_SIZE = 75;
const FLOCK_PREVIEW_SIZE = 300;

function flock_getTmpFile(aFName) {
    var sinkFile = Components.classes["@mozilla.org/file/directory_service;1"]
        .getService(Components.interfaces.nsIProperties)
        .get("ProfD", Components.interfaces.nsIFile);
    sinkFile.append("flock_imagecache");
    if(!sinkFile.exists()) {
        sinkFile.createUnique(1,0700);
    }
    if(aFName) sinkFile.append(aFName);
    return sinkFile;
}


function flock_getURLFromFile(aFile) {
    var ios = Components.classes["@mozilla.org/network/io-service;1"]
        .getService(Components.interfaces.nsIIOService);
    var fileHandler = ios.getProtocolHandler("file")
        .QueryInterface(Components.interfaces.nsIFileProtocolHandler);
    return fileHandler.getURLSpecFromFile(aFile);
}

function flock_getFileFromURL(aURL) {
    var ios = Components.classes["@mozilla.org/network/io-service;1"]
        .getService(Components.interfaces.nsIIOService);
    var fileHandler = ios.getProtocolHandler("file")
        .QueryInterface(Components.interfaces.nsIFileProtocolHandler);
    var sourceSpec = fileHandler.getFileFromURLSpec(aURL);
    var sourceFile = Components.classes["@mozilla.org/file/local;1"]
        .createInstance(Components.interfaces.nsILocalFile);
    sourceFile.initWithFile(sourceSpec);
    return sourceFile;
}

function flock_getBufferredInputStream(aFile) {
    var sourceFileStream = Components.classes["@mozilla.org/network/file-input-stream;1"]
        .createInstance(Components.interfaces.nsIFileInputStream);
    sourceFileStream.init(aFile, 1, 0, false);

    var sourceBufferStream = Components.classes["@mozilla.org/network/buffered-input-stream;1"]
        .createInstance(Components.interfaces.nsIBufferedInputStream);

    sourceBufferStream.init(sourceFileStream, FLOCK_IO_CHUNKSIZE); // write, create, truncate
    return sourceBufferStream;
}

function flock_getBufferredOutputStream(aFile) {
    var sinkFileStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
                            .createInstance(Components.interfaces.nsIFileOutputStream);
    sinkFileStream.init(aFile, 0x02 | 0x08 | 0x20, 0664, 0); // write, create, truncate


    var sinkBufferStream = Components.classes["@mozilla.org/network/buffered-output-stream;1"]
        .createInstance(Components.interfaces.nsIBufferedOutputStream);
    sinkBufferStream.init(sinkFileStream, FLOCK_IO_CHUNKSIZE); // write, create, truncate
    return sinkBufferStream;
}

function PhotoUploader() {
}

PhotoUploader.prototype = {
    CC: Components.classes,
    CI: Components.interfaces,
    endpoint: null,
    photoParam: "photo",
    contentType: "application/octet-stream",
    setEndpoint: function(aEndpoint) { this.endpoint = aEndpoint; },
    setPhotoParam: function(aPhotoParam) { this.photoParam = aPhotoParam; },
    upload: function(aListener, aPhoto, aParams, aUpload) {
        try {
            var now = new Date();
            var tmpFileName = aPhoto + now;
            tmpFileName = "flock_" + FlockCryptoHash.md5(tmpFileName) + ".tmp";

            var ios = Components.classes["@mozilla.org/network/io-service;1"]
                .getService(Components.interfaces.nsIIOService);
            var fileHandler = ios.getProtocolHandler("file")
                .QueryInterface(Components.interfaces.nsIFileProtocolHandler);
            var fileFromSpec = fileHandler.getFileFromURLSpec(aPhoto);

            var boundaryString = 'AaB03x';
            var contentType = "multipart/form-data; boundary=" + boundaryString;
            var boundary = '--' + boundaryString;


            var photoFile = Components.classes["@mozilla.org/file/local;1"]
                .createInstance(Components.interfaces.nsILocalFile);
            photoFile.initWithFile(fileFromSpec);

            var photoStream = Components.classes["@mozilla.org/network/file-input-stream;1"]
                .createInstance(Components.interfaces.nsIFileInputStream);
            photoStream.init(photoFile, 1, 0644, 0);

            var tmpFile = flock_getTmpFile(tmpFileName);

            var tmpFileStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
                                          .createInstance(Components.interfaces.nsIFileOutputStream);
            tmpFileStream.init(tmpFile, 0x02 | 0x08 | 0x20, 0664, 0); // write, create, truncate

            var tmpBufferStream = Components.classes["@mozilla.org/network/buffered-output-stream;1"]
                .createInstance(Components.interfaces.nsIBufferedOutputStream);

            var converter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"]
                                      .createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
            converter.charset = "UTF-8";

            tmpBufferStream.init(tmpFileStream, 65536 * 4);

            tmpBufferStream.write(boundary, boundary.length);
            tmpBufferStream.write("\r\n", 2);

            var fileName = fileFromSpec.leafName;
            if(aUpload) {
                fileName = aUpload.fileName;
            }
            var next = "";
            next = 'Content-Disposition: form-data; name="' + this.photoParam + '"; filename="' + fileName + '"';
            tmpBufferStream.write(next, next.length);
            tmpBufferStream.write("\r\n", 2);

            next = 'Content-Type: ' + this.contentType;

            tmpBufferStream.write(next, next.length);
            tmpBufferStream.write("\r\n", 2);
            tmpBufferStream.write("\r\n", 2);

            tmpBufferStream.writeFrom(photoStream, photoFile.fileSize);
            tmpBufferStream.write("\r\n", 2);

            for(var p in aParams) {
                tmpBufferStream.write(boundary, boundary.length);
                tmpBufferStream.write("\r\n", 2);
                var next = 'Content-Disposition: form-data; name="' + p + '"';
                tmpBufferStream.write(next, next.length);
                tmpBufferStream.write("\r\n", 2);
                tmpBufferStream.write("\r\n", 2);
                var param = aParams[p] + "";
                var inputStream = converter.convertToInputStream(param);
                tmpBufferStream.writeFrom(inputStream, inputStream.available());
                //tmpBufferStream.write(param, param.length);
                tmpBufferStream.write("\r\n", 2);
            }

            tmpBufferStream.write(boundary, boundary.length);
            tmpBufferStream.write("--", 2);
            tmpBufferStream.write("\r\n", 2);
            tmpBufferStream.write("\r\n", 2);
            tmpBufferStream.close();
            tmpFileStream.close();

            url = this.endpoint;
            this.req = Components.classes['@mozilla.org/xmlextras/xmlhttprequest;1']
                                .createInstance(Components.interfaces.nsIXMLHttpRequest);
            var req = this.req;
            var inst = this;
            var onReadyStateFunc = function(aEvt) {
              if (req.readyState == 4) {
                if (Math.floor(req.status/100) == 2) {
                  // Return the responseText and parse at a service level
                  // as some services require XML, and others JSON
                  aListener.onResult(req.responseText);
                } else {
                  // HTTP errors (0 for connection lost)
                  aListener.onError(req.status);
                }
              }
            };

            var onProgressStateFunc = function(aEvt) {
              var currentProgress = 0;
              if (aEvt.totalSize > 0) {
                currentProgress = (aEvt.position / aEvt.totalSize) * 100;
              }
              aListener.onProgress(currentProgress);
            };

            // This will make it so we don't invoke an XML parser
            req.overrideMimeType("text/txt");
            // Detach the xmlhttprequest from this document
            req.mozBackgroundRequest = true;

            // We have to attach the progress functions before calling open
            // This lets the nsXMLHttpRequest component know that we want async and
            // we want a progress listener attached.
            req.onreadystatechange = onReadyStateFunc;
            req.onuploadprogress = onProgressStateFunc;

            req.open("POST",url,true);
            req.setRequestHeader("Content-Type", contentType);

            var tmpInputStream = Components.classes["@mozilla.org/network/file-input-stream;1"]
                .createInstance(Components.interfaces.nsIFileInputStream);
            tmpInputStream.init(tmpFile, 1, 0644, 0);

            var tmpInputBufferStream = Components.classes["@mozilla.org/network/buffered-input-stream;1"]
                .createInstance(Components.interfaces.nsIBufferedInputStream);

            tmpInputBufferStream.init(tmpInputStream, 65536 * 4);
            req.send(tmpInputBufferStream);
        }
        catch(e) {
            dump(e+"\n");
            aListener.onError(null);
        }
    },
    // with XML data
    uploadWithXml: function(aListener, aPhoto, aParams, aUpload) {
      var now = new Date();
      var tmpFileName = aPhoto + now;
      tmpFileName = "flock_" + FlockCryptoHash.md5(tmpFileName) + ".tmp";

      var ios = Components.classes["@mozilla.org/network/io-service;1"]
          .getService(Components.interfaces.nsIIOService);
      var fileHandler = ios.getProtocolHandler("file")
          .QueryInterface(Components.interfaces.nsIFileProtocolHandler);
      var fileFromSpec = fileHandler.getFileFromURLSpec(aPhoto);

      var photoFile = Components.classes["@mozilla.org/file/local;1"]
          .createInstance(Components.interfaces.nsILocalFile);
      photoFile.initWithFile(fileFromSpec);

      var photoStream = Components.classes["@mozilla.org/network/file-input-stream;1"]
          .createInstance(Components.interfaces.nsIFileInputStream);
      photoStream.init(photoFile, 1, 0644, 0);

      var tmpFile = flock_getTmpFile(tmpFileName);

      var tmpFileStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
                                    .createInstance(Components.interfaces.nsIFileOutputStream);
      tmpFileStream.init(tmpFile, 0x02 | 0x08 | 0x20, 0664, 0); // write, create, truncate

      var tmpBufferStream = Components.classes["@mozilla.org/network/buffered-output-stream;1"]
          .createInstance(Components.interfaces.nsIBufferedOutputStream);

      tmpBufferStream.init(tmpFileStream, 65536 * 4);

      var contentType = aParams.headers["Content-Type"];
      var auth = aParams.headers["Authorization"];
      var boundaryString = aParams.boundaryString;
      var boundary = "--" + boundaryString;

      var prePhotoTxt = "";
      prePhotoTxt = "Media multipart posting"
                  + "\r\n"
                  + boundary
                  + "\r\n"
                  + "Content-Type: application/atom+xml"
                  + "\r\n"
                  + "\r\n"
                  + aParams.dataXml
                  + "\r\n"
                  + boundary
                  + "\r\n"
                  + "Content-Type: image/jpeg"
                  + "\r\n"
                  + "\r\n";
      tmpBufferStream.write(prePhotoTxt, prePhotoTxt.length);

      var fileName = fileFromSpec.leafName;
      if(aUpload) {
          fileName = aUpload.fileName;
      }

      // Write from photo data stream
      tmpBufferStream.writeFrom(photoStream, photoFile.fileSize);
      bodyLength += photoFile.fileSize;

      var postPhotoTxt = "\r\n"
                       + boundary + "--";
      tmpBufferStream.write(postPhotoTxt, postPhotoTxt.length);

      tmpBufferStream.close();
      tmpFileStream.close();

      var bodyLength = prePhotoTxt.length
                     + photoFile.fileSize
                     + postPhotoTxt.length;

      url = this.endpoint;
      this.req = Components.classes['@mozilla.org/xmlextras/xmlhttprequest;1']
                          .createInstance(Components.interfaces.nsIXMLHttpRequest);
      var req = this.req;
      var inst = this;
      var onReadyStateFunc = function(aEvt) {
        if (req.readyState == 4) {
          if (Math.floor(req.status/100) == 2) {
            aListener.onResult(req.responseXML);
          } else {
            // HTTP errors (0 for connection lost)
            var errorCode;
            // Picasa upload error codes follow the syntax: (nnn) - some error text
            if (req.responseText.match(/^\(([0-9]+)\)/)) {
              errorCode = RegExp.$1;
            } else {
              errorCode = req.status;
            }
            aListener.onError(errorCode);
          }
        }
      };

      var onProgressStateFunc = function(aEvt) {
        var currentProgress = 0;
        if (aEvt.totalSize > 0) {
          currentProgress = (aEvt.position / aEvt.totalSize) * 100;
        }
        aListener.onProgress(currentProgress);
      };

      // Detach the xmlhttprequest from this document
      req.mozBackgroundRequest = true;

      // We have to attach the progress functions before calling open
      // This lets the nsXMLHttpRequest component know that we want async and
      // we want a progress listener attached.
      req.onreadystatechange = onReadyStateFunc;
      req.onuploadprogress = onProgressStateFunc;

      req.open("POST",url,true);
      req.setRequestHeader("Content-Type", contentType);
      req.setRequestHeader("Content-Length", bodyLength);
      req.setRequestHeader("MIME-version", "1.0");
      req.setRequestHeader("Authorization", auth);

      var tmpInputStream = Components.classes["@mozilla.org/network/file-input-stream;1"]
          .createInstance(Components.interfaces.nsIFileInputStream);
      tmpInputStream.init(tmpFile, 1, 0644, 0);

      var tmpInputBufferStream = Components.classes["@mozilla.org/network/buffered-input-stream;1"]
          .createInstance(Components.interfaces.nsIBufferedInputStream);

      tmpInputBufferStream.init(tmpInputStream, 65536 * 4);
      req.send(tmpInputBufferStream);
    },

    uploadBase64: function(aListener, aPhoto, aUpload, aMethod, aHeader) {
      var tmpFileName = "flock_"
                      + FlockCryptoHash.md5(aPhoto +  new Date())
                      + ".tmp";
      var tmpFile = flock_getTmpFile(tmpFileName);

      var ios = this.CC["@mozilla.org/network/io-service;1"]
                    .getService(this.CI.nsIIOService);
      var fileHandler = ios.getProtocolHandler("file")
                           .QueryInterface(this.CI.nsIFileProtocolHandler);

      // Converts the URL string into the corresponding nsIFile
      var fileFromSpec = fileHandler.getFileFromURLSpec(aPhoto);
      var fileName = fileFromSpec.leafName;
      if (aUpload && aUpload.fileName) {
        fileName = aUpload.fileName;
      }
      // Grab the extension from the fileName
      var fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);

     // Create a local file object
      var photoFile = this.CC["@mozilla.org/file/local;1"]
                          .createInstance(this.CI.nsILocalFile);

      // Initialize with the nsIFile
      photoFile.initWithFile(fileFromSpec);

      // Create a file stream to read in the data for base64 conversion
      var photoStream = this.CC["@mozilla.org/network/file-input-stream;1"]
                            .createInstance(this.CI.nsIFileInputStream);
      photoStream.init(photoFile, 1, 0644, 0);

      // Create a binary stream from the local file
      var inStream = this.CC["@mozilla.org/binaryinputstream;1"]
                         .createInstance(this.CI.nsIBinaryInputStream);
      inStream.setInputStream(photoStream);

      // Read in and base64 encode the photo
      var base64Encoded = btoa(inStream.readBytes(inStream.available()));

      var outFileStream = this.CC["@mozilla.org/network/file-output-stream;1"]
                              .createInstance(this.CI.nsIFileOutputStream);
      // Write, create, truncate
      outFileStream.init(tmpFile, 0x02 | 0x08 | 0x20, 0664, 0);

      var outStream = this.CC["@mozilla.org/binaryoutputstream;1"]
                          .createInstance(this.CI.nsIBinaryOutputStream);
      outStream.setOutputStream(outFileStream);

      // Buffer the output stream
      var bufferStream = this.CC["@mozilla.org/network/buffered-output-stream;1"]
                             .createInstance(this.CI.nsIBufferedOutputStream);
      bufferStream.init(outStream, 65536 * 4);

      // Write our base64 encoded image data to the buffered stream
      bufferStream.write(base64Encoded, base64Encoded.length);

      // Close the stream
      bufferStream.close();
      outStream.close();

      // Create the XHR
      this.req = this.CC['@mozilla.org/xmlextras/xmlhttprequest;1']
                     .createInstance(this.CI.nsIXMLHttpRequest);
      var req = this.req;
      var inst = this;
      var onReadyStateFunc = function uploadBase64_onReadyStateFunc(aEvt) {
        if (req.readyState == 4) {
          if (Math.floor(req.status/100) == 2) {
            var dom = inst.CC["@mozilla.org/xmlextras/domparser;1"]
                          .createInstance(inst.CI.nsIDOMParser)
                          .parseFromString(req.responseText, "text/xml");
            aListener.onResult(dom);
          } else {
            // HTTP errors (0 for connection lost)
            aListener.onError(req.status);
          }
        }
      };

      var onProgressStateFunc =
      function uploadBase64_onProgressStateFunc(aEvt) {
        var currentProgress = 0;
        if (aEvt.totalSize > 0) {
          currentProgress = (aEvt.position / aEvt.totalSize) * 100;
        }
        aListener.onProgress(currentProgress);
      };

      // This will make it so we don't invoke an XML parser
      req.overrideMimeType("text/txt");

      // Detach the xmlhttprequest from this document
      req.mozBackgroundRequest = true;

      // We have to attach the progress functions before calling open
      // This lets the nsXMLHttpRequest component know that we want async and
      // we want a progress listener attached.
      req.onreadystatechange = onReadyStateFunc;
      req.onuploadprogress = onProgressStateFunc;

      // Open the XHR to and 
      req.open(aMethod, this.endpoint, true);

      // Set any specified request headers, blank strings are Ok
      for (var key in aHeader) {
        if (key && aHeader[key] != null) {
          req.setRequestHeader(key, aHeader[key]);
        }
      }

      // Set the Content-Length of our base64 encoded data
      req.setRequestHeader("Content-Length", base64Encoded.length);

      // Create a buffered input stream to send for interaction
      var sendInputStream = this.CC["@mozilla.org/network/file-input-stream;1"]
                                .createInstance(this.CI.nsIFileInputStream);
      sendInputStream.init(tmpFile, 1, 0644, 0);
      var sendInputBufferStream = this.CC["@mozilla.org/network/buffered-input-stream;1"]
                                      .createInstance(this.CI.nsIBufferedInputStream);
      sendInputBufferStream.init(sendInputStream, 65536 * 4);

      // Send the buffer stream
      req.send(sendInputBufferStream);
    }
}


// JMC - Can't use | or : in a query, is this going to be sufficient?
// If there's a user: pair AND a search: pair, then it's a search within the user
// If just a search: pair without a user: pair, it's a service-wide search
// If there's an album:, it restricts
// If there's a seq:, it specifies the starting point
function queryHelper(aString) {
  if (aString && !aString.split) debugger;
  if (aString) {
    var pairs = aString.split("|");
    for (x in pairs) {
      var pair = pairs[x].split(":");
      if (pair[0] == 'search') {
        this[pair[0]] = decodeURIComponent(pair[1]); 
      } else {
        this[pair[0]] = pair[1];
      }
    }
  }
  this.validKeys = ["user","username","search","searchunique","album","albumlabel","preview","favorites","pool","special","sort"];
  this.canonicalKeys = ["user","username","search","searchunique","album","albumlabel","preview","favorites","pool","special","sort"];
}

queryHelper.prototype.__defineGetter__("stringVal", function () {
  var pairs = [];
  for (x in this.validKeys) {
    if (this[this.validKeys[x]]) {
      if (this.validKeys[x] == "search") {
        pairs.push(this.validKeys[x] + ":" + encodeURIComponent(this[this.validKeys[x]]));
      } else {
        pairs.push(this.validKeys[x] + ":" + this[this.validKeys[x]]);
      }
    }
  }
  if (pairs.length) return pairs.join("|");
  return null;
})

queryHelper.prototype.__defineGetter__("canonicalVal", function () {
  var pairs = [];
  for (x in this.canonicalKeys) {
    if (this[this.canonicalKeys[x]]) {
      if (this.canonicalKeys[x] == "search") {
        pairs.push(this.canonicalKeys[x] + ":" + encodeURIComponent(this[this.canonicalKeys[x]]));
      } else {
        pairs.push(this.canonicalKeys[x] + ":" + this[this.canonicalKeys[x]]);
      }
    }
  }
  if (pairs.length) return pairs.join("|");
  return null;
})

queryHelper.prototype.hasKey = function(aKey) {
  return (this[aKey]);
}

queryHelper.prototype.getKey = function(aKey) {
  return this[aKey];
}

queryHelper.prototype.getEncodedKey = function(aKey) {
  return encodeURIComponent(this[aKey]);
}
