//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

function flock_setupPhotoPropsUIFields(aAPI) {
  if (!aAPI)
    return;
  $("photo-title").setAttribute("hidden", !aAPI.supportsFeature('title'));
  $("photo-tags").setAttribute("hidden", !aAPI.supportsFeature('tags'));
  $("photo-permissions").setAttribute("hidden", !aAPI.supportsFeature('privacy'));
 
  if(aAPI.supportsTitle) {
    $("title").focus();
  } else {
    $("description").focus();
  }
}


function flock_updatePhotoCommand(aCommandId, params) {      
  switch (aCommandId) {       
    case "cropImage":                                                    
      $('bCasterPhotoPropsAction').removeAttribute('disabled');
      $('cmdCrop').setAttribute('oncommand', 
                                'flock_photoPropertiesDoCrop(' + 
                                params.width + ',' + 
                                params.height + ',' +  
                                params.x + ',' + 
                                params.y + ');');                                                                   
    break;

    default:
      $('flock-photoUploaderActionMessage').setAttribute ('value', ""); 
    break;
  }
}

function flock_photoPropertiesSetPrivacy(aVal) {
  $('is_public').value = aVal;
  if(aVal=="private") {
    $('is_friend').disabled = false;
    $('is_family').disabled = false;
  }
  else {
    $('is_friend').disabled = true;
    $('is_family').disabled = true;
  }
}
