//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//


var gSharingPane = {
  /**
   * Converts the refresh interval from seconds to minutes and returns that
   * value to be used in the UI.
   */
  onPrefChange: function gsp_onPrefChange() {
    var preference = document.getElementById("flock.webmail.refreshInterval");
    var minutes = Math.floor(preference.value / 60);
    // Fit within bounds
    if (minutes < 1) {
      minutes = 1;
    } else if (minutes > 60) {
      minutes = 60;
    }
    return minutes;
  },

  /**
   * Forces an update of the service xml files for WebDetective.
   */
  forceServiceUpdates: function gsp_forceServiceUpdates() {
    var serviceStatus = document.getElementById("serviceUpdateStatus");
    var forceServiceUpdatesButton = document.getElementById("forceServiceUpdates");

    var sbs = Components.classes["@mozilla.org/intl/stringbundle;1"]
                        .getService(Components.interfaces.nsIStringBundleService);
    var bundle = sbs.createBundle("chrome://flock/locale/preferences/flockprefs.properties");

    if (serviceStatus) {
      serviceStatus.value = bundle.GetStringFromName("flock.pref.service.update.starting");
    }

    var serviceUpdateCallBack = {
      onSuccess: function gsp_sucb_onSuccess(aSubject, aTopic) {
        serviceStatus.value = bundle.GetStringFromName("flock.pref.service.update.success");
        forceServiceUpdatesButton.disabled = false;
      },
      onError: function gsp_sucb_onError(aError, aTopic) {
        serviceStatus.value = bundle.GetStringFromName("flock.pref.service.update.error");
        forceServiceUpdatesButton.disabled = false;
      }
    };

    var webDetective = Components.classes["@flock.com/web-detective;1"]
                                 .getService(Components.interfaces.flockIWebDetective);
    if (webDetective) {
      forceServiceUpdatesButton.disabled = true;
      webDetective.checkForUpdates(true, serviceUpdateCallBack);
    }
  },

  /**
   * Converts the refresh interval from minutes (as it is specified in the UI)
   * to seconds and returns that value to be saved in the prefs.
   */
  onUIChange: function gsp_onUIChange() {
    var refreshIntervalElement = document.getElementById("refreshInterval");
    // Strip out non-digits
    var refreshIntervalText = refreshIntervalElement.value;
    if (refreshIntervalText && refreshIntervalText.length > 0) {
      refreshIntervalText = refreshIntervalText.replace(/\D+/g, "");
      if (!refreshIntervalText) {
        refreshIntervalText = "";
      }
      // Change if different
      if (refreshIntervalText != refreshIntervalElement.value) {
        refreshIntervalElement.value = refreshIntervalText;
      }
    }
    // Fit within bounds
    var minutes = parseInt(refreshIntervalText, 10);
    if (isNaN(minutes)) {
      minutes = 1;
      refreshIntervalElement.value = "";
    } else if (minutes < 1) {
      minutes = 1;
      refreshIntervalElement.value = 1;
    } else if (minutes > 60) {
      minutes = 60;
    }
    // Set the prefs value
    return minutes * 60;
  }
};

var gFeedsPane = {
  autoMarkAsRead: function gFeedsPane_autoMarkAsRead(aEvent) {
    var autoMark = document.getElementById("flock.feeds.auto_mark_as_read");
    var streamReaderPref =
        document.getElementById("flock.notification.show.feeds-subscribed");
    streamReaderPref.value = autoMark.value;
    aEvent.stopPropagation();
  }
};

var gFlockTabsPane = {
  /** 
   * Determines where a link which opens a new window will open.
   *
   * @returns 1 if such links should be opened in current tab,
   *          2 if such links should be opened in new windows,
   *          3 if such links should be opened in new tabs
   */
  readLinkTarget: function gFlockTabsPane_readLinkTarget() {
    var openExternal = document.getElementById("browser.link.open_external")
                               .value;
    if (openExternal > 3 || openExternal < 1) {
      openExternal = 2;
    }
    return openExternal;
  },

  /**
   * Ensures that pages opened in new windows by web pages and pages opened by
   * external applications both open in the same way (e.g. in a new tab,
   * window, etc.).
   *
   * @returns 2 if such links should be opened in new windows,
   *          3 if such links should be opened in new tabs
   */
  writeLinkTarget: function gFlockTabsPane_writeLinkTarget() {
    var linkTargeting = document.getElementById("linkTargeting");
    var newValue = linkTargeting.value;
    if (newValue == 1) {
      // never open in the current tab
      newValue = 2;
    }
    document.getElementById("browser.link.open_newwindow").value = newValue;
    return newValue;
  }
};
