// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

var notesButtonObserver = {
  getSupportedFlavours: function () {
    var flavours = new FlavourSet();
    flavours.appendFlavour("application/x-flock-rich-content");
    flavours.appendFlavour('text/html');
    flavours.appendFlavour("text/unicode");
    flavours.appendFlavour('text/x-moz-url');
    flavours.appendFlavour('application/x-moz-file','nsIFile');
    return flavours;
  },
  onDragOver: function (aEvt, aFlavour, aSession) {
    // put code to change button style while hovered
  },
  onDrop: function (aEvt, aDropData, aSession) {
    //sendToShelf(aEvt);

    // Files from desktop are not supported
    // (for some reason, files appear as text/unicode)
    if ((aDropData.flavour.contentType == "text/unicode") && (aDropData.data.substring(0, 7) == "file://")) {
      return false;
    }
    
    var data = flock_getMarkedUpSelection(aSession);
    addObject(data, null, null);
    giveClipboardFeedback();
    return true;
  }
}
