// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

var FlockTopbar = {
  prefs: Components.classes["@mozilla.org/preferences-service;1"]
                   .getService(Components.interfaces.nsIPrefBranch),
  PREF_LOCATION: "flock.minibar.location",
  PREF_OPEN: "flock.minibar.open",
  PREF_ID: "flock.minibar.objId",
  currLocation: null
};

FlockTopbar.JSCtx =
function FlockTopbar_JSCtx() {
  return top.document.getElementById("topbarBrowser").contentWindow;
};

FlockTopbar.hideExtensionArea =
function FlockTopbar_hideExtensionArea() {
  // show the main Extension UI
  document.getElementById("flock_TopbarUIExtensionArea")
          .removeAttribute("collapsed");
  // Collapse extension areas
  var extArea = document.getElementById("flock_TopbarUIExtensionArea");
  for (var i = 0; i < extArea.childNodes.length; ++i) {
    extArea.childNodes.item(i).setAttribute("hidden", "true");
  }
};

FlockTopbar.hideBoxArea =
function FlockTopbar_hideBoxArea() {
  var extArea = document.getElementById("topbarBox");
  for (var i = 0; i < extArea.childNodes.length; ++i) {
    extArea.childNodes.item(i).setAttribute("hidden", "true");
  }
};

FlockTopbar.setHeight =
function FlockTopbar_setHeight(aHeight) {
  document.getElementById("topbarBox").setAttribute("height", aHeight);
};

FlockTopbar.hide =
function FlockTopbar_hide() {
  // modify this function so that it will clear the 
  // current "topbar" attribute
  // that we use in topbarOverlay.js

  var topbars = document.getElementById("flock_TopbarBroadcasterSet")
                        .childNodes;
  for (var i = 0; i < topbars.length; ++i) {
    var item = topbars[i];
    if (item.getAttribute("checked")) {
      item.removeAttribute("checked");
    }
  }

  document.getElementById("topbar").setAttribute("hidden", "true");
  document.getElementById("topbarBrowser").setAttribute("src", "");
  FlockTopbar.prefs.setBoolPref(FlockTopbar.PREF_OPEN, false);
};

FlockTopbar.move =
function FlockTopbar_move(aIgnoreLocation) {
  // modify this function so that it will set the location attribute
  // that we use in topbarOverlay.js to know where to put it on startup
  var location = null;
  if (FlockTopbar.prefs.getPrefType(FlockTopbar.PREF_LOCATION)) {
    location = FlockTopbar.prefs.getCharPref(FlockTopbar.PREF_LOCATION);
  }
  if (aIgnoreLocation) {
    // We don't want to move just open where it was last
    FlockTopbar.currLocation = null;
  }
  if (location == null ||
      (location == "top" && FlockTopbar.currLocation != "top"))
  {
    document.getElementById("appcontent").removeAttribute("dir");
    FlockTopbar.prefs.setCharPref(FlockTopbar.PREF_LOCATION, "top");
    FlockTopbar.currLocation = "top";
  } else if (location == "bottom" && FlockTopbar.currLocation == "bottom") {
    document.getElementById("appcontent").removeAttribute("dir");
    FlockTopbar.prefs.setCharPref(FlockTopbar.PREF_LOCATION, "top");
    FlockTopbar.currLocation = "top";
  } else {
    document.getElementById("appcontent").setAttribute("dir", "reverse");
    FlockTopbar.prefs.setCharPref(FlockTopbar.PREF_LOCATION, "bottom");
    FlockTopbar.currLocation = "bottom";
  }
  return FlockTopbar.currLocation;
};

FlockTopbar.load =
function FlockTopbar_load() {
  FlockTopbar.hideExtensionArea();
  FlockTopbar.hideBoxArea();

  try {
    if (FlockTopbar.prefs.getBoolPref(FlockTopbar.PREF_OPEN)) {
      FlockTopbar.selectById(FlockTopbar.prefs.getCharPref(FlockTopbar.PREF_ID));
    }
  } catch (ex) { /* top bar is closed by default */ }
};

FlockTopbar.selectById =
function FlockTopbar_selectById(aID, aStayOpen) {
  FlockTopbar.prefs.setCharPref(FlockTopbar.PREF_ID, aID);
  FlockTopbar.prefs.setBoolPref(FlockTopbar.PREF_OPEN, true);
  FlockTopbar.select(document.getElementById(aID), aStayOpen);
};

FlockTopbar.select =
function FlockTopbar_select(aObj, aStayOpen) {
  // modify this function so that it will set the attribute
  // that we use in topbarOverlay.js
  var topbarBrowser = document.getElementById("topbarBrowser");
  if (aObj.getAttribute("checked")) {
    if (aStayOpen) {
      return;
    }
    try {
      if (topbarBrowser.contentWindow.onunload) {
        topbarBrowser.contentWindow.onunload();
      }
      if (topbarBrowser.contentWindow.topbarUnload) {
        topbarBrowser.contentWindow.topbarUnload();
      }
    } catch (ex) {
      // Error unloading topbar
    }
    document.getElementById("topbar").setAttribute("hidden", "true");
    topbarBrowser.setAttribute("src", "");
    aObj.removeAttribute("checked");
    // We are closing so set the pref to close so when browser launches again
    // it knows
    FlockTopbar.prefs.setBoolPref(FlockTopbar.PREF_OPEN, false);
    return;
  }
  var topbars = document.getElementById("flock_TopbarBroadcasterSet")
                        .childNodes;
  for (var i = 0; i < topbars.length; ++i) {
    var item = topbars[i];
    if (item.getAttribute("checked")) {
      item.removeAttribute("checked");
    }
  }
  FlockTopbar.hideExtensionArea();

  // Setup extension area
  var extID = aObj.getAttribute("extID");
  if (extID) {
    if (document.getElementById(extID)) {
      document.getElementById(extID).removeAttribute("hidden");
    } else {
      // Only extension developers should see this
      alert("Error! You haven't properly specified extID in your topbar");
    }
  }
    
  var url = aObj.getAttribute("url");
  if (url) {
    if (url != topbarBrowser.getAttribute("src")) {
      var height = aObj.getAttribute("topbarHeight");
      if (height) {
        document.getElementById("topbarBox").setAttribute("height", height);
      }
      document.getElementById("topbar").removeAttribute("hidden");
      document.getElementById("topbarBrowser").removeAttribute("hidden");
      topbarBrowser.setAttribute("src", url);
    } 
    aObj.setAttribute("checked", "true");
  } else {
    document.getElementById("topbar").setAttribute("hidden", "true");
    topbarBrowser.setAttribute("src", "");
  }

  var onselect = aObj.getAttribute("onselect");
  if (onselect) {
    eval(onselect);
  }
  var value = aObj.getAttribute("value");
  FlockTopbar.move(true);
};
