/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.conn.Scheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchemeRegistry {
    private final Map<String, Scheme> registeredSchemes = new LinkedHashMap<String, Scheme>();

    public final synchronized Scheme getScheme(String name) {
        Scheme found = this.get(name);
        if (found == null) {
            throw new IllegalStateException("Scheme '" + name + "' not registered.");
        }
        return found;
    }

    public final synchronized Scheme getScheme(HttpHost host) {
        if (host == null) {
            throw new IllegalArgumentException("Host must not be null.");
        }
        return this.getScheme(host.getSchemeName());
    }

    public final synchronized Scheme get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        Scheme found = this.registeredSchemes.get(name);
        return found;
    }

    public final synchronized Scheme register(Scheme sch) {
        if (sch == null) {
            throw new IllegalArgumentException("Scheme must not be null.");
        }
        Scheme old = this.registeredSchemes.put(sch.getName(), sch);
        return old;
    }

    public final synchronized Scheme unregister(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        Scheme gone = this.registeredSchemes.remove(name);
        return gone;
    }

    public final synchronized List<String> getSchemeNames() {
        return new ArrayList<String>(this.registeredSchemes.keySet());
    }
}

