/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpConnection;

public class IdleConnectionHandler {
    private final Log LOG = LogFactory.getLog(IdleConnectionHandler.class);
    private Map<HttpConnection, Long> connectionToAdded = new HashMap<HttpConnection, Long>();

    public void add(HttpConnection connection) {
        Long timeAdded = System.currentTimeMillis();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Adding connection at: " + timeAdded));
        }
        this.connectionToAdded.put(connection, timeAdded);
    }

    public void remove(HttpConnection connection) {
        this.connectionToAdded.remove(connection);
    }

    public void removeAll() {
        this.connectionToAdded.clear();
    }

    public void closeIdleConnections(long idleTime) {
        long idleTimeout = System.currentTimeMillis() - idleTime;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Checking for connections, idleTimeout: " + idleTimeout));
        }
        Iterator<HttpConnection> connectionIter = this.connectionToAdded.keySet().iterator();
        while (connectionIter.hasNext()) {
            HttpConnection conn = connectionIter.next();
            Long connectionTime = this.connectionToAdded.get(conn);
            if (connectionTime > idleTimeout) continue;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Closing connection, connection time: " + connectionTime));
            }
            connectionIter.remove();
            try {
                conn.close();
            }
            catch (IOException ex) {
                this.LOG.debug((Object)"I/O error closing connection", (Throwable)ex);
            }
        }
    }
}

