/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire;

import com.frostwire.gnutella.gui.actions.BuyAction;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.OverlayAd;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDisplayer;
import com.limegroup.gnutella.security.SHA1;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import org.limewire.util.OSUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateManager
implements Serializable {
    private static final int OPTION_OPEN_URL = 1;
    private static final int OPTION_LATER = 0;
    private static final int OPTION_DOWNLOAD_TORRENT = 2;
    private static transient HashSet<UpdateMessage> _seenMessages;
    transient Timer _timer = null;
    transient UpdateMessage _updateMessage = null;
    transient HashSet<UpdateMessage> _announcements = null;
    private static UpdateManager INSTANCE;
    private Date _serverTime = null;

    public static void scheduleUpdateCheckTask(int secondsAfter) {
        TimerTask checkForUpdatesTask = new TimerTask(){

            public void run() {
                UpdateManager um = UpdateManager.getInstance();
                um.checkForUpdates();
                um.terminateUpdateCheckTask();
            }
        };
        UpdateManager.getInstance().getTimer().schedule(checkForUpdatesTask, secondsAfter * 1000);
    }

    public Timer getTimer() {
        if (this._timer == null) {
            this._timer = new Timer();
        }
        return this._timer;
    }

    public void terminateUpdateCheckTask() {
        this._timer.cancel();
    }

    private UpdateManager() {
    }

    public void setServerTime(String serverTime) {
        this._serverTime = null;
        try {
            this._serverTime = new Date(Long.parseLong(serverTime));
        }
        catch (Exception e) {
            System.out.println("Warning: UpdateManager.setServerTime(): Could not set time from server, using local time");
        }
        if (this._serverTime == null) {
            this._serverTime = Calendar.getInstance().getTime();
        }
    }

    public Date getServerTime() {
        return this._serverTime;
    }

    public void checkForUpdates() {
        UpdateMessageReader umr = new UpdateMessageReader();
        umr.readUpdateFile();
        if (umr.hasUpdateMessage() && umr.getUpdateMessage().getVersion() != null && !umr.getUpdateMessage().getVersion().trim().equals("") && UpdateManager.isFrostWireOld(umr.getUpdateMessage().getVersion())) {
            this.showUpdateMessage(umr.getUpdateMessage());
        }
        if (umr.hasAnnouncements()) {
            this.attemptShowAnnouncements(umr.getAnnouncements());
        }
        if (umr.hasOverlays()) {
            this.updateOverlays(umr.getOverlays(), umr);
        }
    }

    public void showUpdateMessage(UpdateMessage msg) {
        String title = msg.getMessageType().equals("update") ? "New FrostWire Update Available" : "FrostWire Team Announcement";
        int optionType = 2;
        if (msg.getUrl() != null && !msg.getUrl().trim().equals("")) {
            System.out.println("\t" + msg.getUrl());
            optionType |= 0;
        }
        Object[] options = new String[3];
        if (msg.getTorrent() != null) {
            options[2] = new String("Download Torrent");
        } else {
            options = new String[]{new String("Thanks, but not now"), new String("Go to webpage")};
        }
        int result = JOptionPane.showOptionDialog(null, msg.getMessage(), title, optionType, 1, null, options, null);
        if (result == 1) {
            GUIMediator.openURL(msg.getUrl());
        } else if (result == 2) {
            UpdateManager.openTorrent(msg.getTorrent());
        }
    }

    public void attemptShowAnnouncements(HashSet<UpdateMessage> announcements) {
        for (UpdateMessage msg : announcements) {
            if (msg.isShownOnce() && this.haveShownMessageBefore(msg) || msg.getUrl() == null || msg.getUrl().trim().equals("")) continue;
            this.showUpdateMessage(msg);
        }
    }

    public void updateOverlays(HashSet<UpdateMessage> overlays, UpdateMessageReader umr) {
        if (overlays == null) {
            System.out.println("UpdateManager.updateOverlays() Skipping, no overlays");
            return;
        }
        Iterator<UpdateMessage> iter = overlays.iterator();
        UpdateMessage message = null;
        while (iter.hasNext()) {
            message = iter.next();
            if (message.getVersion() != null && !message.getVersion().equals(LimeWireUtils.getLimeWireVersion()) || !umr.isMessageEligibleForMyOs(message)) continue;
            SearchResultDisplayer resultDisplayer = SearchMediator.RESULT_DISPLAYER;
            OverlayAd overlayAd = resultDisplayer.getOverlayAd();
            String imgUrl = message.getSrc();
            String linkUrl = message.getUrl();
            boolean canLink = linkUrl != null && !linkUrl.equals("");
            String torrentUrl = message.getTorrent();
            UISettings.ImageInfoImpl imageInfo = new UISettings.ImageInfoImpl(message.isIntro(), imgUrl, canLink, linkUrl, torrentUrl);
            if (message.isIntro()) {
                System.out.println("UPDATING THE INTRO MESSAGE");
                overlayAd.updateIntroInfo(imageInfo);
                continue;
            }
            System.out.println("UPDATING THE AFTER SEARCH MESSAGE");
            overlayAd.updateAfterSearchInfo(imageInfo);
        }
    }

    private void loadSeenMessages() {
        File f = new File("seenMessages.dat");
        _seenMessages = new HashSet();
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception e) {
                System.out.println("UpdateManager.loadSeenMessages() - Cannot create file to deserialize");
            }
            return;
        }
        if (f.length() == 0L) {
            return;
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
            _seenMessages = (HashSet)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            System.out.println("UpdateManager.loadSeenMessages() - Cannot deserialize - ");
            System.out.println(e);
        }
    }

    private void saveSeenMessages() {
        if (_seenMessages == null || _seenMessages.size() < 1) {
            return;
        }
        File f = new File("seenMessages.dat");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception e) {
                System.out.println("UpdateManager.saveSeenMessages() cannot create file to serialize seen messages");
            }
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(_seenMessages);
            oos.close();
        }
        catch (Exception e) {
            System.out.println("UpdateManager.saveSeenMessages() - Cannot serialize.");
            e.printStackTrace();
        }
    }

    public boolean haveShownMessageBefore(UpdateMessage msg) {
        if (!msg.isShownOnce()) {
            return false;
        }
        this.loadSeenMessages();
        if (_seenMessages == null || _seenMessages.size() == 0 || !_seenMessages.contains(msg)) {
            if (_seenMessages == null) {
                _seenMessages = new HashSet();
            }
            _seenMessages.add(msg);
            this.saveSeenMessages();
            return false;
        }
        return true;
    }

    public static boolean isFrostWireOld(String messageVersion) {
        String currentVersion = LimeWireUtils.getLimeWireVersion();
        if (currentVersion.equals(messageVersion)) {
            return false;
        }
        try {
            String[] fwVersionParts = currentVersion.split("\\.");
            int fw_major = Integer.parseInt(fwVersionParts[0]);
            int fw_release = Integer.parseInt(fwVersionParts[1]);
            int fw_service = Integer.parseInt(fwVersionParts[2]);
            String[] msgVersionParts = messageVersion.split("\\.");
            int msg_major = Integer.parseInt(msgVersionParts[0]);
            int msg_release = Integer.parseInt(msgVersionParts[1]);
            int msg_service = Integer.parseInt(msgVersionParts[2]);
            if (fw_major < msg_major) {
                return true;
            }
            if (fw_major == msg_major && fw_release < msg_release) {
                return true;
            }
            if (fw_major == msg_major && fw_release == msg_release && fw_service < msg_service) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static synchronized UpdateManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UpdateManager();
        }
        return INSTANCE;
    }

    public static void openTorrent(String uriStr) {
        try {
            URI uri = new URI(uriStr);
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http")) {
                return;
            }
            String authority = uri.getAuthority();
            if (authority == null || authority.equals("") || authority.indexOf(32) != -1) {
                return;
            }
            GUIMediator.instance().openTorrentURI(uri);
        }
        catch (URISyntaxException e) {
            System.out.println(e);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
    }

    public static void main(String[] args) {
        System.out.println("Testing UpdateManager");
        UpdateManager.scheduleUpdateCheckTask(0);
    }

    static {
        INSTANCE = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateMessageReader
    implements ContentHandler {
        public UpdateMessage _bufferMessage = null;
        public UpdateMessage _updateMessage = null;
        public HashSet<UpdateMessage> _announcements = null;
        public HashSet<UpdateMessage> _overlays = null;

        private UpdateMessageReader() {
        }

        public void UpdateMessageReader() {
        }

        public boolean hasUpdateMessage() {
            return this._updateMessage != null;
        }

        public boolean hasOverlays() {
            return this._overlays != null && this._overlays.size() > 0;
        }

        public boolean hasAnnouncements() {
            return this._announcements != null && this._announcements.size() > 0;
        }

        public void setUpdateMessage(UpdateMessage msg) {
            if (this._updateMessage == null && msg != null && msg.getMessageType().equals("update")) {
                this._updateMessage = msg;
            }
        }

        public UpdateMessage getUpdateMessage() {
            return this._updateMessage;
        }

        public void addOverlay(UpdateMessage msg) {
            if (msg != null && msg.getMessageType().equals("overlay")) {
                if (this._overlays == null) {
                    this._overlays = new HashSet();
                }
                this._overlays.add(msg);
            }
        }

        public void addAnnouncement(UpdateMessage msg) {
            if (this._announcements == null) {
                this._announcements = new HashSet();
            }
            if (msg.getMessageType().equals("announcement") && !msg.hasExpired()) {
                this._announcements.add(msg);
            }
        }

        public HashSet<UpdateMessage> getAnnouncements() {
            return this._announcements;
        }

        public HashSet<UpdateMessage> getOverlays() {
            return this._overlays;
        }

        public void readUpdateFile() {
            HttpURLConnection connection = null;
            InputSource src = null;
            try {
                connection = (HttpURLConnection)new URL("http://update.frostwire.com/").openConnection();
                String userAgent = "FrostWire/" + OSUtils.getOS() + "/" + LimeWireUtils.getLimeWireVersion();
                connection.setRequestProperty("User-Agent", userAgent);
                src = new InputSource(connection.getInputStream());
                XMLReader rdr = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
                rdr.setContentHandler(this);
                rdr.parse(src);
                connection.getInputStream().close();
                connection.disconnect();
            }
            catch (IOException e) {
                System.out.println("UpdateMessageReader.readUpdateFile() exception " + e.toString());
            }
            catch (SAXException e2) {
                System.out.println("UpdateMessageReader.readUpdateFile() exception " + e2.toString());
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equalsIgnoreCase("update")) {
                UpdateManager.getInstance().setServerTime(atts.getValue("time"));
                if (atts.getValue("buyUrl") != null) {
                    BuyAction.setRedirectUrl(atts.getValue("buyUrl"));
                }
            } else if (localName.equalsIgnoreCase("message")) {
                String type = atts.getValue("type");
                String message = atts.getValue("value");
                String url = atts.getValue("url");
                String torrent = atts.getValue("torrent");
                String os = atts.getValue("os");
                String showOnce = atts.getValue("showOnce");
                String version = atts.getValue("version");
                String src = atts.getValue("src");
                this._bufferMessage = new UpdateMessage(type, message);
                this._bufferMessage.setUrl(url);
                this._bufferMessage.setTorrent(torrent);
                this._bufferMessage.setOs(os);
                this._bufferMessage.setShowOnce(showOnce);
                this._bufferMessage.setVersion(version);
                if (this._bufferMessage.getMessageType().equals("announcement")) {
                    this._bufferMessage.setExpiration(atts.getValue("expiration"));
                }
                if (this._bufferMessage.getMessageType().equals("overlay")) {
                    this._bufferMessage.setSrc(src);
                    if (atts.getValue("intro") != null && (atts.getValue("intro").equals("1") || atts.getValue("intro").equalsIgnoreCase("true") || atts.getValue("intro").equalsIgnoreCase("yes"))) {
                        this._bufferMessage.setIntro(true);
                    } else {
                        this._bufferMessage.setIntro(false);
                    }
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        private boolean isMessageEligibleForMyOs(UpdateMessage msg) {
            if (msg.getOs() == null) {
                return true;
            }
            boolean im_mac_msg_for_me = msg.getOs().equals("mac") && OSUtils.isMacOSX();
            boolean im_windows_msg_for_me = msg.getOs().equals("windows") && (OSUtils.isWindows() || OSUtils.isWindowsXP() || OSUtils.isWindowsNT() || OSUtils.isWindows98() || OSUtils.isWindows95() || OSUtils.isWindowsMe() || OSUtils.isWindowsVista());
            boolean im_linux_msg_for_me = msg.getOs().equals("linux") && OSUtils.isLinux();
            return im_mac_msg_for_me || im_windows_msg_for_me || im_linux_msg_for_me;
        }

        private boolean isMessageForMe(UpdateMessage msg) {
            if (msg.getOs() == null) {
                return true;
            }
            if (msg.getVersion() != null && msg.getMessageType().equals("announcement")) {
                return this.isMessageEligibleForMyOs(msg) && !UpdateManager.isFrostWireOld(msg.getVersion());
            }
            return this.isMessageEligibleForMyOs(msg);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (this._bufferMessage != null && !this.isMessageForMe(this._bufferMessage)) {
                System.out.println("Discarding message - " + this._bufferMessage);
                this._bufferMessage = null;
                return;
            }
            if (this._bufferMessage != null && name.equalsIgnoreCase("message")) {
                if (this._bufferMessage.getMessageType().equals("update")) {
                    this.setUpdateMessage(this._bufferMessage);
                } else if (this._bufferMessage.getMessageType().equals("announcement")) {
                    this.addAnnouncement(this._bufferMessage);
                } else if (this._bufferMessage.getMessageType().equals("overlay")) {
                    this.addOverlay(this._bufferMessage);
                }
                this._bufferMessage = null;
            }
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }

    private class UpdateMessage
    implements Serializable {
        private int _hashCode = -1;
        public static final long serialVersionUID = 44L;
        private String _message;
        private String _url;
        private String _messageType;
        private String _version = null;
        private Date _expiration = null;
        private String _torrent = null;
        private String _os = null;
        private String _showOnce = "false";
        private String _src = "";
        private boolean _intro = false;

        public String getMessage() {
            return this._message;
        }

        public void setMessage(String m) {
            this._message = m;
        }

        public String getUrl() {
            return this._url;
        }

        public void setUrl(String u) {
            this._url = u;
        }

        public String getSrc() {
            return this._src;
        }

        public void setSrc(String src) {
            this._src = src;
        }

        public void setIntro(boolean intro) {
            this._intro = intro;
        }

        public boolean isIntro() {
            return this._intro;
        }

        public String getMessageType() {
            return this._messageType;
        }

        public String getOs() {
            return this._os;
        }

        public void setOs(String os) {
            this._os = null;
            if (os != null) {
                if ((os = os.trim()).equalsIgnoreCase("windows") || os.equalsIgnoreCase("linux") || os.equalsIgnoreCase("mac")) {
                    this._os = os.toLowerCase();
                } else if (os.equals("*")) {
                    this._os = null;
                }
            }
        }

        public String getTorrent() {
            return this._torrent;
        }

        public void setTorrent(String t) {
            this._torrent = t;
        }

        public void setMessageType(String mt) {
            if (mt == null || !mt.equalsIgnoreCase("update") && !mt.equalsIgnoreCase("announcement") && !mt.equalsIgnoreCase("overlay")) {
                this._messageType = new String("update");
                return;
            }
            this._messageType = mt.toLowerCase();
        }

        public Date getExpiration() {
            return this._expiration;
        }

        public void setExpiration(Date exp) {
            this._expiration = exp;
        }

        public void setExpiration(String expTimestamp) {
            if (expTimestamp == null || expTimestamp.equals("0")) {
                this._expiration = null;
                return;
            }
            try {
                this._expiration = new Date(Long.parseLong(expTimestamp));
            }
            catch (NumberFormatException e) {
                System.out.println("Expiration passed cannot be converted to a long");
                this._expiration = null;
            }
        }

        public boolean hasExpired() {
            if (this.getExpiration() == null) {
                return false;
            }
            long serverTimestamp = UpdateManager.getInstance().getServerTime().getTime();
            long myTimestamp = this._expiration.getTime();
            return myTimestamp < serverTimestamp;
        }

        public String getVersion() {
            if (this._version != null && this._version.equals("")) {
                this._version = null;
            }
            return this._version;
        }

        public void setVersion(String v) {
            this._version = v;
        }

        public boolean isShownOnce() {
            return this._showOnce.equalsIgnoreCase("true");
        }

        public void setShowOnce(String s) {
            if (s != null) {
                this._showOnce = s;
            }
        }

        public UpdateMessage(String msgType, String message) {
            this.setMessageType(msgType);
            this.setMessage(message);
        }

        public boolean equals(Object obj) {
            return obj.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this._hashCode <= 0) {
                SHA1 md = new SHA1();
                String byteString = this._message + this._url + this._messageType + this._version + this._torrent + this._os + this._showOnce;
                md.update(byteString.getBytes());
                byte[] digest = md.digest();
                this._hashCode = 0;
                for (byte n : digest) {
                    this._hashCode += Math.abs(n);
                }
            }
            return this._hashCode;
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
        }

        public String toString() {
            String s = new String();
            s = "\n";
            s = s + "UpdateMessage @" + String.valueOf(super.hashCode());
            s = s + "{";
            s = s + "_hashCode : " + String.valueOf(this.hashCode()) + ", \n";
            s = s + "_message : " + this.getMessage() + ", \n";
            s = s + "_url : " + this.getUrl() + ", \n";
            s = s + "_messageType : " + this.getMessageType() + ", \n";
            s = s + "_version : " + this.getVersion() + ", \n";
            s = s + "_expiration : " + String.valueOf(this.getExpiration()) + ", \n";
            s = s + "_torrent : " + this.getTorrent() + ", \n";
            s = s + "_os : " + this.getOs() + ", \n";
            s = s + "_showOnce : " + this.isShownOnce() + ", \n";
            s = s + "}\n";
            return s;
        }
    }
}

