/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.connectiondoctor;

import com.limegroup.gnutella.LimeWireCore;
import com.limegroup.gnutella.bugs.RemoteClientInfo;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.EncodingUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.limewire.util.OSUtils;
import org.limewire.util.VersionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionDoctor {
    public static int MaxWaitingTime = 60;
    private static final Log LOG = LogFactory.getLog(ConnectionDoctor.class);
    private static final String CONNECTION_DR_URL = "http://doctor.frostwire.com/hosts/";
    private static final int CONNECT_TIMEOUT = 10000;
    private int MAXTRY = 2;
    private int CURRTRY = 0;

    public synchronized boolean loadHosts() {
        return this.loadHosts(CONNECTION_DR_URL);
    }

    /*
     * Exception decompiling
     */
    public synchronized boolean loadHosts(String remoteHost) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final NameValuePair[] getPostRequestParams() {
        LinkedList params = new LinkedList();
        this.append(params, "lang", EncodingUtils.encode(ApplicationSettings.getLanguage()));
        this.append(params, "fv", EncodingUtils.encode(LimeWireUtils.getLimeWireVersion()));
        this.append(params, "jv", EncodingUtils.encode(VersionUtils.getJavaVersion()));
        this.append(params, "os", EncodingUtils.encode(OSUtils.getOS()));
        this.append(params, "osv", EncodingUtils.encode(OSUtils.getOSVersion()));
        return params.toArray(new NameValuePair[params.size()]);
    }

    private final void append(List<? super NameValuePair> l, String k, String v) {
        if (v != null) {
            l.add(new BasicNameValuePair(k, v));
        }
    }

    private final String prop(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            return "?";
        }
        return value;
    }

    private void fail(RemoteClientInfo remoteInfo, Throwable e) {
        LOG.error("Error connecting to connection doctor", e);
        System.out.println("Error connecting to the doctor script: " + e);
        remoteInfo.connectFailed();
        ++this.CURRTRY;
        if (this.CURRTRY <= this.MAXTRY) {
            this.loadHosts();
        }
    }

    public void initialize() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                LimeWireCore core = GuiCoreMediator.getCore();
                boolean ConnDocEnded = false;
                if (GuiCoreMediator.getConnectionServices().isConnected()) {
                    ConnDocEnded = true;
                }
                System.out.println("Initializing Connection Doctor...");
                int seconds = 0;
                while (!((GUIMediator.isConstructed() && GuiCoreMediator.getCore() != null && GuiCoreMediator.getLifecycleManager().isLoaded() || ConnDocEnded) && GuiCoreMediator.getConnectionServices().isConnected())) {
                    if (GuiCoreMediator.getConnectionServices().isConnecting() && !GuiCoreMediator.getConnectionServices().isConnected()) {
                        System.out.println("FrostWire's connection doctor will be started at " + MaxWaitingTime + " seconds, now waiting: " + ++seconds + " seconds");
                        if (seconds == MaxWaitingTime * 2) {
                            GUIMediator.showError(I18n.tr("FrostWire could not detect an internet connection. Please, check your firewall settings and try to restart FrostWire."));
                            ConnDocEnded = true;
                        }
                        if (seconds == MaxWaitingTime) {
                            System.out.println("****************Getting new hosts from Connection Doctor...*************");
                            ConnectionDoctor.this.loadHosts();
                            ConnDocEnded = true;
                        }
                        if (GuiCoreMediator.getConnectionServices().isConnected()) {
                            ConnDocEnded = true;
                        }
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {}
                }
                System.out.println("Connection Doctor timer is now ended. Interrupted?" + !ConnDocEnded);
            }
        });
        t.start();
    }
}

