/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.actions;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.LimeAction;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.event.ActionEvent;
import java.net.URLEncoder;
import javax.swing.AbstractAction;
import org.limewire.util.OSUtils;

public class BuyAction
extends AbstractAction
implements LimeAction {
    private TableLine _tableLine = null;
    private String _buyUrl = null;
    private static String redirect_url = null;

    public void setTableLine(TableLine tl) {
        this._tableLine = tl;
    }

    public TableLine getTableLine() {
        return this._tableLine;
    }

    public static void setRedirectUrl(String url) {
        redirect_url = url;
    }

    public static boolean hasRedirectUrl() {
        return redirect_url != null;
    }

    public static String getRedirectUrl() {
        if (!redirect_url.endsWith("/")) {
            redirect_url = redirect_url + "/";
        }
        return redirect_url;
    }

    public BuyAction() {
        this.putValue("LimeShortName", I18n.tr("Buy Item Now"));
        this.putValue("LimeIconName", "BUY");
    }

    private void prepareBuyUrl() {
        if (this.getTableLine() == null) {
            this._buyUrl = null;
            return;
        }
        String post = "http://www.amazon.com/gp/associates/link-types/searchbox.html?";
        String tag = "tag=frostwcom-20&";
        String creative = "creative=374005&";
        String campaign = "campaign=211041&";
        String adid = "adid=1YQ8K05FFCXQ9X16F37M&";
        String mode = "digital-music";
        MediaType mt = this.getTableLine().getNamedMediaType().getMediaType();
        String sha1 = this.getTableLine().getSHA1Urn().toString();
        String size = String.valueOf(this.getTableLine().getSize());
        if (mt.equals(MediaType.getAudioMediaType())) {
            mode = "mode=digital-music&";
        } else if (mt.equals(MediaType.getVideoMediaType())) {
            mode = "mode=amazontv&";
        } else if (mt.equals(MediaType.getImageMediaType())) {
            mode = "mode=photo&";
        } else if (mt.equals(MediaType.getDocumentMediaType())) {
            mode = "mode=books&";
        } else if (mt.equals(MediaType.getProgramMediaType())) {
            mode = "mode=software&";
        }
        String encoded_keywords = null;
        String fwUserAgent = "FrostWire/" + OSUtils.getOS() + "/" + LimeWireUtils.getLimeWireVersion();
        try {
            encoded_keywords = URLEncoder.encode(this.getCurrentFileKeywords(), "UTF-8");
            fwUserAgent = URLEncoder.encode(fwUserAgent, "UTF-8");
        }
        catch (Exception e) {
            encoded_keywords = "madonna";
        }
        String keyword = "keyword=" + encoded_keywords;
        this._buyUrl = new String();
        if (BuyAction.hasRedirectUrl()) {
            this._buyUrl = BuyAction.getRedirectUrl() + "?" + mode + "keywords=" + encoded_keywords + "&fwUseragent=" + fwUserAgent + "&sha1=" + sha1 + "&size=" + size;
            System.out.println("The Buy URL is: " + this._buyUrl);
        } else {
            this._buyUrl = post + tag + creative + campaign + adid + mode + keyword;
        }
    }

    private void openBuyUrl() {
        if (this._buyUrl != null) {
            GUIMediator.openURL(this._buyUrl);
        }
    }

    private String getCurrentFileKeywords() {
        if (this.getTableLine() == null) {
            return "radiohead";
        }
        String keywords = QueryUtils.createQueryString(this.getTableLine().getFilename());
        return keywords;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.getTableLine() != null) {
            this.prepareBuyUrl();
            this.openBuyUrl();
            this._buyUrl = null;
        }
    }
}

