/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.chat;

import com.frostwire.gnutella.gui.sponsors.BannerContainer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ChatSettings;
import irc.IRCApplication;
import irc.IRCConfiguration;
import irc.StartupConfiguration;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public final class ChatMediator
implements ThemeObserver {
    private static final JPanel MAIN_PANEL = new JPanel(new GridBagLayout());
    private static IRCApplication PJIRC;
    private static IRCConfiguration _config;
    private BannerContainer bannerContainer;
    private boolean _chatAlreadyStarted = false;
    private static final ChatMediator INSTANCE;

    public static ChatMediator instance() {
        return INSTANCE;
    }

    public JComponent getComponent() {
        return MAIN_PANEL;
    }

    public void updateTheme() {
    }

    private ChatMediator() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Community Chat..."));
        ThemeMediator.addThemeObserver(this);
        Runnable r = new Runnable(){

            public void run() {
                ChatMediator.this.updateSplashScreen();
                System.out.println("Trying to start chat panel...");
                ChatMediator.this.tryToStartAndAddChat();
                System.out.println("end of try...");
            }
        };
        new Thread(r).start();
    }

    public void reloadConfiguration() {
        System.out.println("initializing chat community...");
        IRCConfiguration ircConfiguration = IRCConfiguration.createDummyIRCConfiguration();
        ircConfiguration.set("gui", new String("pixx"));
        String currlang = ApplicationSettings.LANGUAGE.getValue();
        Hashtable<String, String> defaultRooms = new Hashtable<String, String>();
        defaultRooms.put("en", "Main");
        defaultRooms.put("nl", "Hollands");
        defaultRooms.put("pt", "Portugues");
        defaultRooms.put("fr", "Francais");
        defaultRooms.put("de", "Deutsch");
        defaultRooms.put("es", "Espanol");
        defaultRooms.put("tr", "Turkce");
        defaultRooms.put("no", "Norsk");
        defaultRooms.put("da", "Dansk");
        defaultRooms.put("it", "Italiano");
        defaultRooms.put("sv", "Svenska");
        defaultRooms.put("pl", "Polski");
        defaultRooms.put("cz", "Cesko");
        defaultRooms.put("tl", "Tagalog");
        defaultRooms.put("ja", "Nihongo");
        defaultRooms.put("fi", "Suomi");
        defaultRooms.put("hu", "Magyar");
        defaultRooms.put("el", "Greek");
        String defaultRoom = defaultRooms.containsKey(currlang) ? (String)defaultRooms.get(currlang) : "Main";
        StartupConfiguration startupConfiguration = new StartupConfiguration(ChatSettings.CHAT_IRC_NICK.getValue(), ChatSettings.CHAT_IRC_NICK.getValue() + "????", "[P:RX{0,G}]", new String[]{""}, new String[]{"chat.peercommons.net"}, new int[]{6667}, "", new String[]{new String("JOIN #" + defaultRoom)}, new String[]{"buttons.Smileys"}, ChatSettings.SMILEYS_ENABLED.getValue());
        System.out.println("Creating new IRC App...");
        PJIRC = new IRCApplication(ircConfiguration, startupConfiguration, MAIN_PANEL);
        _config = ircConfiguration;
        System.out.println("Initializing new IRC App...");
        PJIRC.init();
        System.out.println("Initialized! new IRC App...");
    }

    public void tryToStartAndAddChat() {
        if (this._chatAlreadyStarted) {
            return;
        }
        this.reloadConfiguration();
        try {
            System.out.println("getting nick: " + ChatSettings.CHAT_IRC_NICK.getValue().toLowerCase() + "Chat enabled?: " + Boolean.valueOf(ChatSettings.CHAT_IRC_ENABLED.getValue()));
            if (ChatSettings.CHAT_IRC_NICK.getValue().toLowerCase().trim().startsWith("fw_guest") && ChatSettings.CHAT_IRC_ENABLED.getValue()) {
                System.out.println("***IRC CHAT IS CURRENTLY DISABLED***");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        MAIN_PANEL.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 21;
        c.weightx = 1.0;
        c.weighty = 1.0;
        MAIN_PANEL.add(PJIRC.getIRCInterface().getComponent(), c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 1;
        c.fill = 0;
        c.anchor = 22;
        this.bannerContainer = new BannerContainer();
        MAIN_PANEL.add((Component)this.bannerContainer, c);
        this._chatAlreadyStarted = true;
        ThemeMediator.addThemeObserver(this);
        this.updateTheme();
    }

    public void disconnect() {
    }

    public void connect() {
    }

    public void nick(String newNick) {
        PJIRC.sendString("/nick " + newNick);
    }

    public void smileyswindow() {
        System.out.println("Showing smileys...");
        PJIRC.sendString("/smileys");
    }

    public void changesmileys(boolean newstatus) {
        System.out.println("Changing smileys status...");
        Object txtnewstatus = null;
        if (newstatus) {
            _config.restoreSmileyTable();
            System.out.println("Smileys are now enabled!");
        } else {
            System.out.println("Status is now disabled!");
            _config.resetSmileyTable();
        }
    }

    protected JPopupMenu createPopupMenu() {
        return null;
    }

    protected void setupConstants() {
    }

    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Community Chat Window..."));
    }

    public void handleNoSelection() {
    }

    public void handleNoSelection(int a) {
    }

    public void handleSelection(int row) {
    }

    public void handleActionKey() {
    }

    static {
        INSTANCE = new ChatMediator();
    }
}

