/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.sponsors;

import com.frostwire.gnutella.gui.sponsors.SponsorBanner;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BannerContainer
extends JPanel {
    private CardLayout layout = new CardLayout();
    private HashSet<SponsorBanner> banners;
    private Timer bannerSwitcher;
    private Timer bannerRefresher;
    private SponsorBanner currentBanner;
    private int DEFAULT_BANNER_REFRESH_RATE = 10;
    private long lastTimeSwitched = 0L;

    public BannerContainer() {
        this.setLayout(this.layout);
        this.refreshBanners();
        this.setupMouseListeners();
    }

    public BannerContainer(HashSet<SponsorBanner> banners) {
        this.setLayout(this.layout);
        this.setBanners(banners);
        this.setupMouseListeners();
        this.setupBannerRefreshTask(this.DEFAULT_BANNER_REFRESH_RATE);
    }

    public void setupBannerRefreshTask(int intervalInSeconds) {
        if (intervalInSeconds == -1) {
            if (this.bannerRefresher != null) {
                this.bannerRefresher.cancel();
            }
            this.bannerRefresher = null;
            System.out.println("BannerContainer.setupBannerRefreshTask() - No banner refresh for me.");
            return;
        }
        intervalInSeconds *= 1000;
        if (this.bannerRefresher != null) {
            this.bannerRefresher.cancel();
            this.bannerRefresher = null;
        }
        System.out.println("BannerContainer.setupBannerRefreshTask() - Refreshing every " + String.valueOf(intervalInSeconds) + "secs");
        this.bannerRefresher = new Timer(true);
        this.bannerRefresher.scheduleAtFixedRate((TimerTask)new BannersRefreshTask(this), intervalInSeconds, (long)intervalInSeconds);
    }

    private void setupMouseListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                BannerContainer.this.lastTimeSwitched = 0L;
                BannerContainer.this.switchBanner();
            }
        });
    }

    public void removeAllBanners() {
        if (this.banners != null && this.getComponentCount() > 0) {
            System.out.println("BannerContainer.setBanners -> Removing all banners");
            this.bannerSwitcher.cancel();
            this.removeAll();
        }
    }

    public void setBanners(HashSet<SponsorBanner> banners) {
        this.banners = null;
        this.banners = banners;
        Iterator<SponsorBanner> iterator = this.banners.iterator();
        System.out.println("BannerContainer.banners.size() -> " + this.banners.size());
        if (this.bannerSwitcher != null) {
            this.bannerSwitcher.cancel();
            this.bannerSwitcher.purge();
        }
        this.bannerSwitcher = new Timer(true);
        while (iterator.hasNext()) {
            SponsorBanner banner = iterator.next();
            this.add((Component)banner, banner.getImageSrc());
        }
        this.repaint();
        this.lastTimeSwitched = Calendar.getInstance().getTimeInMillis();
        this.bannerSwitcher.scheduleAtFixedRate((TimerTask)new BannerSwitchTask(this), 0L, 5000L);
    }

    public void refreshBanners() {
        System.out.println("Removing previous banners...");
        this.removeAllBanners();
        System.out.println("Getting banners from server...");
        this.setBanners(new SponsorBanner().getBannersFromServer(this));
        System.out.println("Refresh ended");
    }

    public SponsorBanner getCurrentShownBanner() {
        for (SponsorBanner banner : this.banners) {
            if (!banner.isShowing()) continue;
            return banner;
        }
        return null;
    }

    public void switchBanner() {
        long timeOfExpiration;
        SponsorBanner currentBanner = this.getCurrentShownBanner();
        if (currentBanner == null) {
            return;
        }
        long duration = (long)currentBanner.getDuration() * 1000L;
        long now = Calendar.getInstance().getTimeInMillis();
        if (now > (timeOfExpiration = this.lastTimeSwitched + duration)) {
            this.lastTimeSwitched = now;
            this.layout.next(this);
            this.repaint();
        }
    }

    private class BannersRefreshTask
    extends TimerTask {
        private BannerContainer container;

        public BannersRefreshTask(BannerContainer container) {
            this.container = container;
        }

        public void run() {
            System.out.println("BannerRefreshTask.run() - Reload banners from server");
            this.container.refreshBanners();
        }
    }

    private class BannerSwitchTask
    extends TimerTask {
        private BannerContainer container;

        public BannerSwitchTask(BannerContainer container) {
            this.container = container;
        }

        public void run() {
            this.container.switchBanner();
        }
    }
}

