/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.sponsors;

import com.frostwire.gnutella.gui.sponsors.BannerContainer;
import com.limegroup.gnutella.LimeWireCore;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JLabel;
import org.limewire.util.OSUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SponsorBanner
extends JLabel {
    private SponsorLoader _sponsorLoader = new SponsorLoader();
    private static NetworkManager networkManager = null;
    public static String ipAddress = "0.0.0.0";
    private String url;
    private String imageSrc;
    private int width;
    private int height;
    private int duration;
    private Set<String> ipRanges = null;
    private String type = null;
    private HashMap<String, String> countries = null;
    private String language = null;
    private String locale = null;
    private String version = null;

    public static void fetchIpAddress() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                LimeWireCore core = GuiCoreMediator.getCore();
                networkManager = core.getNetworkManager();
                byte[] ipBytes = networkManager.getExternalAddress();
                System.out.println("Fetching ip address on separate thread");
                System.out.println("My IP address looks like this ->" + SponsorBanner.ipBytesToString(ipBytes));
                boolean seconds = false;
                while (!GUIMediator.isConstructed() || GuiCoreMediator.getCore() == null || !GuiCoreMediator.getLifecycleManager().isLoaded() || SponsorBanner.ipBytesToString(ipBytes).equals("0.0.0.0")) {
                    System.out.println("Waiting one more second to get the ipAddress");
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ipBytes = networkManager.getExternalAddress();
                    System.out.println("This is what the networkManager grabbed ->");
                    System.out.println(ipBytes);
                    System.out.println();
                }
                String ip = SponsorBanner.ipBytesToString(ipBytes);
                System.out.println("MY IP ADDRESS IS THIS ->>>> " + ip);
                ipAddress = ip;
            }
        });
        t.start();
    }

    public static String ipBytesToString(byte[] ip) {
        if (ip == null) {
            return new String("0.0.0.0");
        }
        int i = 0;
        String result = new String();
        while (i < ip.length) {
            result = ip[i] < 0 ? result + Integer.toString(256 + Integer.parseInt(Byte.toString(ip[i]))) : result + Byte.toString(ip[i]);
            if (++i >= ip.length) continue;
            result = result + ".";
        }
        return result;
    }

    public HashSet<SponsorBanner> getBannersFromServer(BannerContainer container) {
        SponsorLoader sponsorLoader = this.getSponsorLoader();
        if (container != null) {
            sponsorLoader.set_bannerContainer(container);
        }
        return sponsorLoader.loadBanners();
    }

    public SponsorLoader getSponsorLoader() {
        return this._sponsorLoader;
    }

    public SponsorBanner() {
    }

    public SponsorBanner(String url, String imageSrc, int width, int height, int duration, Set<String> ipRanges, String type, HashMap<String, String> countries, String language, String version) {
        this.setUrl(url);
        this.setImageSrc(imageSrc);
        this.setWidth(width);
        this.setHeight(height);
        this.setDuration(duration);
        this.setIpRanges(ipRanges);
        this.setVersion(version);
        this.setType(type);
        if (countries != null) {
            this.setCountries(countries);
        }
        if (language != null) {
            this.setLanguage(language);
        }
        this.setText("<html><img src=\"" + this.getImageSrc() + "\" width=\"" + this.getWidth() + "\" height=\"" + this.getHeight() + "\" border=\"0\"/></html>");
        this.setSize(new Dimension(this.getWidth(), this.getHeight()));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (SponsorBanner.this.getType() == null || SponsorBanner.this.getType().equals("web")) {
                    GUIMediator.openURL(SponsorBanner.this.getUrl());
                    return;
                }
                if (SponsorBanner.this.getType().equals("torrent")) {
                    String urlString = SponsorBanner.this.getUrl();
                    try {
                        URI uri = new URI(urlString);
                        String scheme = uri.getScheme();
                        if (scheme == null || !scheme.equalsIgnoreCase("http")) {
                            return;
                        }
                        String authority = uri.getAuthority();
                        if (authority == null || authority.equals("") || authority.indexOf(32) != -1) {
                            return;
                        }
                        GUIMediator.instance().openTorrentURI(uri);
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                    return;
                }
            }

            public void mouseEntered(MouseEvent evt) {
                SponsorBanner.this.setCursor(new Cursor(12));
            }

            public void mouseExited(MouseEvent evt) {
                SponsorBanner.this.setCursor(new Cursor(0));
            }
        });
    }

    public String getUrl() {
        return this.url;
    }

    public String getImageSrc() {
        return this.imageSrc;
    }

    @Override
    public int getWidth() {
        if (this.width <= 0) {
            return 120;
        }
        return this.width;
    }

    @Override
    public int getHeight() {
        if (this.height <= 0) {
            return 600;
        }
        return this.height;
    }

    public int getDuration() {
        if (this.duration <= 0) {
            return 300;
        }
        return this.duration;
    }

    public Set<String> getIpRanges() {
        return this.ipRanges;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getBannerLocale() {
        return this.locale;
    }

    public void addCountry(String country) {
        if (country == null) {
            return;
        }
        if (this.countries == null) {
            this.countries = new HashMap();
        }
        this.countries.put(country, country);
    }

    public boolean hasCountry(String country) {
        if (this.countries == null || country == null) {
            return false;
        }
        return this.countries.containsKey(country);
    }

    public void setCountries(HashMap<String, String> countries) {
        this.countries = countries;
    }

    public HashMap<String, String> getCountries() {
        return this.countries;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getSystemCountry() {
        String country = System.getProperty("user.country");
        if (country == null) {
            country = "";
        }
        return country;
    }

    public String getSystemLanguage() {
        if (this.language == null) {
            this.language = "";
        }
        return this.language;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setImageSrc(String src) {
        this.imageSrc = src;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void setDuration(int d) {
        this.duration = d;
    }

    public void setIpRanges(Set<String> ipRanges) {
        if (ipRanges != null && ipRanges.size() == 0) {
            ipRanges = null;
        }
        this.ipRanges = ipRanges;
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public void setType(String type) {
        if (type != null) {
            type = type.toLowerCase();
        }
        this.type = type;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setBannerLocale(String locale) {
        this.locale = locale;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SponsorLoader
    implements ContentHandler {
        public String ipAddress = new String("0.0.0.0");
        private boolean _status = false;
        private HashSet<SponsorBanner> _result = new HashSet();
        private BannerContainer _bannerContainer = null;

        private SponsorLoader() {
        }

        public HashSet<SponsorBanner> loadBanners() {
            HttpURLConnection connection = null;
            InputSource src = null;
            try {
                System.out.println("Loading banners...");
                connection = (HttpURLConnection)new URL("http://sponsors.frostwire.com/").openConnection();
                String userAgent = "FrostWire/" + OSUtils.getOS() + "/" + LimeWireUtils.getLimeWireVersion();
                System.out.println("User-Agent: " + userAgent);
                connection.setRequestProperty("User-Agent", userAgent);
                src = new InputSource(connection.getInputStream());
                XMLReader rdr = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
                rdr.setContentHandler(this);
                rdr.parse(src);
                connection.getInputStream().close();
                connection.disconnect();
            }
            catch (IOException e) {
                System.out.println("SponsorLoader._loadBanners() exception " + e.toString());
            }
            catch (SAXException e2) {
                System.out.println("SponsorLoader._loadBanners() exception " + e2.toString());
            }
            System.out.println("Banners loaded!");
            return this._result;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if ((localName = localName.toLowerCase()).equals("sponsors")) {
                String status = atts.getValue("status").toLowerCase();
                this._status = false;
                if (status != null && (status.equals("on") || status.equals("true") || status.equals("1"))) {
                    this._status = true;
                }
            } else if (localName.equals("banners") && this._status) {
                String refreshRate = atts.getValue("refreshrate");
                if (refreshRate != null) {
                    System.out.println("SponsorLoader.startElement -> Detected a custom refreshrate -> " + refreshRate);
                    if (refreshRate.equals("0") || refreshRate.equals("-1") || refreshRate.equalsIgnoreCase("no") || refreshRate.equalsIgnoreCase("none") || refreshRate.equalsIgnoreCase("false") || refreshRate.equalsIgnoreCase("off")) {
                        System.out.println("SponsorLoader.startElement -> Killing Banner Refresh Tasks");
                        this.get_bannerContainer().setupBannerRefreshTask(-1);
                    } else {
                        int refreshRateInt = -1;
                        try {
                            refreshRateInt = Integer.parseInt(refreshRate);
                            refreshRateInt = Math.abs(refreshRateInt);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (refreshRateInt > 0) {
                            System.out.println("SponsorLoader.startElement -> setting custom banner refresh task interval - " + refreshRateInt);
                            this.get_bannerContainer().setupBannerRefreshTask(refreshRateInt);
                        }
                    }
                }
            } else if (localName.equals("banner") && this._status) {
                String src = new String(atts.getValue("src"));
                String href = new String(atts.getValue("href"));
                int width = Integer.parseInt(atts.getValue("width"));
                int height = Integer.parseInt(atts.getValue("height"));
                int duration = Integer.parseInt(atts.getValue("duration"));
                HashSet<String> ipRanges = new HashSet<String>();
                if (atts.getValue("ipranges") != null) {
                    String[] ips;
                    String ipranges_string = atts.getValue("ipranges");
                    ipranges_string = ipranges_string.replaceAll("\\s", "");
                    for (String ip : ips = ipranges_string.split(",")) {
                        ipRanges.add(ip);
                    }
                } else {
                    ipRanges = null;
                }
                String type = null;
                if (atts.getValue("type") != null) {
                    type = new String(atts.getValue("type"));
                }
                HashMap<String, String> countries = null;
                if (atts.getValue("countries") != null) {
                    String[] countries_array;
                    countries = new HashMap<String, String>();
                    String countries_str = new String(atts.getValue("countries"));
                    countries_str = countries_str.trim();
                    for (String country : countries_array = countries_str.split(",")) {
                        countries.put(country.toUpperCase(), country.toUpperCase());
                    }
                }
                String language = null;
                if (atts.getValue("language") != null) {
                    language = new String(atts.getValue("language"));
                }
                String version = null;
                if (atts.getValue("version") != null) {
                    version = new String(atts.getValue("version"));
                }
                SponsorBanner banner = new SponsorBanner(href, src, width, height, duration, ipRanges, type, countries, language, version);
                if (version != null && !this.frostWireMatchesVersion(version)) {
                    System.out.println("Version mismatch - " + version);
                    return;
                }
                if (countries != null && !banner.hasCountry(banner.getSystemCountry())) {
                    return;
                }
                if (language != null && !language.equals("") && !banner.getSystemLanguage().equals(banner.getLanguage())) {
                    return;
                }
                if (ipAddress.equals("0.0.0.0")) {
                    SponsorBanner.fetchIpAddress();
                } else if (!ipAddress.equals("0.0.0.0") && banner.getIpRanges() != null && banner.getIpRanges().size() > 0 && !this.ipMatchesRanges(ipAddress, banner.getIpRanges())) {
                    return;
                }
                this._result.add(banner);
            }
        }

        public boolean frostWireMatchesVersion(String version) {
            String currentVersion = "4.17.5";
            if (version == null || version.equals("")) {
                return false;
            }
            String[] fwVersionParts = currentVersion.split("\\.");
            String fw_major = fwVersionParts[0];
            String fw_release = fwVersionParts[1];
            String fw_service = fwVersionParts[2];
            String[] versionParts = version.split("\\.");
            String v_major = versionParts[0];
            String v_release = versionParts[1];
            String v_service = versionParts[2];
            if (!v_major.equals("*") && !fw_major.equals(v_major)) {
                return false;
            }
            if (!v_release.equals("*") && !fw_release.equals(v_release)) {
                return false;
            }
            return v_service.equals("*") || fw_service.equals(v_service);
        }

        public boolean ipMatchesRanges(String ip, Set<String> ipRanges) {
            if (ip == null || ip.equals("0.0.0.0")) {
                return false;
            }
            if (ipRanges != null && ip != null) {
                Iterator<String> iterator = ipRanges.iterator();
                String ipRange = null;
                while (iterator.hasNext()) {
                    ipRange = iterator.next();
                    if (!this.ipMatchesRange(ip, ipRange)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean ipMatchesRange(String ip, String ipRange) {
            if (ip == null) {
                System.out.println("ip null");
                return false;
            }
            if (ipRange == null) {
                System.out.println("ipRange null");
                return false;
            }
            String[] ipOctets = ip.split("\\.");
            String[] ipRangeOctets = ipRange.split("\\.");
            int octetIndex = 0;
            if (ipOctets.length != ipRangeOctets.length) {
                return false;
            }
            for (String octet : ipOctets) {
                if (!(ipRangeOctets[octetIndex].equals("*") || ipRangeOctets[octetIndex].equals("x") || ipRangeOctets[octetIndex].equals(octet))) {
                    return false;
                }
                ++octetIndex;
            }
            return true;
        }

        @Override
        public void skippedEntity(String name) {
        }

        @Override
        public void processingInstruction(String target, String data) {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        public BannerContainer get_bannerContainer() {
            return this._bannerContainer;
        }

        public void set_bannerContainer(BannerContainer container) {
            this._bannerContainer = container;
        }
    }
}

