/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.controllers;

import com.frostwire.plugins.models.IPlugin;
import com.limegroup.gnutella.settings.PluginsSettings;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class PluginLoader {
    private static final Log LOG = LogFactory.getLog(PluginLoader.class);
    private static PluginLoader INSTANCE;
    private static String PLUGINS_FOLDER;
    private HashSet<URL> loadedJars = new HashSet();
    private Hashtable<String, URLClassLoader> classLoaders = new Hashtable();

    public IPlugin loadPlugin(String pluginName) {
        return null;
    }

    private PluginLoader() {
    }

    public static PluginLoader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PluginLoader();
        }
        return INSTANCE;
    }

    public boolean loadedJar(URL jarUrl) {
        return this.loadedJars.contains(jarUrl);
    }

    public boolean loadedJar(String jarPath) throws MalformedURLException {
        File f = new File(jarPath);
        return this.loadedJars.contains(f.toURI().toURL());
    }

    public HashSet getLoadedJars() {
        return this.loadedJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJar2Classpath(String jarFile) throws Exception {
        if (jarFile == null) {
            throw new Exception("PluginLoader.addJar2Classpath() - the jar file path can't be null");
        }
        File f = new File(jarFile);
        if (!f.exists()) {
            LOG.error("Jar doesn't exist (" + jarFile + ")");
            throw new Exception("PluginLoader.addJar2Classpath() - The jar file doesn't exist (" + jarFile + ")");
        }
        URL jarURL = null;
        try {
            jarURL = new URL("jar:file:" + jarFile + "!/");
            LOG.info("The jar as an url " + jarURL);
        }
        catch (Exception e) {
            LOG.error("Bad URL for jar (" + jarFile + "):\n" + e.toString() + " (" + jarURL + ")\n");
            return;
        }
        if (this.loadedJar(jarURL)) {
            LOG.info("Jar was already loaded (" + jarURL + ")");
            return;
        }
        Hashtable<String, URLClassLoader> hashtable = this.classLoaders;
        synchronized (hashtable) {
            this.getLoadedJars().add(jarURL);
        }
        this.classLoaders.put(jarFile, URLClassLoader.newInstance(new URL[]{jarURL}));
        LOG.info("Jar loaded (" + jarURL + ")");
    }

    public void runPythonFromJar(String pythonScriptName, String jarFile) throws MalformedURLException, Exception {
        if (!this.loadedJar(jarFile)) {
            this.addJar2Classpath(jarFile);
        }
        try {
            PySystemState pySys = new PySystemState();
            pySys.setClassLoader(this.classLoaders.get(jarFile));
            PythonInterpreter i = new PythonInterpreter(null, pySys);
            JarFile jFile = new JarFile(jarFile);
            ZipEntry zipEntry = jFile.getEntry(pythonScriptName);
            InputStream pythonInputStream = jFile.getInputStream(zipEntry);
            i.execfile(pythonInputStream);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public URLClassLoader getClassLoader4JarClasspath(String jarFile) {
        if (this.classLoaders.isEmpty() || !this.classLoaders.containsKey(jarFile)) {
            return null;
        }
        return this.classLoaders.get(jarFile);
    }

    static {
        PLUGINS_FOLDER = PluginsSettings.PLUGINS_FOLDER.getValue();
    }
}

