/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.controllers;

import com.frostwire.plugins.models.IPlugin;
import com.frostwire.plugins.models.MetaPlugin;
import com.frostwire.plugins.models.PluginInstallException;
import com.frostwire.plugins.models.PluginValidator;
import com.limegroup.gnutella.settings.PluginsSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.setting.StringSetting;

public final class PluginManager {
    private static final Log LOG = LogFactory.getLog(PluginManager.class);
    private static PluginManager INSTANCE;
    public static final File PLUGINS_FOLDER;
    private Hashtable AVAILABLE_PLUGINS;
    private Hashtable INSTALLED_PLUGINS;
    private Hashtable RUNNING_PLUGINS;

    private PluginManager() {
        LOG.debug("Created Plugin Manager Instance");
    }

    public void clearAvailablePlugins() {
        this.AVAILABLE_PLUGINS = null;
    }

    public void clearInstalledPlugins() {
        this.INSTALLED_PLUGINS = null;
        File f = new File(PluginsSettings.INSTALLED_PLUGINS_FILE.getValue());
        if (f.exists()) {
            try {
                f.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Hashtable getAvailablePlugins() {
        return this.AVAILABLE_PLUGINS;
    }

    public Hashtable getInstalledPlugins() {
        return this.INSTALLED_PLUGINS;
    }

    public Hashtable getRunningPlugins() {
        return this.RUNNING_PLUGINS;
    }

    public static PluginManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PluginManager();
        }
        return INSTANCE;
    }

    private Hashtable readPlugins(StringSetting PLUGINS_FILE) {
        Hashtable PLUGINS;
        try {
            FileInputStream input = new FileInputStream(PLUGINS_FILE.getValue());
            ObjectInputStream objectStream = new ObjectInputStream(input);
            PLUGINS = (Hashtable)objectStream.readObject();
        }
        catch (Exception e) {
            LOG.error("The INSTALLED_PLUGINS Hashset could not be loaded due to " + e.getMessage());
            PLUGINS = null;
        }
        return PLUGINS;
    }

    private void writePlugins(Hashtable PLUGINS, StringSetting PLUGINS_FILE) {
        if (PLUGINS == null || PLUGINS.size() == 0) {
            return;
        }
        File f = new File(PLUGINS_FILE.getValue());
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception e) {
                LOG.error(e);
            }
        } else {
            f.delete();
            f = new File(PLUGINS_FILE.getValue());
            try {
                f.createNewFile();
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        try {
            FileOutputStream output = new FileOutputStream(PLUGINS_FILE.getValue());
            ObjectOutputStream objectStream = new ObjectOutputStream(output);
            objectStream.writeObject(PLUGINS);
            objectStream.flush();
            objectStream.close();
            output.flush();
            output.close();
        }
        catch (Exception e) {
            System.out.println(e);
            LOG.error("The Hashset could not be written due to " + e.getMessage());
        }
    }

    public void readInstalledPlugins() {
        this.INSTALLED_PLUGINS = this.readPlugins(PluginsSettings.INSTALLED_PLUGINS_FILE);
    }

    public void writeInstalledPlugins() {
        this.writePlugins(this.INSTALLED_PLUGINS, PluginsSettings.INSTALLED_PLUGINS_FILE);
    }

    public void readAvailablePlugins() {
        this.clearAvailablePlugins();
        this.AVAILABLE_PLUGINS = this.readPlugins(PluginsSettings.AVAILABLE_PLUGINS_FILE);
    }

    public void writeAvailablePlugins() {
        this.writePlugins(this.AVAILABLE_PLUGINS, PluginsSettings.AVAILABLE_PLUGINS_FILE);
    }

    private void checkForInstalledPlugins() {
        File f = new File(PluginsSettings.INSTALLED_PLUGINS_FILE.getValue());
        if (!f.exists()) {
            this.INSTALLED_PLUGINS = null;
            try {
                f.createNewFile();
            }
            catch (Exception e) {
                // empty catch block
            }
            f = new File(PluginsSettings.INSTALLED_PLUGINS_FILE.getValue());
        } else {
            this.readInstalledPlugins();
        }
        if (this.INSTALLED_PLUGINS != null) {
            Iterator iterator = this.INSTALLED_PLUGINS.keySet().iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
    }

    public void checkForAvailablePluginsLocally() {
    }

    public void checkForAvailablePluginsRemotely() {
        PluginManager.getInstance().clearAvailablePlugins();
        PluginValidator.getInstance().refreshRemoteAvailablePlugins();
        this.AVAILABLE_PLUGINS = PluginValidator.getInstance().getAvailablePlugins();
        assert (this.AVAILABLE_PLUGINS != null);
    }

    public static void verifyPluginEnvironment(boolean refreshRemotePlugins) {
        if (!PLUGINS_FOLDER.exists()) {
            PLUGINS_FOLDER.mkdir();
        }
        PluginManager.getInstance().checkForAvailablePluginsLocally();
        if (refreshRemotePlugins || PluginManager.getInstance().AVAILABLE_PLUGINS == null || PluginManager.getInstance().AVAILABLE_PLUGINS.size() == 0) {
            PluginManager.getInstance().checkForAvailablePluginsRemotely();
        }
    }

    public void installPlugin(IPlugin p) throws PluginInstallException {
        if (p.isValid()) {
            throw new PluginInstallException("Plugin " + p.getName() + " invalid");
        }
        PluginManager.verifyPluginEnvironment(false);
    }

    public void uninstallPlugin(IPlugin p) {
    }

    public void runPlugin(IPlugin p) {
        p.run();
    }

    public void stopPlugin(IPlugin p) {
        if (this.RUNNING_PLUGINS != null && this.RUNNING_PLUGINS.containsKey(p.getName())) {
            this.RUNNING_PLUGINS.remove(p.getName());
        }
        p.stop();
    }

    public static void main(String[] args) {
        MetaPlugin plugin;
        PluginManager PM = PluginManager.getInstance();
        assert (PM != null);
        PluginManager.verifyPluginEnvironment(false);
        PM.checkForAvailablePluginsRemotely();
        Hashtable REMOTE_AVAILABLE_PLUGINS = (Hashtable)PM.getAvailablePlugins().clone();
        assert (REMOTE_AVAILABLE_PLUGINS != null);
        assert (REMOTE_AVAILABLE_PLUGINS.size() > 0);
        PM.writeAvailablePlugins();
        PM.clearAvailablePlugins();
        assert (PM.getAvailablePlugins() == null);
        assert (REMOTE_AVAILABLE_PLUGINS != null);
        PM.readAvailablePlugins();
        assert (PM.getAvailablePlugins() != null);
        Hashtable LOCAL_AVAILABLE_PLUGINS = PM.getAvailablePlugins();
        assert (!REMOTE_AVAILABLE_PLUGINS.equals(LOCAL_AVAILABLE_PLUGINS));
        assert (REMOTE_AVAILABLE_PLUGINS.size() == LOCAL_AVAILABLE_PLUGINS.size());
        Iterator iterator = LOCAL_AVAILABLE_PLUGINS.keySet().iterator();
        System.out.println("Local Available Plugins:\n\n");
        while (iterator.hasNext()) {
            String pluginKey = (String)iterator.next();
            plugin = (MetaPlugin)LOCAL_AVAILABLE_PLUGINS.get(pluginKey);
            System.out.println(plugin.asXML());
            System.out.println("=====================");
        }
        System.out.println("\n\nRemote Available Plugins:\n\n");
        for (String pluginKey : REMOTE_AVAILABLE_PLUGINS.keySet()) {
            plugin = (MetaPlugin)REMOTE_AVAILABLE_PLUGINS.get(pluginKey);
            System.out.println(plugin.asXML());
            System.out.println("=====================");
        }
    }

    static {
        PLUGINS_FOLDER = new File(PluginsSettings.PLUGINS_FOLDER.getValue());
    }
}

