/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.models;

import com.frostwire.plugins.models.IPlugin;
import com.frostwire.plugins.models.PluginValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetaPlugin
implements IPlugin,
Serializable {
    private static final Log LOG = LogFactory.getLog(MetaPlugin.class);
    protected String name;
    protected String title;
    protected String version;
    protected String minimumVersion;
    protected String lastVersion;
    protected String author;
    protected String organization;
    protected String website;
    protected String downloadURL;
    protected String md5Hash;
    protected int size;

    public String asXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<plugin name=\"%s\" ");
        sb.append("title=\"%s\" ");
        sb.append("author=\"%s\" ");
        sb.append("organization=\"%s\" ");
        sb.append("version=\"%s\" ");
        sb.append("minimumFrostWireVersion=\"%s\" ");
        sb.append("lastFrostWireVersion=\"%s\" ");
        sb.append("website=\"%s\" ");
        sb.append("downloadURL=\"%s\" ");
        sb.append("MD5=\"%s\" ");
        sb.append("size=\"%s\"/>");
        return String.format(sb.toString(), this.getName(), this.getTitle(), this.getAuthor(), this.getOrganization(), this.getVersion(), this.getMinimumFrostWireVersionSupported(), this.getLastFrostWireVersionSupported(), this.getWebsite(), this.getDownloadURL(), this.getMD5Hash(), String.valueOf(this.getSize()));
    }

    public void run() {
    }

    public void stop() {
    }

    public String getMD5Hash() {
        return this.md5Hash;
    }

    public void setMD5Hash(String md5) {
        this.md5Hash = md5;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(String s) {
        if (s == null || s.equals("")) {
            this.setSize(0);
            return;
        }
        this.setSize(Integer.parseInt(s));
    }

    public void setSize(int s) {
        this.size = Math.abs(s);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMinimumFrostWireVersionSupported() {
        return this.minimumVersion;
    }

    public void setMinimumFrostWireVersionSupported(String v) {
        this.minimumVersion = v;
    }

    public String getLastFrostWireVersionSupported() {
        return this.lastVersion;
    }

    public void setLastFrostWireVersionSupported(String v) {
        this.lastVersion = v;
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String a) {
        this.author = a;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String o) {
        this.organization = o;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String w) {
        this.website = w;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public void setDownloadURL(String u) {
        this.downloadURL = u;
    }

    private boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public boolean isValid() {
        if (this.isEmpty(this.getName())) {
            LOG.error("Plugin has no name");
            return false;
        }
        if (this.isEmpty(this.getTitle())) {
            LOG.error("Plugin " + this.getName() + " has no title");
            return false;
        }
        if (this.getSize() < 1) {
            LOG.error("Plugin " + this.getName() + " has no size");
            return false;
        }
        if (!PluginValidator.validateMinimumVersion(this.getMinimumFrostWireVersionSupported())) {
            LOG.error("Plugin " + this.getName() + " didn't comply with minimum version validation");
            return false;
        }
        if (!PluginValidator.validateLastVersion(this.getLastFrostWireVersionSupported())) {
            LOG.error("Plugin " + this.getName() + " didn't comply with last version validation");
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void readObjectNoData() throws ObjectStreamException {
    }
}

