/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.models;

import com.frostwire.UpdateManager;
import com.frostwire.plugins.models.IPlugin;
import com.frostwire.plugins.models.MetaPlugin;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.OSUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PluginValidator
implements ContentHandler {
    private static final Log LOG = LogFactory.getLog(PluginValidator.class);
    private static PluginValidator INSTANCE;
    private static String AVAILABLE_PLUGINS_MANIFEST_URL;
    private static Hashtable AVAILABLE_PLUGINS;
    private MetaPlugin bufferMetaPlugin;

    private PluginValidator() {
    }

    public static PluginValidator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PluginValidator();
        }
        return INSTANCE;
    }

    public void refreshRemoteAvailablePlugins() {
        HttpURLConnection connection = null;
        InputSource src = null;
        try {
            connection = (HttpURLConnection)new URL("http://plugins.frostwire.com/list").openConnection();
            String userAgent = "FrostWire-PluginValidator/" + OSUtils.getOS() + "/" + LimeWireUtils.getLimeWireVersion();
            connection.setRequestProperty("User-Agent", userAgent);
            src = new InputSource(connection.getInputStream());
            XMLReader rdr = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
            rdr.setContentHandler(this);
            rdr.parse(src);
            connection.getInputStream().close();
            connection.disconnect();
        }
        catch (IOException e) {
            System.out.println("PluginValidator.refreshRemoteValidPlugins() IOException " + e.toString());
        }
        catch (SAXException e2) {
            System.out.println("PluginValidator.refreshRemoteValidPlugins() SAXException " + e2.toString());
        }
    }

    public Hashtable getAvailablePlugins() {
        return AVAILABLE_PLUGINS;
    }

    private boolean validateHash(IPlugin p) {
        return true;
    }

    public static boolean validateMinimumVersion(String minVersion) {
        return !UpdateManager.isFrostWireOld(minVersion);
    }

    public static boolean validateLastVersion(String lastVersion) {
        if (lastVersion == null || lastVersion.equals("")) {
            return true;
        }
        return UpdateManager.isFrostWireOld(lastVersion);
    }

    private String tryGettingAttribute(Attributes atts, String attributeName) {
        return atts.getValue(attributeName) != null ? atts.getValue(attributeName) : null;
    }

    private MetaPlugin tryLoadingMetaPluginFromAttributes(Attributes atts) {
        this.bufferMetaPlugin = new MetaPlugin();
        this.bufferMetaPlugin.setName(this.tryGettingAttribute(atts, "name"));
        this.bufferMetaPlugin.setTitle(this.tryGettingAttribute(atts, "title"));
        this.bufferMetaPlugin.setAuthor(this.tryGettingAttribute(atts, "author"));
        this.bufferMetaPlugin.setOrganization(this.tryGettingAttribute(atts, "organization"));
        this.bufferMetaPlugin.setVersion(this.tryGettingAttribute(atts, "version"));
        this.bufferMetaPlugin.setMinimumFrostWireVersionSupported(this.tryGettingAttribute(atts, "minimumFrostWireVersion"));
        this.bufferMetaPlugin.setLastFrostWireVersionSupported(this.tryGettingAttribute(atts, "lastFrostWireVersion"));
        this.bufferMetaPlugin.setWebsite(this.tryGettingAttribute(atts, "website"));
        this.bufferMetaPlugin.setDownloadURL(this.tryGettingAttribute(atts, "downloadURL"));
        this.bufferMetaPlugin.setMD5Hash(this.tryGettingAttribute(atts, "MD5"));
        this.bufferMetaPlugin.setSize(this.tryGettingAttribute(atts, "size"));
        return this.bufferMetaPlugin;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equalsIgnoreCase("plugin")) {
            this.tryLoadingMetaPluginFromAttributes(atts);
            if (this.bufferMetaPlugin != null) {
                if (AVAILABLE_PLUGINS == null) {
                    AVAILABLE_PLUGINS = new Hashtable();
                }
                if (this.bufferMetaPlugin.isValid()) {
                    AVAILABLE_PLUGINS.put(this.bufferMetaPlugin.getName(), this.bufferMetaPlugin);
                }
            }
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endPrefixMapping(String arg0) throws SAXException {
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    public void setDocumentLocator(Locator arg0) {
    }

    public void skippedEntity(String arg0) throws SAXException {
    }

    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    private static final class MD5 {
        private MD5() {
        }

        public static String md5(File f) throws Exception {
            int num_read;
            MessageDigest m = MessageDigest.getInstance("MD5");
            byte[] buf = new byte[65536];
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            while ((num_read = ((InputStream)in).read(buf)) != -1) {
                m.update(buf, 0, num_read);
            }
            String result = new BigInteger(1, m.digest()).toString(16);
            if (result.length() < 32) {
                int paddingSize = 32 - result.length();
                for (int i = 0; i < paddingSize; ++i) {
                    result = "0" + result;
                }
            }
            System.out.println("MD5: " + result);
            return result;
        }
    }
}

