/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.tests;

import com.frostwire.plugins.controllers.PluginLoader;
import com.frostwire.plugins.controllers.PluginManager;
import com.limegroup.gnutella.settings.PluginsSettings;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class PluginLoaderTest
extends TestCase {
    private static Log LOG = LogFactory.getLog(PluginLoaderTest.class);
    private PluginManager PM;
    private PluginLoader PL;
    private ExecutorService executorService;

    public PluginLoaderTest(String name) {
        super(name);
    }

    public void setUp() {
        if (this.PM != null) {
            return;
        }
        this.PM = PluginManager.getInstance();
    }

    public void testItCanFetchSingletonsFromMainThread() {
        String hashCode = null;
        try {
            PythonInterpreter i = new PythonInterpreter();
            i.execfile("plugins/test/test.py");
            i.exec("plugin = MyPlugin()");
            PyObject plugin = i.get("plugin");
            PyObject plugin_manager = plugin.invoke("getPluginManagerInstance");
            hashCode = plugin_manager.invoke("hashCode").toString();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        PluginLoaderTest.assertEquals(hashCode, String.valueOf(this.PM.hashCode()));
    }

    public void testItCanFetchSingletonsFromPluginOnSeparateThread() {
        PluginLoaderTest.assertNotNull(this.PM);
        try {
            this.executorService = new ThreadPoolExecutor(10, 20, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            Future<String> pluginFuture = this.executorService.submit(new GetPluginManagerHashCodeCallable());
            while (!pluginFuture.isDone()) {
                LOG.info("waiting for future task...");
                Thread.currentThread();
                Thread.sleep(200L);
            }
            PluginLoaderTest.assertNotNull(pluginFuture);
            PluginLoaderTest.assertTrue(pluginFuture.isDone());
            PluginLoaderTest.assertFalse(pluginFuture.isCancelled());
            String resultFromFuture = pluginFuture.get();
            PluginLoaderTest.assertNotNull(resultFromFuture);
            PluginLoaderTest.assertNotNull(this.PM.hashCode());
            PluginLoaderTest.assertEquals(resultFromFuture, String.valueOf(this.PM.hashCode()));
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    private void pressEnter() {
        System.out.println("[Press Enter]");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            br.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testRunningClassFromDinamicallyAddedJar() throws Exception {
        LOG.info("java.home  = " + System.getProperty("java.home"));
        try {
            PluginLoader LOADER = PluginLoader.getInstance();
            String FOLDER_PLUGIN = PluginsSettings.PLUGINS_FOLDER.getValue();
            String jar_path = FOLDER_PLUGIN + "/brooklyn.jar";
            LOADER.addJar2Classpath(jar_path);
            URLClassLoader classLoader = LOADER.getClassLoader4JarClasspath(jar_path);
            Class<?> clazz = classLoader.loadClass("brooklyn.HelloFromJar");
            LOG.info("I GOT THE brooklyn.HelloFromJar class " + clazz);
            PluginLoaderTest.assertNotNull(clazz);
            Method sayHello = clazz.getMethod("sayHello", null);
            PluginLoaderTest.assertNotNull(sayHello);
            Object obj = clazz.newInstance();
            sayHello.invoke(obj, (Object[])null);
        }
        catch (Exception e) {
            LOG.error(e);
            e.printStackTrace();
            throw e;
        }
    }

    public void testRunningPluginFromJar() throws Exception {
        PluginLoader LOADER = PluginLoader.getInstance();
        String FOLDER_PLUGIN = PluginsSettings.PLUGINS_FOLDER.getValue();
        String jar_path = FOLDER_PLUGIN + "/brooklyn.jar";
        try {
            LOADER.runPythonFromJar("brooklyn.py", jar_path);
        }
        catch (Exception e) {
            LOG.error(e);
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GetPluginManagerHashCodeCallable
    implements Callable<String> {
        GetPluginManagerHashCodeCallable() {
        }

        @Override
        public String call() {
            String hashCode = null;
            try {
                PythonInterpreter i = new PythonInterpreter();
                i.execfile("plugins/test/test.py");
                i.exec("plugin = MyPlugin()");
                PyObject plugin = i.get("plugin");
                PyObject plugin_manager = plugin.invoke("getPluginManagerInstance");
                hashCode = plugin_manager.invoke("hashCode").toString();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            System.out.println("CALL() -> " + hashCode);
            return hashCode;
        }
    }
}

