/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentFileSystem;
import com.limegroup.bittorrent.disk.DiskManagerFactory;
import com.limegroup.bittorrent.disk.TorrentDiskManager;
import org.limewire.collection.BitField;
import org.limewire.collection.BitFieldSet;
import org.limewire.collection.BitSet;

public class BTContext
implements TorrentContext {
    private final BTMetaInfo info;
    private final BitSet fullSet = new FullBitSet();
    private final BitField fullBitField;
    private TorrentDiskManager diskManager;
    private final DiskManagerFactory diskManagerFactory;

    BTContext(BTMetaInfo info, DiskManagerFactory diskManagerFactory) {
        this.diskManagerFactory = diskManagerFactory;
        this.info = info;
        info.setContext(this);
        this.fullBitField = new BitFieldSet(this.fullSet, info.getNumBlocks());
        this.initializeDiskManager(false);
    }

    public TorrentDiskManager getDiskManager() {
        return this.diskManager;
    }

    public TorrentFileSystem getFileSystem() {
        return this.info.getFileSystem();
    }

    public BitField getFullBitField() {
        return this.fullBitField;
    }

    public BitSet getFullBitSet() {
        return this.fullSet;
    }

    public BTMetaInfo getMetaInfo() {
        return this.info;
    }

    public void initializeDiskManager(boolean complete) {
        this.diskManager = this.diskManagerFactory.getManager(this, this.info.getDiskManagerData(), complete);
    }

    private class FullBitSet
    extends BitSet {
        private static final long serialVersionUID = -2621319856548383315L;

        private FullBitSet() {
        }

        public void set(int i) {
        }

        public void clear(int i) {
        }

        public boolean get(int i) {
            return true;
        }

        public int cardinality() {
            return BTContext.this.info.getNumBlocks();
        }

        public int length() {
            return BTContext.this.info.getNumBlocks();
        }

        public int nextSetBit(int i) {
            if (i >= this.cardinality()) {
                return -1;
            }
            return i;
        }
    }
}

