/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTData;
import com.limegroup.bittorrent.BTDataImpl;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentFileSystem;
import com.limegroup.bittorrent.ValueException;
import com.limegroup.bittorrent.bencoding.Token;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.serial.BTDiskManagerMemento;
import com.limegroup.gnutella.downloader.serial.BTMetaInfoMemento;
import com.limegroup.gnutella.downloader.serial.BTMetaInfoMementoImpl;
import com.limegroup.gnutella.http.URIUtils;
import com.limegroup.gnutella.security.SHA1;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.InvalidDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTMetaInfo {
    private static final Log LOG = LogFactory.getLog(BTMetaInfo.class);
    private static final byte[] VERIFIED_HASH = new byte[0];
    private final List<byte[]> _hashes;
    private final int _pieceLength;
    private final TorrentFileSystem fileSystem;
    private final byte[] _infoHash;
    private final URN _infoHashURN;
    private final URI[] _trackers;
    private FileDesc _desc = null;
    private final BTDiskManagerMemento diskManagerData;
    private TorrentContext context;
    private long uploadedBefore;
    private volatile long uploadedNow;
    private final float historicRatio;
    private final boolean isPrivate;

    public int getPieceLength() {
        return this._pieceLength;
    }

    public TorrentFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public BTDiskManagerMemento getDiskManagerData() {
        return this.diskManagerData;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setContext(TorrentContext context) {
        if (context == null) {
            this.initRatio(context);
        }
        this.context = context;
    }

    private void initRatio(TorrentContext context) {
        if (this.historicRatio == 0.0f) {
            return;
        }
        this.uploadedBefore = (long)((float)context.getDiskManager().getBlockSize() * this.historicRatio);
    }

    long getAmountUploaded() {
        return this.uploadedNow;
    }

    void countUploaded(int uploaded) {
        this.uploadedNow += (long)uploaded;
    }

    float getRatio() {
        long downloaded = this.context.getDiskManager().getBlockSize();
        if (downloaded == 0L) {
            return 0.0f;
        }
        return (float)(this.uploadedBefore + this.uploadedNow) * 1.0f / (float)downloaded;
    }

    public boolean verify(byte[] sha1, int pieceNum) {
        byte[] hash = this._hashes.get(pieceNum);
        if (hash == VERIFIED_HASH) {
            return true;
        }
        boolean ok = Arrays.equals(sha1, hash);
        if (ok) {
            this._hashes.set(pieceNum, VERIFIED_HASH);
        }
        return ok;
    }

    public byte[] getInfoHash() {
        return this._infoHash;
    }

    public URN getURN() {
        return this._infoHashURN;
    }

    public FileDesc getFileDesc() {
        if (this._desc == null) {
            HashSet<URN> s = new HashSet<URN>();
            s.add(this.getURN());
            this._desc = new FakeFileDesc(this.fileSystem.getCompleteFile(), s);
        }
        return this._desc;
    }

    public void resetFileDesc() {
        this._desc = null;
    }

    public int getNumBlocks() {
        return (int)((this.fileSystem.getTotalSize() + (long)this._pieceLength - 1L) / (long)this._pieceLength);
    }

    public String getName() {
        return this.fileSystem.getName();
    }

    public URI[] getTrackers() {
        return this._trackers;
    }

    public MessageDigest getMessageDigest() {
        return new SHA1();
    }

    public static BTMetaInfo readFromBytes(byte[] torrent) throws IOException {
        try {
            Object metaInfo = Token.parse(torrent);
            if (!(metaInfo instanceof Map)) {
                throw new ValueException("metaInfo not a Map!");
            }
            return new BTMetaInfo(new BTDataImpl((Map)metaInfo));
        }
        catch (IOException bad) {
            LOG.error("read failed", bad);
            throw bad;
        }
    }

    public BTMetaInfo(BTMetaInfoMemento memento) throws InvalidDataException {
        this._hashes = memento.getHashes();
        ListIterator<byte[]> hashIter = this._hashes.listIterator();
        while (hashIter.hasNext()) {
            byte[] next = hashIter.next();
            if (next.length != 0) continue;
            hashIter.set(VERIFIED_HASH);
        }
        Integer pieceLength = memento.getPieceLength();
        this.fileSystem = new TorrentFileSystem(memento.getFileSystem());
        this._infoHash = memento.getInfoHash();
        try {
            this._infoHashURN = URN.createSHA1UrnFromBytes(this._infoHash);
        }
        catch (IOException e) {
            throw new InvalidDataException(e);
        }
        this._trackers = memento.getTrackers();
        Float ratio = Float.valueOf(memento.getRatio());
        this.diskManagerData = memento.getFolderData();
        if (this._hashes == null || pieceLength == null || this.fileSystem == null || this._infoHash == null || this._trackers == null || this.diskManagerData == null || ratio == null) {
            throw new InvalidDataException("cannot read BTMetaInfo");
        }
        if (this._trackers.length == 0) {
            throw new InvalidDataException("no trackers");
        }
        for (URI uri : this._trackers) {
            try {
                BTMetaInfo.validateURI(uri);
            }
            catch (ValueException e) {
                throw new InvalidDataException(e);
            }
        }
        this.historicRatio = ratio.floatValue();
        this._pieceLength = pieceLength;
        this.isPrivate = memento.isPrivate();
    }

    public BTMetaInfo(BTData data) throws IOException {
        try {
            URI trackerURI = URIUtils.toURI(data.getAnnounce());
            BTMetaInfo.validateURI(trackerURI);
            this._trackers = new URI[]{trackerURI};
        }
        catch (URISyntaxException e) {
            URIUtils.error(e);
            throw new ValueException("bad tracker: " + data.getAnnounce());
        }
        this.isPrivate = data.isPrivate();
        this._infoHash = data.getInfoHash();
        try {
            this._infoHashURN = URN.createSHA1UrnFromBytes(this._infoHash);
        }
        catch (IOException impossible) {
            throw new RuntimeException(impossible);
        }
        this._hashes = BTMetaInfo.parsePieces(data.getPieces());
        data.clearPieces();
        this._pieceLength = (int)data.getPieceLength().longValue();
        if (this._pieceLength <= 0) {
            throw new ValueException("bad metainfo - illegal piece length: " + data.getPieceLength());
        }
        this.diskManagerData = null;
        this.historicRatio = 0.0f;
        this.fileSystem = new TorrentFileSystem(data, this._hashes.size(), this._pieceLength, this._infoHash);
    }

    private static void validateURI(URI check) throws ValueException {
        if (check == null) {
            throw new ValueException("null URI");
        }
        if (!"http".equalsIgnoreCase(check.getScheme())) {
            throw new ValueException("unsupported tracker protocol: " + check.getScheme());
        }
        boolean hostOk = false;
        boolean bl = hostOk = check.getHost() != null;
        if (!hostOk) {
            throw new ValueException("invalid host");
        }
    }

    public synchronized BTMetaInfoMemento toMemento() {
        BTMetaInfoMementoImpl memento = new BTMetaInfoMementoImpl();
        memento.setFileSystem(this.fileSystem.toMemento());
        memento.setFolderData(this.context.getDiskManager().toMemento());
        memento.setHashes(this._hashes);
        memento.setInfoHash(this._infoHash);
        memento.setPieceLength(this._pieceLength);
        memento.setPrivate(this.isPrivate);
        memento.setRatio(this.getRatio());
        memento.setTrackers(this._trackers);
        return memento;
    }

    private static List<byte[]> parsePieces(byte[] pieces) throws ValueException {
        if (pieces.length % 20 != 0) {
            throw new ValueException("bad metainfo - bad pieces key");
        }
        ArrayList<byte[]> ret = new ArrayList<byte[]>(pieces.length / 20);
        for (int i = 0; i < pieces.length; i += 20) {
            byte[] hash = new byte[20];
            System.arraycopy(pieces, i, hash, 0, 20);
            ret.add(hash);
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FakeFileDesc
    extends FileDesc {
        public FakeFileDesc(File file, Set<? extends URN> s) {
            super(file, s, Integer.MAX_VALUE);
        }
    }
}

