/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTData;
import com.limegroup.bittorrent.TorrentFile;
import com.limegroup.bittorrent.ValueException;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.downloader.serial.TorrentFileSystemMemento;
import com.limegroup.gnutella.downloader.serial.TorrentFileSystemMementoImpl;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.limewire.collection.MultiCollection;
import org.limewire.util.Base32;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorrentFileSystem {
    private final String _name;
    private final long _totalSize;
    private final List<TorrentFile> _files;
    private final List<TorrentFile> _unmodFiles;
    private final Collection<File> _folders = new HashSet<File>();
    private Collection<File> _filesAndFolders;
    private final File _incompleteFile;
    private File _completeFile;

    public TorrentFileSystem(TorrentFileSystemMemento torrentFileSystemMemento) {
        this._name = torrentFileSystemMemento.getName();
        this._totalSize = torrentFileSystemMemento.getTotalSize();
        this._files = torrentFileSystemMemento.getFiles();
        this._unmodFiles = Collections.unmodifiableList(this._files);
        this._folders.addAll(torrentFileSystemMemento.getFolders());
        this._incompleteFile = torrentFileSystemMemento.getIncompleteFile();
        this._completeFile = torrentFileSystemMemento.getCompleteFile();
    }

    TorrentFileSystem(BTData data, int numHashes, long pieceLength, byte[] infoHash) throws IOException {
        this._name = CommonUtils.convertFileName(data.getName());
        if (this._name.length() == 0) {
            throw new ValueException("bad torrent name");
        }
        this._incompleteFile = new File(SharingSettings.INCOMPLETE_DIRECTORY.getValue(), Base32.encode(infoHash) + File.separator + this._name);
        this._completeFile = new File(SharingSettings.getSaveDirectory(this._name), this._name);
        if (!FileUtils.isReallyParent(SharingSettings.getSaveDirectory(this._name), this._completeFile)) {
            throw new SaveLocationException(1, this._completeFile);
        }
        if (data.getFiles() != null) {
            List<BTData.BTFileData> files = data.getFiles();
            ArrayList<TorrentFile> torrents = new ArrayList<TorrentFile>(files.size());
            for (BTData.BTFileData file : files) {
                TorrentFile f = new TorrentFile(file.getLength(), new File(this._completeFile, file.getPath()).getAbsolutePath());
                if (!FileUtils.isReallyInParentPath(this._completeFile, f)) {
                    throw new SaveLocationException(1, f);
                }
                torrents.add(f);
            }
            if (files.size() == 0) {
                throw new ValueException("bad metainfo, no files!");
            }
            long position = 0L;
            for (TorrentFile file : torrents) {
                file.setBegin((int)(position / pieceLength));
                file.setEnd((int)((position += file.length()) / pieceLength));
            }
            this._files = torrents;
            for (String folderPath : data.getFolders()) {
                this._folders.add(new File(this._completeFile, folderPath));
            }
            this._folders.add(this._completeFile);
        } else {
            TorrentFile f = new TorrentFile(data.getLength(), this._completeFile.getAbsolutePath());
            f.setBegin(0);
            f.setEnd(numHashes);
            this._files = new ArrayList<TorrentFile>(1);
            this._files.add(f);
        }
        this._unmodFiles = Collections.unmodifiableList(this._files);
        this._totalSize = TorrentFileSystem.calculateTotalSize(this._files);
        if (this._totalSize <= 0L) {
            throw new ValueException("invalid size " + this._totalSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorrentFileSystemMemento toMemento() {
        HashSet<File> folders;
        ArrayList<TorrentFile> files;
        TorrentFileSystemMementoImpl memento = new TorrentFileSystemMementoImpl();
        memento.setCompleteFile(this._completeFile);
        TorrentFileSystem torrentFileSystem = this;
        synchronized (torrentFileSystem) {
            files = new ArrayList<TorrentFile>(this._files);
            folders = new HashSet<File>(this._folders);
        }
        memento.setFiles(files);
        memento.setFolders(folders);
        memento.setIncompleteFile(this._incompleteFile);
        memento.setName(this._name);
        memento.setTotalSize(this._totalSize);
        return memento;
    }

    public long getTotalSize() {
        return this._totalSize;
    }

    public String getName() {
        return this._name;
    }

    public List<TorrentFile> getIncompleteFiles() {
        ArrayList<TorrentFile> ret = new ArrayList<TorrentFile>(this._files);
        this.updateReferences(this._incompleteFile, ret);
        return ret;
    }

    public List<TorrentFile> getFiles() {
        return this._unmodFiles;
    }

    public Collection<File> getFilesAndFolders() {
        if (this._filesAndFolders == null) {
            this._filesAndFolders = new MultiCollection<File>((Collection<File>)this._unmodFiles, Collections.unmodifiableCollection(this._folders));
        }
        return this._filesAndFolders;
    }

    public boolean conflicts(File f) {
        return this.getFilesAndFolders().contains(f);
    }

    public boolean conflictsIncomplete(File f) {
        return this.getBaseFile().getParentFile().equals(f);
    }

    public File getBaseFile() {
        return this._incompleteFile;
    }

    public File getCompleteFile() {
        return this._completeFile;
    }

    public void setCompleteFile(File f) {
        this.updateReferences(f, this._files);
        this.updateFolderReferences(f);
        this._completeFile = f;
    }

    private void updateReferences(File completeBase, List<TorrentFile> l) {
        int offset = this._completeFile.getAbsolutePath().length();
        String newPath = completeBase.getAbsolutePath();
        for (int i = 0; i < l.size(); ++i) {
            TorrentFile current = l.get(i);
            TorrentFile updated = new TorrentFile(current.length(), newPath + current.getPath().substring(offset));
            updated.setBegin(current.getBegin());
            updated.setEnd(current.getEnd());
            l.set(i, updated);
        }
    }

    private synchronized void updateFolderReferences(File completeBase) {
        int offset = this._completeFile.getAbsolutePath().length();
        String newPath = completeBase.getAbsolutePath();
        HashSet<File> newFolders = new HashSet<File>(this._folders.size());
        for (File f : this._folders) {
            newFolders.add(new File(newPath + f.getPath().substring(offset)));
        }
        this._folders.clear();
        this._folders.addAll(newFolders);
    }

    void moveToCompleteFolder() {
        File parent = this._incompleteFile.getParentFile();
        boolean success = this._incompleteFile.renameTo(this._completeFile);
        if (!success && (success = FileUtils.copy(this._incompleteFile, this._completeFile))) {
            this._incompleteFile.delete();
        }
        if (success) {
            FileUtils.deleteRecursive(parent);
        }
    }

    private static long calculateTotalSize(List<TorrentFile> files) {
        long ret = 0L;
        for (TorrentFile f : files) {
            ret += ((File)f).length();
        }
        return ret;
    }
}

