/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.util.Base32;

public class TorrentLocation
extends IpPortImpl {
    private static final long serialVersionUID = 7953314787152210101L;
    private static final byte[] NULL_PEER_STRING = new byte[20];
    private static final byte[] EXTENTION_BYTES = new byte[8];
    private static final int MAX_STRIKES = 1;
    private static final int BUSY_WAIT_TIME = 300000;
    private final byte[] PEER_ID;
    private final byte[] EXTENSION_BYTES;
    private int _strikes = 0;
    private long _nextRetryTime = 0L;

    public TorrentLocation(InetSocketAddress address, byte[] peerId, byte[] extensionBytes) {
        super(address);
        this.PEER_ID = peerId == null ? NULL_PEER_STRING : peerId;
        this.EXTENSION_BYTES = extensionBytes;
    }

    public TorrentLocation(InetAddress address, int port, byte[] peerId) {
        super(address, port);
        this.PEER_ID = peerId == null ? NULL_PEER_STRING : peerId;
        this.EXTENSION_BYTES = EXTENTION_BYTES;
    }

    public TorrentLocation(TorrentLocation to) {
        this(to.getInetSocketAddress(), to.getPeerID(), to.EXTENSION_BYTES);
    }

    public byte[] getPeerID() {
        return this.PEER_ID;
    }

    public byte[] getExtBytes() {
        return this.EXTENSION_BYTES;
    }

    public void strike() {
        this._nextRetryTime = System.currentTimeMillis() + 300000L;
        ++this._strikes;
    }

    public boolean isBusy(long now) {
        return this._nextRetryTime > now;
    }

    public long getWaitTime(long now) {
        return Math.max(0L, this._nextRetryTime - now);
    }

    public boolean isOut() {
        return this._strikes > 1;
    }

    public boolean isLimePeer() {
        return this.PEER_ID[0] == 76 && this.PEER_ID[1] == 73 && this.PEER_ID[2] == 77 && this.PEER_ID[3] == 69;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TorrentLocation)) {
            return false;
        }
        TorrentLocation other = (TorrentLocation)o;
        if (IpPort.COMPARATOR.compare(this, other) != 0) {
            return false;
        }
        return Arrays.equals(other.PEER_ID, this.PEER_ID);
    }

    public String toString() {
        return this.getAddress() + ":" + this.getPort() + ":" + new String(this.PEER_ID) + ":" + Base32.encode(this.EXTENSION_BYTES);
    }
}

