/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.bencoding;

import com.limegroup.bittorrent.bencoding.BEAbstractCollection;
import com.limegroup.bittorrent.bencoding.BEString;
import com.limegroup.bittorrent.bencoding.Token;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BEDictionary
extends BEAbstractCollection<Map<String, Object>> {
    BEDictionary(ReadableByteChannel chan) {
        super(chan);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    protected Map<String, Object> createCollection() {
        return new HashMap<String, Object>();
    }

    @Override
    protected void add(Object o) {
        BEEntry e = (BEEntry)o;
        ((Map)this.result).put(e.key, e.value);
    }

    @Override
    protected Token<?> getNewElement() {
        return new BEEntry(this.chan);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BEEntry
    extends Token<Object> {
        private BEString keyToken;
        private String key;
        private Token valueToken;
        private Object value;
        private boolean lastEntry;

        BEEntry(ReadableByteChannel chan) {
            super(chan);
            this.result = this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleRead() throws IOException {
            Token<?> t;
            if (this.keyToken == null && this.key == null) {
                t = BEEntry.getNextToken(this.chan);
                if (t == null) return;
                if (t instanceof BEString) {
                    this.keyToken = (BEString)t;
                } else {
                    if (t != Token.TERMINATOR) throw new IOException("invalid entry - key not a string");
                    this.lastEntry = true;
                    return;
                }
            }
            if (this.key == null) {
                this.keyToken.handleRead();
                if (this.keyToken.getResult() == null) return;
                this.key = new String((byte[])this.keyToken.getResult(), "ISO-8859-1");
                this.keyToken = null;
            }
            if (this.valueToken == null && this.value == null) {
                t = BEEntry.getNextToken(this.chan);
                if (t == null) return;
                this.valueToken = t;
            }
            if (this.value != null) throw new IllegalStateException("token is done - don't read to it " + this.key + " " + this.value);
            this.valueToken.handleRead();
            this.value = this.valueToken.getResult();
            if (this.value == Token.TERMINATOR) {
                throw new IOException("missing value");
            }
            if (this.value == null) return;
            this.valueToken = null;
        }

        @Override
        protected boolean isDone() {
            return this.key != null && this.value != null;
        }

        @Override
        public Object getResult() {
            if (this.lastEntry) {
                return Token.TERMINATOR;
            }
            return super.getResult();
        }
    }
}

