/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.disk;

import com.limegroup.bittorrent.disk.DiskController;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RAFDiskController<F extends File>
implements DiskController<F> {
    private static final Log LOG = LogFactory.getLog(RAFDiskController.class);
    protected List<F> _files;
    protected RandomAccessFile[] _fos = null;

    RAFDiskController() {
    }

    @Override
    public synchronized void write(long startOffset, byte[] data) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("file closed");
        }
        int written = 0;
        int filesSize = this._files.size();
        for (int i = 0; i < filesSize && written < data.length; ++i) {
            File current = (File)this._files.get(i);
            if (startOffset < current.length()) {
                int toWrite = (int)Math.min(current.length() - startOffset, (long)(data.length - written));
                this.writeImpl(this._fos[i], startOffset, data, written, toWrite);
                startOffset += (long)toWrite;
                written += toWrite;
            }
            startOffset -= current.length();
        }
    }

    protected void writeImpl(RandomAccessFile f, long fileOffset, byte[] data, int offset, int length) throws IOException {
        f.seek(fileOffset);
        f.write(data, offset, length);
    }

    @Override
    public synchronized boolean isOpen() {
        return this._fos != null;
    }

    @Override
    public synchronized List<F> open(List<F> files, boolean complete, boolean isVerifying) throws IOException {
        this._files = files;
        if (this._fos != null) {
            throw new IOException("Files already open(ing)!");
        }
        RandomAccessFile[] fos = new RandomAccessFile[this._files.size()];
        long pos = 0L;
        ArrayList<File> filesToVerify = null;
        for (int i = 0; i < this._files.size(); ++i) {
            File file = (File)this._files.get(i);
            IOUtils.close(fos[i]);
            if (complete) {
                LOG.info("opening torrent in read-only mode");
                fos[i] = new RandomAccessFile(file, "r");
            } else {
                LOG.info("opening torrent in read-write");
                if (!file.exists()) {
                    File parentFile = file.getParentFile();
                    if (parentFile != null) {
                        parentFile.mkdirs();
                        FileUtils.setWriteable(parentFile);
                    }
                    file.createNewFile();
                    if (!isVerifying) {
                        isVerifying = true;
                        i = -1;
                        continue;
                    }
                }
                FileUtils.setWriteable(file);
                fos[i] = new RandomAccessFile(file, "rw");
                if (isVerifying && fos[i].length() > 0L) {
                    if (filesToVerify == null) {
                        filesToVerify = new ArrayList<File>(this._files.size());
                    }
                    filesToVerify.add(file);
                }
            }
            pos += file.length();
        }
        for (RandomAccessFile raf : fos) {
            if (raf.getFD().valid()) continue;
            throw new IOException("file was invalid: " + raf);
        }
        this._fos = fos;
        return filesToVerify;
    }

    @Override
    public synchronized void close() {
        LOG.debug("closing the file");
        if (!this.isOpen()) {
            return;
        }
        for (RandomAccessFile f : this._fos) {
            IOUtils.close(f);
        }
        this._fos = null;
    }

    @Override
    public synchronized void setReadOnly(F completed) throws IOException {
        if (!this.isOpen()) {
            return;
        }
        int index = this._files.indexOf(completed);
        this._fos[index] = this.setReadOnly(this._fos[index], ((File)completed).getPath());
        if (!this._fos[index].getFD().valid()) {
            throw new IOException("new fd invalid " + completed);
        }
    }

    protected RandomAccessFile setReadOnly(RandomAccessFile f, String path) throws IOException {
        f.close();
        return new RandomAccessFile(path, "r");
    }

    @Override
    public synchronized int read(long position, byte[] buf, int offset, int length) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("cannot seek negative position " + position);
        }
        if (offset + length > buf.length) {
            throw new ArrayIndexOutOfBoundsException("buffer to small to store supplied number of bytes");
        }
        if (!this.isOpen()) {
            throw new IOException("file closed");
        }
        int read = 0;
        for (int i = 0; i < this._files.size() && read < length; ++i) {
            File f = (File)this._files.get(i);
            while (position < f.length() && read < length) {
                assert (this._fos[i] != null) : "file being read & verified at the same time";
                long currentLength = this._fos[i].length();
                if (currentLength < f.length() && position >= currentLength) {
                    return read;
                }
                int toRead = (int)Math.min(currentLength - position, (long)(length - read));
                int t_read = this.readImpl(this._fos[i], position, buf, read + offset, toRead);
                if (t_read == -1) {
                    throw new IOException();
                }
                position += (long)t_read;
                read += t_read;
            }
            position -= f.length();
        }
        return read;
    }

    protected int readImpl(RandomAccessFile raf, long fileOffset, byte[] dst, int offset, int length) throws IOException {
        raf.seek(fileOffset);
        return raf.read(dst, offset, length);
    }

    @Override
    public synchronized void flush() throws IOException {
        LOG.debug("flushing");
        if (!this.isOpen()) {
            return;
        }
        for (RandomAccessFile f : this._fos) {
            if (f == null) {
                StringBuilder report = new StringBuilder();
                report.append("flush npe report:");
                report.append("  files:").append(this._files).append("  ");
                report.append("fos length ").append(this._fos.length).append("  ");
                for (RandomAccessFile f2 : this._fos) {
                    report.append(String.valueOf(f2)).append("  ");
                }
                throw new IllegalStateException(report.toString());
            }
            f.getChannel().force(false);
        }
    }
}

