/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.gui;

import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.download.GuiDownloaderFactory;
import java.io.File;
import java.io.IOException;
import org.limewire.util.FileUtils;

public class TorrentDownloadFactory
implements GuiDownloaderFactory {
    private final BTMetaInfo info;

    public TorrentDownloadFactory(File f) throws IOException {
        byte[] b = FileUtils.readFileFully(f);
        if (b == null) {
            throw new IOException();
        }
        this.info = BTMetaInfo.readFromBytes(b);
    }

    public TorrentDownloadFactory(BTMetaInfo info) {
        this.info = info;
    }

    public Downloader createDownloader(boolean overwrite) throws SaveLocationException {
        return GuiCoreMediator.getDownloadServices().downloadTorrent(this.info, overwrite);
    }

    public long getFileSize() {
        return this.info.getFileSystem().getTotalSize();
    }

    public File getSaveFile() {
        return this.info.getFileSystem().getCompleteFile();
    }

    public URN getURN() {
        return this.info.getURN();
    }

    public BTMetaInfo getBTMetaInfo() {
        return this.info;
    }

    public void setSaveFile(File saveFile) {
        this.info.getFileSystem().setCompleteFile(saveFile);
    }
}

