/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.handshaking;

import com.limegroup.bittorrent.BTConnectionFactory;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.handshaking.BTHandshakeObserver;
import com.limegroup.bittorrent.handshaking.BTHandshaker;
import com.limegroup.bittorrent.handshaking.IncomingBTHandshaker;
import com.limegroup.bittorrent.handshaking.OutgoingBTHandshaker;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.util.StrictIpPortSet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Periodic;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.net.SocketsManager;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.IOErrorObserver;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.service.ErrorService;

public class BTConnectionFetcher
implements BTHandshakeObserver,
Runnable,
Shutdownable {
    private static final Log LOG = LogFactory.getLog(BTConnectionFetcher.class);
    private static final String BITTORRENT_PROTOCOL = "BitTorrent protocol";
    public static byte[] BITTORRENT_PROTOCOL_BYTES;
    private static final byte[] EXTENSION_BYTES;
    private final StrictIpPortSet<TorrentConnector> connecting = new StrictIpPortSet();
    private final StrictIpPortSet<BTHandshaker> handshaking = new StrictIpPortSet();
    private final ManagedTorrent _torrent;
    private final ByteBuffer _handshake;
    private volatile boolean shutdown;
    private final Periodic scheduled;
    private volatile int _triedHosts;
    private final SocketsManager socketsManager;
    private final BTConnectionFactory btcFactory;

    BTConnectionFetcher(ManagedTorrent torrent, ScheduledExecutorService scheduler, ApplicationServices applicationServices, SocketsManager socketsManager, BTConnectionFactory btcFactory) {
        this.socketsManager = socketsManager;
        this.btcFactory = btcFactory;
        this._torrent = torrent;
        ByteBuffer handshake = ByteBuffer.allocate(68);
        handshake.put((byte)BITTORRENT_PROTOCOL.length());
        handshake.put(BITTORRENT_PROTOCOL_BYTES);
        handshake.put(EXTENSION_BYTES);
        handshake.put(this._torrent.getInfoHash());
        handshake.put(applicationServices.getMyBTGUID());
        handshake.flip();
        this._handshake = handshake.asReadOnlyBuffer();
        this.scheduled = new Periodic(this, scheduler);
    }

    public synchronized void fetch() {
        if (this.shutdown || !this._torrent.needsMoreConnections()) {
            return;
        }
        long nextRetryTime = this._torrent.getNextLocationRetryTime();
        if (nextRetryTime != Long.MAX_VALUE) {
            this.scheduled.rescheduleIfSooner(nextRetryTime);
        }
    }

    public void run() {
        this.fetchImpl();
    }

    private void fetchImpl() {
        if (this.shutdown) {
            return;
        }
        while (this._torrent.needsMoreConnections() && this.connecting.size() < this.socketsManager.getNumAllowedSockets() && this._torrent.hasNonBusyLocations()) {
            this.fetchConnection();
        }
        if (this.connecting.size() < this.socketsManager.getNumAllowedSockets()) {
            this.fetch();
        }
    }

    private void fetchConnection() {
        TorrentLocation ep = null;
        do {
            if ((ep = this._torrent.getTorrentLocation()) != null) continue;
            LOG.debug("no hosts to connect to");
            return;
        } while (this.connecting.contains(ep) || this.handshaking.contains(ep));
        TorrentConnector connector = new TorrentConnector(ep);
        this.connecting.add(connector);
        ++this._triedHosts;
        try {
            connector.toCancel = this.socketsManager.connect(new InetSocketAddress(ep.getAddress(), ep.getPort()), 8000, connector);
        }
        catch (IOException impossible) {
            this.connecting.remove(connector);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting a connector to " + ep.getAddress() + " total " + this.connecting.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        BTConnectionFetcher bTConnectionFetcher = this;
        synchronized (bTConnectionFetcher) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        this.scheduled.unschedule();
        ArrayList<IOErrorObserver> conns = new ArrayList<IOErrorObserver>(this.connecting.size() + this.handshaking.size());
        conns.addAll(this.connecting);
        conns.addAll(this.handshaking);
        for (Shutdownable shutdownable : conns) {
            shutdownable.shutdown();
        }
    }

    public ByteBuffer getOutgoingHandshake() {
        return this._handshake.duplicate();
    }

    public void handshakerStarted(IncomingBTHandshaker shaker) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("incoming handshaker from " + shaker.getInetAddress() + ":" + shaker.getPort());
        }
        if (this.shutdown || this.handshaking.contains(shaker)) {
            LOG.debug("rejecting it");
            shaker.shutdown();
        } else {
            this.handshaking.add(shaker);
        }
        if (this.connecting.contains(shaker)) {
            for (TorrentConnector connector : this.connecting) {
                if (IpPort.COMPARATOR.compare(connector, shaker) != 0) continue;
                LOG.debug("stopping a connection attempt to same location");
                connector.shutdown();
                return;
            }
        }
    }

    public void handshakerDone(BTHandshaker shaker) {
        assert (this.shutdown || this.handshaking.contains(shaker)) : "unknown shaker " + shaker;
        this.handshaking.remove(shaker);
    }

    public int getTriedHostCount() {
        return this._triedHosts;
    }

    static {
        try {
            BITTORRENT_PROTOCOL_BYTES = BITTORRENT_PROTOCOL.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            ErrorService.error(e);
        }
        EXTENSION_BYTES = new byte[8];
    }

    private class TorrentConnector
    implements ConnectObserver,
    IpPort {
        private final TorrentLocation destination;
        private final AtomicBoolean shutdown = new AtomicBoolean(false);
        volatile Socket toCancel;

        TorrentConnector(TorrentLocation destination) {
            this.destination = destination;
        }

        public void handleConnect(Socket sock) {
            if (this.shutdown.get()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("established transport to " + sock.getInetAddress());
            }
            BTConnectionFetcher.this.connecting.remove(this);
            if (BTConnectionFetcher.this.handshaking.contains(this)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("handshaker for this location exists");
                }
                IOUtils.close(sock);
                return;
            }
            OutgoingBTHandshaker shaker = new OutgoingBTHandshaker(this.destination, BTConnectionFetcher.this._torrent, (AbstractNBSocket)sock, BTConnectionFetcher.this.btcFactory);
            BTConnectionFetcher.this.handshaking.add(shaker);
            ((BTHandshaker)shaker).startHandshaking();
            BTConnectionFetcher.this.fetch();
        }

        public void handleIOException(IOException iox) {
            this.shutdown();
        }

        public void shutdown() {
            if (this.shutdown.getAndSet(true)) {
                return;
            }
            IOUtils.close(this.toCancel);
            BTConnectionFetcher.this.connecting.remove(this);
            BTConnectionFetcher.this.fetch();
        }

        public String getAddress() {
            return this.destination.getAddress();
        }

        public InetAddress getInetAddress() {
            return this.destination.getInetAddress();
        }

        public int getPort() {
            return this.destination.getPort();
        }

        public InetSocketAddress getInetSocketAddress() {
            return this.destination.getInetSocketAddress();
        }
    }
}

