/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.handshaking;

import com.limegroup.bittorrent.BTConnectionFactory;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.handshaking.BTConnectionFetcher;
import com.limegroup.bittorrent.handshaking.BTHandshaker;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.AbstractNBSocket;

class OutgoingBTHandshaker
extends BTHandshaker {
    private static final Log LOG = LogFactory.getLog(OutgoingBTHandshaker.class);

    public OutgoingBTHandshaker(TorrentLocation loc, ManagedTorrent torrent, AbstractNBSocket sock, BTConnectionFactory factory) {
        super(loc, sock, factory);
        this.torrent = torrent;
        this.observer = torrent.getFetcher();
    }

    public void startHandshaking() {
        if (this.shutdown) {
            return;
        }
        this.initOutgoingHandshake();
        this.initIncomingHandshake();
        this.setWriteInterest();
        this.setReadInterest();
    }

    protected void initIncomingHandshake() {
        this.incomingHandshake = new ByteBuffer[5];
        this.incomingHandshake[0] = ByteBuffer.allocate(1);
        this.incomingHandshake[1] = ByteBuffer.allocate(19);
        this.incomingHandshake[2] = ByteBuffer.wrap(this.loc.getExtBytes());
        this.incomingHandshake[3] = ByteBuffer.allocate(20);
        this.incomingHandshake[4] = ByteBuffer.wrap(this.loc.getPeerID());
    }

    protected boolean verifyIncoming() {
        while (this.currentBufIndex < this.incomingHandshake.length && !this.incomingHandshake[this.currentBufIndex].hasRemaining()) {
            ByteBuffer current = this.incomingHandshake[this.currentBufIndex];
            switch (this.currentBufIndex) {
                case 0: {
                    if (current.get(0) == 19) break;
                    return false;
                }
                case 1: {
                    if (Arrays.equals(current.array(), BTConnectionFetcher.BITTORRENT_PROTOCOL_BYTES)) break;
                    return false;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (Arrays.equals(current.array(), this.torrent.getInfoHash())) break;
                    return false;
                }
            }
            ++this.currentBufIndex;
        }
        return true;
    }

    public void handleIOException(IOException iox) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection failed: " + this.loc);
        }
        this.loc.strike();
        if (!this.loc.isOut()) {
            this.torrent.addEndpoint(this.loc);
        }
        super.handleIOException(iox);
    }
}

