/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.messages;

import com.limegroup.bittorrent.BTInterval;
import com.limegroup.bittorrent.messages.BTMessage;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BTRequest
extends BTMessage {
    private static final int MAX_REQUEST_SIZE = 65536;
    private BTInterval in;
    private ByteBuffer _payload;

    public BTRequest(BTInterval in) {
        super((byte)6);
        this.in = in;
    }

    public static BTRequest readMessage(ByteBuffer payload) throws BadBTMessageException {
        if (payload.remaining() != 12) {
            throw new BadBTMessageException("unexpected payload in request message: " + new String(payload.array()));
        }
        payload.order(ByteOrder.BIG_ENDIAN);
        int pieceNum = payload.getInt();
        if (pieceNum < 0) {
            throw new BadBTMessageException("invalid piece number in request message: " + pieceNum);
        }
        long offset = payload.getInt();
        if (offset < 0L) {
            throw new BadBTMessageException("negative offset in mesage");
        }
        long length = payload.getInt();
        if (length <= 0L || length > 65536L) {
            throw new BadBTMessageException("invalid requested length in request message: " + length);
        }
        return new BTRequest(new BTInterval(offset, offset + length - 1L, pieceNum));
    }

    public BTInterval getInterval() {
        return this.in;
    }

    public ByteBuffer getPayload() {
        if (this._payload == null) {
            ByteBuffer buf = ByteBuffer.allocate(12);
            buf.order(ByteOrder.BIG_ENDIAN);
            buf.putInt(this.in.getId());
            buf.putInt(this.in.get32BitLow());
            buf.putInt(this.in.get32BitLength());
            this._payload = buf.asReadOnlyBuffer();
        }
        this._payload.clear();
        return this._payload;
    }

    public boolean isUrgent() {
        return true;
    }

    public String toString() {
        return "BTRequest (" + this.in + ")";
    }
}

