/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.reader;

import com.limegroup.bittorrent.messages.BTMessage;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import com.limegroup.bittorrent.reader.BTDataSource;
import com.limegroup.bittorrent.reader.BTReadMessageState;
import com.limegroup.bittorrent.reader.ReaderData;
import java.nio.ByteBuffer;

class MessageState
extends BTReadMessageState {
    private final byte type;

    MessageState(ReaderData readerState, byte type) {
        super(readerState);
        this.type = type;
    }

    public BTReadMessageState addData() throws BadBTMessageException {
        ByteBuffer buf;
        BTDataSource in = this.readerState.getDataSource();
        if (in.size() < this.readerState.getLength()) {
            return null;
        }
        if (this.readerState.getLength() == 0) {
            buf = BTMessage.EMPTY_PAYLOAD;
        } else {
            buf = ByteBuffer.allocate(this.readerState.getLength());
            in.get(buf);
            buf.clear();
        }
        BTMessage message = BTMessage.parseMessage(buf, this.type);
        this.readerState.getHandler().processMessage(message);
        return this.readerState.getEntryState();
    }
}

