/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.reader;

import com.limegroup.bittorrent.BTInterval;
import com.limegroup.bittorrent.BTPiece;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import com.limegroup.bittorrent.reader.BTDataSource;
import com.limegroup.bittorrent.reader.BTReadMessageState;
import com.limegroup.bittorrent.reader.ReaderData;
import org.limewire.collection.NECallable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PieceState
extends BTReadMessageState
implements NECallable<BTPiece> {
    private final int length;
    private final BTDataSource buf;
    private int chunkId = -1;
    private long offset = -1L;
    private long currentOffset;
    private BTInterval complete;
    private boolean welcome;
    private boolean writeExpected;

    PieceState(ReaderData readerState) {
        super(readerState);
        this.length = readerState.getLength();
        this.buf = readerState.getDataSource();
    }

    @Override
    public BTReadMessageState addData() throws BadBTMessageException {
        int available;
        if (this.writeExpected) {
            return null;
        }
        if (this.length < 9) {
            throw new BadBTMessageException("piece too short");
        }
        if (this.buf.size() < 4 && (this.chunkId < 0 || this.offset < 0L)) {
            return null;
        }
        if (this.chunkId < 0) {
            long newId = this.buf.getInt();
            if (newId > Integer.MAX_VALUE) {
                throw new BadBTMessageException("unsupported bit chunk id");
            }
            this.chunkId = (int)newId;
            return this;
        }
        if (this.offset < 0L) {
            this.currentOffset = this.offset = this.buf.getInt();
            this.complete = new BTInterval(this.offset, this.offset + (long)this.length - 9L, this.chunkId);
            this.welcome = this.readerState.getHandler().startReceivingPiece(this.complete);
        }
        if ((available = this.getAmountLeft()) == 0) {
            return null;
        }
        if (this.welcome) {
            if (!this.writeExpected) {
                this.writeExpected = true;
                this.readerState.getHandler().handlePiece(this);
            }
        } else {
            this.buf.discard(available);
            this.currentOffset += (long)available;
            available = 0;
        }
        if (this.currentOffset + (long)available == this.complete.getHigh() + 1L) {
            this.readerState.getHandler().finishReceivingPiece();
            if (!this.writeExpected) {
                return this.readerState.getEntryState();
            }
        }
        return null;
    }

    public String toString() {
        return "Piece " + this.complete + " offset " + this.currentOffset + " welcome " + this.welcome + " write expected " + this.writeExpected;
    }

    private int getAmountLeft() {
        return (int)Math.min((long)this.buf.size(), this.complete.getHigh() - this.currentOffset + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BTPiece call() {
        ReaderData readerData = this.readerState;
        synchronized (readerData) {
            assert (this.writeExpected);
            this.writeExpected = false;
            int toRead = this.getAmountLeft();
            BTInterval in = new BTInterval(this.currentOffset, this.currentOffset + (long)toRead - 1L, this.chunkId);
            this.currentOffset += (long)toRead;
            this.readerState.getHandler().readBytes(toRead);
            byte[] data = new byte[toRead];
            this.buf.get(data);
            this.readerState.getPieceListener().dataConsumed(this.currentOffset > this.complete.getHigh());
            return new ReceivedPiece(in, data);
        }
    }

    private static class ReceivedPiece
    implements BTPiece {
        private final BTInterval interval;
        private final byte[] data;

        ReceivedPiece(BTInterval interval, byte[] data) {
            this.interval = interval;
            this.data = data;
        }

        public BTInterval getInterval() {
            return this.interval;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

