/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.tracking;

import com.google.inject.Provider;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.tracking.TrackerResponse;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkManager;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.http.LimeHttpClient;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Tracker {
    private static final Log LOG = LogFactory.getLog(Tracker.class);
    private static final int HTTP_TRACKER_TIMEOUT = 25000;
    private static final String QUESTION_MARK = "?";
    private static final String EQUALS = "=";
    private static final String AND = "&";
    private final URI uri;
    private final TorrentContext context;
    private final ManagedTorrent torrent;
    private final Provider<LimeHttpClient> clientProvider;
    private int failures;
    private final String key;
    private final NetworkManager networkManager;
    private final ApplicationServices applicationServices;

    Tracker(URI uri, TorrentContext context, ManagedTorrent torrent, NetworkManager networkManager, ApplicationServices applicationServices, Provider<LimeHttpClient> clientProvider) {
        this.networkManager = networkManager;
        this.applicationServices = applicationServices;
        this.uri = uri;
        this.context = context;
        this.torrent = torrent;
        this.clientProvider = clientProvider;
        String k = Integer.toHexString((int)(Math.random() * 2.147483647E9));
        while (k.length() < 8) {
            k = k + "0";
        }
        this.key = k;
    }

    public void recordFailure() {
        ++this.failures;
    }

    public void recordSuccess() {
        this.failures = 0;
    }

    public int getFailures() {
        return this.failures;
    }

    public TrackerResponse request(Event event) {
        String queryStr = this.createQueryString(event);
        return this.connectHTTP(this.uri, queryStr);
    }

    private String createQueryString(Event event) {
        StringBuilder buf = new StringBuilder();
        try {
            String infoHash = URLEncoder.encode(StringUtils.getASCIIString(this.context.getMetaInfo().getInfoHash()), "ISO-8859-1");
            Tracker.addGetField(buf, "info_hash", infoHash);
            String peerId = URLEncoder.encode(StringUtils.getASCIIString(this.applicationServices.getMyBTGUID()), "ISO-8859-1");
            Tracker.addGetField(buf, "peer_id", peerId);
            Tracker.addGetField(buf, "key", this.key);
        }
        catch (UnsupportedEncodingException uee) {
            ErrorService.error(uee);
        }
        Tracker.addGetField(buf, "ip", NetworkUtils.ip2string(this.networkManager.getAddress()));
        Tracker.addGetField(buf, "port", String.valueOf(this.networkManager.getPort()));
        Tracker.addGetField(buf, "downloaded", String.valueOf(this.torrent.getTotalDownloaded()));
        Tracker.addGetField(buf, "uploaded", String.valueOf(this.torrent.getTotalUploaded()));
        Tracker.addGetField(buf, "left", String.valueOf(this.context.getFileSystem().getTotalSize() - this.context.getDiskManager().getBlockSize()));
        Tracker.addGetField(buf, "compact", "1");
        event.addEventFields(buf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("tracker query " + buf.toString());
        }
        return buf.toString();
    }

    /*
     * Exception decompiling
     */
    private TrackerResponse connectHTTP(URI uri, String query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static StringBuilder addGetField(StringBuilder buf, String key, String value) {
        if (buf.length() == 0) {
            buf.append(QUESTION_MARK);
        } else {
            buf.append(AND);
        }
        buf.append(key);
        buf.append(EQUALS);
        buf.append(value);
        return buf;
    }

    public String toString() {
        return "Tracker " + this.uri + " failures " + this.failures;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        START(100, "started"),
        STOP(0, "stopped"),
        COMPLETE(20, "completed"),
        NONE(50, null);

        private final String numWant;
        private final String description;

        private Event(int numWant, String description) {
            this.numWant = numWant > 0 ? Integer.toString(numWant) : null;
            this.description = description;
        }

        public void addEventFields(StringBuilder buf) {
            if (this.description != null) {
                Tracker.addGetField(buf, "event", this.description);
            }
            if (this.numWant != null) {
                Tracker.addGetField(buf, "numwant", this.numWant);
            }
        }
    }
}

