/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.tracking;

import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.ValueException;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TrackerResponse {
    private static final Log LOG = LogFactory.getLog(TrackerResponse.class);
    public final List<TorrentLocation> PEERS;
    public final int INTERVAL;
    public final int NUM_PEERS;
    public final int DONE_PEERS;
    public final String FAILURE_REASON;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TrackerResponse(Object t_response) throws ValueException {
        if (!(t_response instanceof Map)) {
            throw new ValueException("bad tracker response");
        }
        Map response = (Map)t_response;
        if (response.containsKey("failure reason")) {
            byte[] failureBytes = (byte[])response.get("failure reason");
            String reason = StringUtils.getASCIIString(failureBytes);
            if (reason.length() > 256) {
                reason = reason.substring(0, 255);
            }
            this.FAILURE_REASON = reason;
        } else {
            this.FAILURE_REASON = null;
        }
        if (response.containsKey("peers")) {
            Object t_peers = response.get("peers");
            if (t_peers instanceof List) {
                this.PEERS = TrackerResponse.parsePeers((List)t_peers);
            } else {
                if (!(t_peers instanceof byte[])) throw new ValueException("bad tracker response - bad peers " + t_peers);
                this.PEERS = TrackerResponse.parsePeers((byte[])t_peers);
            }
        } else {
            this.PEERS = Collections.emptyList();
        }
        Object t_interval = response.get("interval");
        Object t_minInterval = response.get("min_interval");
        int interval = t_interval instanceof Long ? (int)((Long)t_interval).longValue() : (t_minInterval instanceof Long ? (int)((Long)t_interval).longValue() : BittorrentSettings.TRACKER_MIN_REASK_INTERVAL.getValue());
        this.INTERVAL = interval < BittorrentSettings.TRACKER_MIN_REASK_INTERVAL.getValue() ? BittorrentSettings.TRACKER_MIN_REASK_INTERVAL.getValue() : (interval > BittorrentSettings.TRACKER_MAX_REASK_INTERVAL.getValue() ? BittorrentSettings.TRACKER_MAX_REASK_INTERVAL.getValue() : interval);
        Object t_numPeers = response.get("num peers");
        this.NUM_PEERS = t_numPeers instanceof Long ? (int)((Long)t_numPeers).longValue() : ((t_numPeers = response.get("incomplete")) instanceof Long ? (int)((Long)t_numPeers).longValue() : 0);
        Object t_donePeers = response.get("num done");
        this.DONE_PEERS = t_donePeers instanceof Long ? (int)((Long)t_donePeers).longValue() : ((t_donePeers = response.get("complete")) instanceof Long ? (int)((Long)t_donePeers).longValue() : 0);
    }

    TrackerResponse(List<TorrentLocation> peers, int interval, int numPeers, int donePeers, String failureReason) {
        this.PEERS = peers;
        this.INTERVAL = Math.min(Math.max(interval, BittorrentSettings.TRACKER_MIN_REASK_INTERVAL.getValue()), BittorrentSettings.TRACKER_MAX_REASK_INTERVAL.getValue());
        this.NUM_PEERS = Math.max(0, numPeers);
        this.DONE_PEERS = Math.max(0, donePeers);
        this.FAILURE_REASON = failureReason;
    }

    private static List<TorrentLocation> parsePeers(List peers) throws ValueException {
        ArrayList<TorrentLocation> ret = new ArrayList<TorrentLocation>();
        for (Object t_peer : peers) {
            if (!(t_peer instanceof Map)) {
                throw new ValueException("bad tracker response - bad peer " + t_peer);
            }
            ret.add(TrackerResponse.parsePeer((Map)t_peer));
        }
        return Collections.unmodifiableList(ret);
    }

    static List<TorrentLocation> parsePeers(byte[] bytes) throws ValueException {
        boolean containedInvalid = false;
        ArrayList<TorrentLocation> ret = new ArrayList<TorrentLocation>();
        for (int i = 0; i < bytes.length - 5; i += 6) {
            byte[] address = new byte[4];
            System.arraycopy(bytes, i, address, 0, 4);
            int port = ByteOrder.beb2int(bytes, i + 4, 2);
            if (!NetworkUtils.isValidPort(port)) {
                containedInvalid = true;
                continue;
            }
            try {
                InetAddress addr = InetAddress.getByAddress(address);
                ret.add(TrackerResponse.parsePeer(addr, port, null));
                continue;
            }
            catch (UnknownHostException uhe) {
                containedInvalid = true;
            }
        }
        if (ret.isEmpty() && containedInvalid) {
            throw new ValueException("no peers or all invalid");
        }
        return Collections.unmodifiableList(ret);
    }

    private static TorrentLocation parsePeer(Map peer) throws ValueException {
        InetAddress addr;
        Object t_ip = peer.get("ip");
        if (!(t_ip instanceof byte[])) {
            throw new ValueException("bad tracker response - bad peer ip " + t_ip);
        }
        try {
            String ipS = new String((byte[])t_ip, "ISO-8859-1");
            addr = InetAddress.getByName(ipS);
        }
        catch (UnknownHostException uhe) {
            throw new ValueException("bad tracker response - bad peer ip " + t_ip);
        }
        catch (UnsupportedEncodingException impossible) {
            ErrorService.error(impossible);
            return null;
        }
        Object t_port = peer.get("port");
        if (!(t_port instanceof Long)) {
            throw new ValueException("bad tracker response - bad peer port " + t_port);
        }
        int port = (int)((Long)t_port).longValue();
        Object t_peerId = peer.get("peer id");
        if (!(t_peerId instanceof byte[])) {
            throw new ValueException("bad tracker response - bad peer id ");
        }
        byte[] peerId = (byte[])t_peerId;
        if (peerId.length != 20) {
            throw new ValueException("bad tracker response - bad peer id ");
        }
        return TrackerResponse.parsePeer(addr, port, peerId);
    }

    private static TorrentLocation parsePeer(InetAddress addr, int port, byte[] peerId) throws ValueException {
        if (!NetworkUtils.isValidAddress(addr)) {
            throw new ValueException("bad tracker response - bad peer ip " + addr);
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new ValueException("bad tracker response - bad peer port " + port);
        }
        TorrentLocation to = new TorrentLocation(addr, port, peerId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("got peer " + to);
        }
        return to;
    }

    public String toString() {
        return "tracker response: min interval " + this.INTERVAL + "," + this.DONE_PEERS + "/" + this.NUM_PEERS + (this.FAILURE_REASON != null ? this.FAILURE_REASON : "") + ", num peers: " + this.PEERS.size();
    }
}

