/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.SocketProcessor;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UPnPListener;
import com.limegroup.gnutella.UPnPManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.i18n.I18nMarker;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.AsyncConnectionDispatcher;
import org.limewire.net.BlockingConnectionDispatcher;
import org.limewire.net.ConnectionAcceptor;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.nio.SocketFactory;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.AcceptObserver;
import org.limewire.service.MessageService;
import org.limewire.setting.SettingsGroupManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class AcceptorImpl
implements ConnectionAcceptor,
SocketProcessor,
Acceptor {
    private static final Log LOG = LogFactory.getLog(AcceptorImpl.class);
    public static final long DEFAULT_INCOMING_EXPIRE_TIME = 1800000L;
    public static final long DEFAULT_WAIT_TIME_AFTER_REQUESTS = 30000L;
    public static final long DEFAULT_TIME_BETWEEN_VALIDATES = 600000L;
    private long incomingExpireTime = 1800000L;
    private long waitTimeAfterRequests = 30000L;
    private long timeBetweenValidates = 600000L;
    private final IncomingValidator incomingValidator = new IncomingValidator();
    private volatile ServerSocket _socket = null;
    private volatile int _port = 6346;
    private byte[] _address = new byte[4];
    private byte[] _externalAddress = new byte[4];
    @InspectablePrimitive(value="accepted incoming")
    private volatile boolean _acceptedIncoming = false;
    private volatile long _lastConnectBackTime = 0L;
    private volatile boolean _started;
    private final NetworkManager networkManager;
    private final Provider<UDPService> udpService;
    private final Provider<MulticastService> multicastService;
    private final Provider<ConnectionDispatcher> connectionDispatcher;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<ActivityCallback> activityCallback;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<IPFilter> ipFilter;
    private final ConnectionServices connectionServices;
    private final Provider<UPnPManager> upnpManager;
    @InspectablePrimitive(value="upnp enabled")
    private final boolean upnpEnabled;

    @Inject
    public AcceptorImpl(NetworkManager networkManager, Provider<UDPService> udpService, Provider<MulticastService> multicastService, @Named(value="global") Provider<ConnectionDispatcher> connectionDispatcher, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<ActivityCallback> activityCallback, Provider<ConnectionManager> connectionManager, Provider<IPFilter> ipFilter, ConnectionServices connectionServices, Provider<UPnPManager> upnpManager) {
        this.networkManager = networkManager;
        this.udpService = udpService;
        this.multicastService = multicastService;
        this.connectionDispatcher = connectionDispatcher;
        this.backgroundExecutor = backgroundExecutor;
        this.activityCallback = activityCallback;
        this.connectionManager = connectionManager;
        this.ipFilter = ipFilter;
        this.connectionServices = connectionServices;
        this.upnpManager = upnpManager;
        this.upnpEnabled = !ConnectionSettings.DISABLE_UPNP.getValue();
    }

    private boolean isUPnPEnabled() {
        return this.upnpEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAddress(InetAddress address) {
        byte[] byteAddr = address.getAddress();
        if (!NetworkUtils.isValidAddress(byteAddr)) {
            return;
        }
        if (byteAddr[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        boolean addrChanged = false;
        Class<AcceptorImpl> clazz = AcceptorImpl.class;
        synchronized (AcceptorImpl.class) {
            if (!Arrays.equals(this._address, byteAddr)) {
                this._address = byteAddr;
                addrChanged = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (addrChanged) {
                this.networkManager.addressChanged();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExternalAddress(InetAddress address) {
        byte[] byteAddr = address.getAddress();
        if (byteAddr[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        Class<AcceptorImpl> clazz = AcceptorImpl.class;
        synchronized (AcceptorImpl.class) {
            this._externalAddress = byteAddr;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void init() {
        int oldPort;
        boolean tryingRandom;
        block17: {
            int tempPort;
            tryingRandom = ConnectionSettings.PORT.isDefault() && !ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue() && !ConnectionSettings.FORCE_IP_ADDRESS.getValue();
            Random gen = null;
            if (tryingRandom) {
                gen = new Random();
                tempPort = gen.nextInt(50000) + 2000;
            } else {
                tempPort = ConnectionSettings.PORT.getValue();
            }
            try {
                if (this.isUPnPEnabled()) {
                    this.setAddress(NetworkUtils.getLocalAddress());
                } else {
                    this.setAddress(InetAddress.getLocalHost());
                }
            }
            catch (UnknownHostException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
            oldPort = tempPort;
            try {
                this.setListeningPort(tempPort);
                this._port = tempPort;
            }
            catch (IOException e) {
                LOG.warn("can't set initial port", e);
                int numToTry = 20;
                for (int i = 0; i < numToTry; ++i) {
                    if (gen == null) {
                        gen = new Random();
                    }
                    tempPort = gen.nextInt(50000);
                    if ((tempPort += 2000) == ConnectionSettings.MULTICAST_PORT.getValue()) {
                        ++numToTry;
                        continue;
                    }
                    try {
                        this.setListeningPort(tempPort);
                        this._port = tempPort;
                        break;
                    }
                    catch (IOException e2) {
                        LOG.warn("can't set port", e2);
                    }
                }
                if (this._socket != null) break block17;
                MessageService.showError(I18nMarker.marktr("FrostWire was unable to set up a port to listen for incoming connections. Some features of FrostWire may not work as expected."));
            }
        }
        if (this._port != oldPort || tryingRandom) {
            ConnectionSettings.PORT.setValue(this._port);
            SettingsGroupManager.instance().save();
            this.networkManager.addressChanged();
        }
        if (this.upnpManager.get().isNATPresent()) {
            this.setupUPnP();
        } else {
            this.upnpManager.get().addListener(new UPnPListener(){

                public void natFound() {
                    AcceptorImpl.this.setupUPnP();
                }
            });
        }
    }

    private void setupUPnP() {
        if (this._socket != null && this.isUPnPEnabled()) {
            boolean forcedIP;
            boolean natted = this.upnpManager.get().isNATPresent();
            boolean validPort = NetworkUtils.isValidPort(this._port);
            boolean bl = forcedIP = ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Natted: " + natted + ", validPort: " + validPort + ", forcedIP: " + forcedIP);
            }
            if (natted && validPort && !forcedIP) {
                int mappedPort = this.upnpManager.get().mapPort(this._port);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("UPNP port mapped: " + mappedPort);
                }
                if (mappedPort != 0) {
                    this.upnpManager.get().clearMappingsOnShutdown();
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                    ConnectionSettings.FORCED_PORT.setValue(mappedPort);
                    ConnectionSettings.UPNP_IN_USE.setValue(true);
                    if (mappedPort != this._port) {
                        this.networkManager.addressChanged();
                    }
                    this.resetLastConnectBackTime();
                    this.udpService.get().resetLastConnectBackTime();
                    if (!this.acceptedIncoming()) {
                        this.incomingValidator.run();
                    }
                }
            }
        }
    }

    @Override
    public void start() {
        this.multicastService.get().start();
        this.udpService.get().start();
        this.connectionDispatcher.get().addConnectionAcceptor(this, false, "CONNECT", "\n\n");
        this.backgroundExecutor.scheduleWithFixedDelay(this.incomingValidator, this.timeBetweenValidates, this.timeBetweenValidates, TimeUnit.MILLISECONDS);
        this._started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAddressExternal() {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        Class<AcceptorImpl> clazz = AcceptorImpl.class;
        synchronized (AcceptorImpl.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Arrays.equals(this.getAddress(true), this._externalAddress);
        }
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getExternalAddress() {
        Class<AcceptorImpl> clazz = AcceptorImpl.class;
        synchronized (AcceptorImpl.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._externalAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getAddress(boolean checkForce) {
        if (checkForce && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            String address = ConnectionSettings.FORCED_IP_ADDRESS_STRING.getValue();
            try {
                InetAddress ia = InetAddress.getByName(address);
                byte[] addr = ia.getAddress();
                if (addr != null) {
                    return addr;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        Class<AcceptorImpl> clazz = AcceptorImpl.class;
        synchronized (AcceptorImpl.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this._address;
        }
    }

    public ConnectionDispatcher getConnectionDispatcher() {
        return this.connectionDispatcher.get();
    }

    @Override
    public int getPort(boolean checkForce) {
        if (checkForce && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            return ConnectionSettings.FORCED_PORT.getValue();
        }
        return this._port;
    }

    @Override
    public void setListeningPort(int port) throws IOException {
        if (this._socket != null && this._port == port) {
            return;
        }
        if (port == 0) {
            LOG.trace("shutting off service.");
            IOUtils.close(this._socket);
            this._socket = null;
            this._port = 0;
            this.udpService.get().setListeningSocket(null);
            this.multicastService.get().setListeningSocket(null);
            LOG.trace("service OFF.");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("changing port to " + port);
        }
        DatagramSocket udpServiceSocket = this.udpService.get().newListeningSocket(port);
        LOG.trace("UDP Service is ready.");
        MulticastSocket mcastServiceSocket = null;
        try {
            InetAddress mgroup = InetAddress.getByName(ConnectionSettings.MULTICAST_ADDRESS.getValue());
            mcastServiceSocket = this.multicastService.get().newListeningSocket(ConnectionSettings.MULTICAST_PORT.getValue(), mgroup);
            LOG.trace("multicast service setup");
        }
        catch (IOException e) {
            LOG.warn("can't create multicast socket", e);
        }
        ServerSocket newSocket = null;
        try {
            newSocket = SocketFactory.newServerSocket(port, new SocketListener());
        }
        catch (IOException e) {
            LOG.warn("can't create ServerSocket", e);
            udpServiceSocket.close();
            throw e;
        }
        catch (IllegalArgumentException e) {
            LOG.warn("can't create ServerSocket", e);
            udpServiceSocket.close();
            throw new IOException("could not create a listening socket");
        }
        IOUtils.close(this._socket);
        this._socket = newSocket;
        this._port = port;
        LOG.trace("Acceptor ready..");
        this.udpService.get().setListeningSocket(udpServiceSocket);
        if (mcastServiceSocket != null) {
            this.multicastService.get().setListeningSocket(mcastServiceSocket);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("listening UDP/TCP on " + this._port);
        }
    }

    @Override
    public boolean acceptedIncoming() {
        return this._acceptedIncoming;
    }

    protected void setAcceptedIncoming(boolean incoming) {
        this._acceptedIncoming = incoming;
    }

    boolean setIncoming(boolean canReceiveIncoming) {
        if (canReceiveIncoming) {
            this.incomingValidator.cancelReset();
        }
        if (this._acceptedIncoming == canReceiveIncoming) {
            return false;
        }
        this._acceptedIncoming = canReceiveIncoming;
        this.activityCallback.get().acceptedIncomingChanged(canReceiveIncoming);
        return true;
    }

    @Override
    public void acceptConnection(String word, Socket s) {
        this.checkFirewall(s.getInetAddress());
        IOUtils.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void checkFirewall(InetAddress address) {
        boolean changed = false;
        if (this.isOutsideConnection(address)) {
            Class<AcceptorImpl> clazz = AcceptorImpl.class;
            // MONITORENTER : com.limegroup.gnutella.AcceptorImpl.class
            changed = this.setIncoming(true);
            ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(true);
            // MONITOREXIT : clazz
        }
        if (!changed) return;
        this.networkManager.incomingStatusChanged();
    }

    @Override
    public void processSocket(Socket client) {
        this.processSocket(client, null);
    }

    @Override
    public void processSocket(Socket client, String allowedProtocol) {
        if (!this._started) {
            IOUtils.close(client);
            return;
        }
        InetAddress address = client.getInetAddress();
        if (address == null || !NetworkUtils.isValidAddress(address) || !NetworkUtils.isValidPort(client.getPort())) {
            IOUtils.close(client);
            LOG.warn("connection closed while accepting");
        } else if (!this.ipFilter.get().allow(address.getAddress())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Ignoring banned host: " + address);
            }
            IOUtils.close(client);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatching new client connecton: " + address);
            }
            InetAddress localAddress = client.getLocalAddress();
            this.setAddress(localAddress);
            try {
                client.setSoTimeout(8000);
            }
            catch (SocketException se) {
                IOUtils.close(client);
                return;
            }
            if (client instanceof NIOMultiplexor) {
                ((NIOMultiplexor)((Object)client)).setReadObserver(new AsyncConnectionDispatcher(this.connectionDispatcher.get(), client, allowedProtocol));
            } else {
                ThreadExecutor.startThread(new BlockingConnectionDispatcher(this.connectionDispatcher.get(), client, allowedProtocol), "ConnectionDispatchRunner");
            }
        }
    }

    private boolean isOutsideConnection(InetAddress addr) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        return !this.connectionServices.isConnectedTo(addr) && !NetworkUtils.isLocalAddress(addr);
    }

    @Override
    public void resetLastConnectBackTime() {
        this._lastConnectBackTime = 0L;
    }

    @Override
    public void shutdown() {
        this.shutdownUPnP();
    }

    private void shutdownUPnP() {
        if (this.isUPnPEnabled() && this.upnpManager.get().isNATPresent() && this.upnpManager.get().mappingsExist() && ConnectionSettings.UPNP_IN_USE.getValue()) {
            ConnectionSettings.FORCE_IP_ADDRESS.revertToDefault();
            ConnectionSettings.FORCED_PORT.revertToDefault();
            ConnectionSettings.UPNP_IN_USE.revertToDefault();
        }
    }

    @Override
    public long getIncomingExpireTime() {
        return this.incomingExpireTime;
    }

    void setIncomingExpireTime(long incomingExpireTime) {
        this.incomingExpireTime = incomingExpireTime;
    }

    @Override
    public long getWaitTimeAfterRequests() {
        return this.waitTimeAfterRequests;
    }

    void setWaitTimeAfterRequests(long waitTimeAfterRequests) {
        this.waitTimeAfterRequests = waitTimeAfterRequests;
    }

    @Override
    public long getTimeBetweenValidates() {
        return this.timeBetweenValidates;
    }

    void setTimeBetweenValidates(long timeBetweenValidates) {
        this.timeBetweenValidates = timeBetweenValidates;
    }

    private class IncomingValidator
    implements Runnable {
        private final AtomicBoolean validating = new AtomicBoolean(false);
        private AtomicReference<Future<?>> futureRef = new AtomicReference();

        private IncomingValidator() {
        }

        public void run() {
            if (this.validating.getAndSet(true)) {
                return;
            }
            long currTime = System.currentTimeMillis();
            if (currTime - AcceptorImpl.this._lastConnectBackTime > AcceptorImpl.this.incomingExpireTime && ((ConnectionManager)AcceptorImpl.this.connectionManager.get()).sendTCPConnectBackRequests()) {
                AcceptorImpl.this._lastConnectBackTime = currTime;
                Runnable resetter = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean changed = false;
                        Class<AcceptorImpl> clazz = AcceptorImpl.class;
                        synchronized (AcceptorImpl.class) {
                            changed = AcceptorImpl.this.setIncoming(false);
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            if (changed) {
                                AcceptorImpl.this.networkManager.incomingStatusChanged();
                            }
                            return;
                        }
                    }
                };
                Future<?> oldRef = this.futureRef.get();
                if (oldRef != null) {
                    oldRef.cancel(false);
                }
                this.futureRef.set(AcceptorImpl.this.backgroundExecutor.schedule(resetter, AcceptorImpl.this.waitTimeAfterRequests, TimeUnit.MILLISECONDS));
            }
            this.validating.set(false);
        }

        void cancelReset() {
            Future<?> resetter = this.futureRef.get();
            if (resetter != null) {
                resetter.cancel(false);
                this.futureRef.compareAndSet(resetter, null);
            }
        }
    }

    private class SocketListener
    implements AcceptObserver {
        private SocketListener() {
        }

        public void handleIOException(IOException iox) {
            LOG.warn("IOX while accepting", iox);
        }

        public void shutdown() {
            LOG.debug("shutdown one SocketListener");
        }

        public void handleAccept(Socket client) {
            AcceptorImpl.this.processSocket(client);
        }
    }
}

