/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.BrowseHostHandlerManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.PushedSocketHandlerRegistry;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.messages.MessageFactory;
import java.io.IOException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.http.SocketWrappingHttpClient;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.net.SocketsManager;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BrowseHostHandlerManagerImpl
implements BrowseHostHandlerManager {
    private static final Log LOG = LogFactory.getLog(BrowseHostHandlerManagerImpl.class);
    private final Map<GUID, BrowseHostHandler.PushRequestDetails> _pushedHosts = new HashMap<GUID, BrowseHostHandler.PushRequestDetails>();
    private final Provider<ActivityCallback> activityCallback;
    private final SocketsManager socketsManager;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final Provider<ReplyHandler> forMeReplyHandler;
    private final ScheduledExecutorService backgroundExecutor;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final MessageFactory messageFactory;
    private Provider<SocketWrappingHttpClient> clientProvider;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public BrowseHostHandlerManagerImpl(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<ActivityCallback> activityCallback, SocketsManager socketsManager, Provider<PushDownloadManager> pushDownloadManager, @Named(value="forMeReplyHandler") Provider<ReplyHandler> forMeReplyHandler, MessageFactory messageFactory, RemoteFileDescFactory remoteFileDescFactory, Provider<SocketWrappingHttpClient> clientProvider, NetworkInstanceUtils networkInstanceUtils) {
        this.activityCallback = activityCallback;
        this.socketsManager = socketsManager;
        this.pushDownloadManager = pushDownloadManager;
        this.forMeReplyHandler = forMeReplyHandler;
        this.messageFactory = messageFactory;
        this.backgroundExecutor = backgroundExecutor;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.clientProvider = clientProvider;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public void initialize() {
        this.backgroundExecutor.scheduleWithFixedDelay(new Expirer(), 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Inject
    public void register(PushedSocketHandlerRegistry registry) {
        registry.register(this);
    }

    @Override
    public BrowseHostHandler createBrowseHostHandler(GUID guid, GUID serventID) {
        return new BrowseHostHandler(guid, serventID, new BrowseHostHandlerManager.BrowseHostCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void putInfo(GUID serventId, BrowseHostHandler.PushRequestDetails details) {
                Map map = BrowseHostHandlerManagerImpl.this._pushedHosts;
                synchronized (map) {
                    BrowseHostHandlerManagerImpl.this._pushedHosts.put(serventId, details);
                }
            }
        }, this.activityCallback.get(), this.socketsManager, this.pushDownloadManager, this.forMeReplyHandler, this.messageFactory, this.remoteFileDescFactory, this.clientProvider, this.networkInstanceUtils);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptPushedSocket(String file, int index, byte[] clientGUID, final Socket socket) {
        GUID serventID = new GUID(clientGUID);
        boolean retVal = false;
        LOG.trace("BHH.handlePush(): entered.");
        BrowseHostHandler.PushRequestDetails prd = null;
        Map<GUID, BrowseHostHandler.PushRequestDetails> map = this._pushedHosts;
        synchronized (map) {
            prd = this._pushedHosts.remove(serventID);
        }
        if (prd != null) {
            final BrowseHostHandler.PushRequestDetails finalPRD = prd;
            ThreadExecutor.startThread(new Runnable(){

                public void run() {
                    try {
                        finalPRD.getBrowseHostHandler().browseHost(socket);
                    }
                    catch (IOException e) {
                        LOG.debug("error while push transfer", e);
                        finalPRD.getBrowseHostHandler().failed();
                    }
                    catch (HttpException e) {
                        LOG.debug("error while push transfer", e);
                        finalPRD.getBrowseHostHandler().failed();
                    }
                    catch (URISyntaxException e) {
                        LOG.debug("error while push transfer", e);
                        finalPRD.getBrowseHostHandler().failed();
                    }
                    catch (InterruptedException e) {
                        LOG.debug("error while push transfer", e);
                        finalPRD.getBrowseHostHandler().failed();
                    }
                }
            }, "BrowseHost");
            retVal = true;
        } else {
            LOG.debug("BHH.handlePush(): no matching BHH.");
        }
        LOG.trace("BHH.handlePush(): returning.");
        return retVal;
    }

    private class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HashSet<GUID> toRemove = new HashSet<GUID>();
                Map map = BrowseHostHandlerManagerImpl.this._pushedHosts;
                synchronized (map) {
                    for (GUID key : BrowseHostHandlerManagerImpl.this._pushedHosts.keySet()) {
                        BrowseHostHandler.PushRequestDetails currPRD = (BrowseHostHandler.PushRequestDetails)BrowseHostHandlerManagerImpl.this._pushedHosts.get(key);
                        if (currPRD == null || !currPRD.isExpired()) continue;
                        LOG.debug("Expirer.run(): expiring a badboy.");
                        toRemove.add(key);
                        currPRD.getBrowseHostHandler().failed();
                    }
                    for (GUID key : toRemove) {
                        BrowseHostHandlerManagerImpl.this._pushedHosts.remove(key);
                    }
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

