/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.net.SocketsManager;
import org.limewire.rudp.UDPMultiplexor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ConnectionServicesImpl
implements ConnectionServices {
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<HostCatcher> hostCatcher;
    private final Provider<UDPMultiplexor> udpMultiplexor;
    private final Provider<UploadManager> uploadManager;
    private final Provider<Acceptor> acceptor;
    private final Provider<SpamServices> spamServices;

    @Inject
    public ConnectionServicesImpl(Provider<ConnectionManager> connectionManager, Provider<HostCatcher> hostCatcher, Provider<UDPMultiplexor> udpMultiplexor, Provider<UploadManager> uploadManager, Provider<Acceptor> acceptor, Provider<SpamServices> spamServices) {
        this.connectionManager = connectionManager;
        this.hostCatcher = hostCatcher;
        this.udpMultiplexor = udpMultiplexor;
        this.uploadManager = uploadManager;
        this.acceptor = acceptor;
        this.spamServices = spamServices;
    }

    @Override
    public boolean isShieldedLeaf() {
        return this.connectionManager.get().isShieldedLeaf();
    }

    @Override
    public boolean isActiveSuperNode() {
        return this.connectionManager.get().isActiveSupernode();
    }

    @Override
    public boolean isSupernode() {
        return this.connectionManager.get().isSupernode();
    }

    @Override
    public boolean isConnecting() {
        return this.connectionManager.get().isConnecting();
    }

    @Override
    public boolean isConnected() {
        return this.connectionManager.get().isConnected();
    }

    @Override
    public boolean isFullyConnected() {
        return this.connectionManager.get().isFullyConnected();
    }

    @Override
    public Collection<IpPort> getPreferencedHosts(boolean isUltrapeer, String locale, int num) {
        IpPortSet hosts = new IpPortSet();
        if (isUltrapeer) {
            hosts.addAll(this.hostCatcher.get().getUltrapeersWithFreeUltrapeerSlots(locale, num));
        } else {
            hosts.addAll(this.hostCatcher.get().getUltrapeersWithFreeLeafSlots(locale, num));
        }
        if (hosts.size() < num) {
            for (RoutedConnection ipp : this.connectionManager.get().getInitializedConnectionsMatchLocale(locale)) {
                if (hosts.size() >= num) break;
                hosts.add(ipp);
            }
            if (hosts.size() < num) {
                for (RoutedConnection ipp : this.connectionManager.get().getInitializedConnections()) {
                    if (hosts.size() >= num) break;
                    hosts.add(ipp);
                }
            }
        }
        return hosts;
    }

    @Override
    public int countConnectionsWithNMessages(int messageThreshold) {
        return this.connectionManager.get().countConnectionsWithNMessages(messageThreshold);
    }

    @Override
    public int getActiveConnectionMessages() {
        return this.connectionManager.get().getActiveConnectionMessages();
    }

    @Override
    public void removeConnection(RoutedConnection c) {
        this.connectionManager.get().remove(c);
    }

    @Override
    public void disconnect() {
        this.connectionManager.get().disconnect(false);
    }

    @Override
    public void connect() {
        this.spamServices.get().adjustSpamFilters();
        this.connectionManager.get().connect();
    }

    @Override
    public boolean isConnectedTo(InetAddress addr) {
        String host = addr.getHostAddress();
        return this.connectionManager.get().isConnectedTo(host) || this.udpMultiplexor.get().isConnectedTo(addr) || this.uploadManager.get().isConnectedTo(addr);
    }

    @Override
    public void connectToHostAsynchronously(String hostname, int portnum, SocketsManager.ConnectType type) {
        InetAddress addr;
        byte[] cIP = null;
        try {
            addr = InetAddress.getByName(hostname);
            cIP = addr.getAddress();
        }
        catch (UnknownHostException e) {
            return;
        }
        if (cIP[0] == 127 && portnum == this.acceptor.get().getPort(true) && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        byte[] managerIP = this.acceptor.get().getAddress(true);
        if (Arrays.equals(cIP, managerIP) && portnum == this.acceptor.get().getPort(true)) {
            return;
        }
        if (this.spamServices.get().isAllowed(addr)) {
            this.connectionManager.get().createConnectionAsynchronously(hostname, portnum, type);
        }
    }

    @Override
    public int getNumInitializedConnections() {
        return this.connectionManager.get().getNumInitializedConnections();
    }
}

