/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class ConnectionWatchdog {
    private static final Log LOG = LogFactory.getLog(ConnectionWatchdog.class);
    private static final int EVALUATE_TIME = 30000;
    private static final int REEVALUATE_TIME = 15000;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<ConnectionManager> connectionManager;
    private final ConnectionServices connectionServices;
    private final PingRequestFactory pingRequestFactory;

    @Inject
    public ConnectionWatchdog(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, Provider<ConnectionManager> connectionManager, ConnectionServices connectionServices, PingRequestFactory pingRequestFactory) {
        this.backgroundExecutor = backgroundExecutor;
        this.messageRouter = messageRouter;
        this.connectionManager = connectionManager;
        this.connectionServices = connectionServices;
        this.pingRequestFactory = pingRequestFactory;
    }

    public void start() {
        this.findDuds();
    }

    private void findDuds() {
        HashMap<RoutedConnection, ConnectionState> snapshot = new HashMap<RoutedConnection, ConnectionState>();
        for (RoutedConnection c : this.allConnections()) {
            if (!c.isKillable()) continue;
            snapshot.put(c, new ConnectionState(c));
        }
        this.backgroundExecutor.schedule(new DudChecker(snapshot, false), 30000L, TimeUnit.MILLISECONDS);
    }

    private void killIfStillDud(List<? extends RoutedConnection> connections) {
        HashMap<RoutedConnection, ConnectionState> snapshot = new HashMap<RoutedConnection, ConnectionState>();
        for (RoutedConnection routedConnection : connections) {
            if (!routedConnection.isKillable()) continue;
            snapshot.put(routedConnection, new ConnectionState(routedConnection));
            this.messageRouter.get().sendPingRequest(this.pingRequestFactory.createPingRequest((byte)1), routedConnection);
        }
        this.backgroundExecutor.schedule(new DudChecker(snapshot, true), 15000L, TimeUnit.MILLISECONDS);
    }

    private Iterable<RoutedConnection> allConnections() {
        List<RoutedConnection> normal = this.connectionManager.get().getInitializedConnections();
        List<RoutedConnection> leaves = this.connectionManager.get().getInitializedClientConnections();
        ArrayList<RoutedConnection> buf = new ArrayList<RoutedConnection>(normal.size() + leaves.size());
        buf.addAll(normal);
        buf.addAll(leaves);
        return buf;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DudChecker
    implements Runnable {
        private Map<RoutedConnection, ConnectionState> snapshots;
        private boolean kill;

        DudChecker(Map<RoutedConnection, ConnectionState> snapshots, boolean kill) {
            this.snapshots = snapshots;
            this.kill = kill;
        }

        @Override
        public void run() {
            List potentials = this.kill ? Collections.emptyList() : new ArrayList();
            for (RoutedConnection c : ConnectionWatchdog.this.allConnections()) {
                ConnectionState currentState;
                ConnectionState oldState;
                if (!c.isKillable() || (oldState = this.snapshots.get(c)) == null || !(currentState = new ConnectionState(c)).notProgressedSince(oldState)) continue;
                if (this.kill) {
                    if (!ConnectionSettings.WATCHDOG_ACTIVE.getValue()) continue;
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Killing connection: " + c);
                    }
                    ConnectionWatchdog.this.connectionServices.removeConnection(c);
                    continue;
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Potential dud: " + c);
                }
                potentials.add(c);
            }
            if (potentials.isEmpty()) {
                ConnectionWatchdog.this.findDuds();
            } else {
                ConnectionWatchdog.this.killIfStillDud(potentials);
            }
        }
    }

    private static class ConnectionState {
        final long sentDropped;
        final long sent;
        final long received;

        ConnectionState(RoutedConnection c) {
            this.sentDropped = c.getConnectionMessageStatistics().getNumSentMessagesDropped();
            this.sent = c.getConnectionMessageStatistics().getNumMessagesSent();
            this.received = c.getConnectionMessageStatistics().getNumMessagesReceived();
        }

        boolean notProgressedSince(ConnectionState old) {
            long numSent = this.sent - old.sent;
            long numSentDropped = this.sentDropped - old.sentDropped;
            long numReceived = this.received - old.received;
            if (numSent == numSentDropped && numSent != 0L) {
                return true;
            }
            return numReceived == 0L;
        }

        public String toString() {
            return "{sent: " + this.sent + ", sdropped: " + this.sentDropped + "}";
        }
    }
}

