/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteOrder;
import org.limewire.util.StringUtils;

public class Endpoint
implements Cloneable,
Connectable,
IpPort,
Serializable {
    private static final long serialVersionUID = 4686711693494625070L;
    private volatile InetAddress addr = null;
    private volatile String hostname = null;
    private volatile int port = 0;
    private volatile long files = -1L;
    private volatile long kbytes = -1L;

    protected Endpoint() {
    }

    public Endpoint(String hostAndPort) throws IllegalArgumentException {
        this(hostAndPort, false);
    }

    public Endpoint(String hostAndPort, boolean requireNumeric) {
        this(hostAndPort, requireNumeric, true);
    }

    public Endpoint(String hostAndPort, boolean requireNumeric, boolean strict) {
        int DEFAULT = 6346;
        int j = hostAndPort.indexOf(":");
        if (j < 0) {
            this.hostname = hostAndPort;
            this.port = 6346;
        } else {
            if (j == 0) {
                throw new IllegalArgumentException();
            }
            if (j == hostAndPort.length() - 1) {
                this.hostname = hostAndPort.substring(0, j);
                this.port = 6346;
            } else {
                this.hostname = hostAndPort.substring(0, j);
                try {
                    this.port = Integer.parseInt(hostAndPort.substring(j + 1));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException();
                }
                if (!NetworkUtils.isValidPort(this.getPort())) {
                    throw new IllegalArgumentException("invalid port");
                }
            }
        }
        if (requireNumeric) {
            String[] numbers = StringUtils.split(this.hostname, '.');
            if (numbers.length != 4) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < numbers.length; ++i) {
                try {
                    int x = Integer.parseInt(numbers[i]);
                    if (x >= 0 && x <= 255) continue;
                    throw new IllegalArgumentException();
                }
                catch (NumberFormatException fail) {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (strict && !NetworkUtils.isValidAddress(this.hostname)) {
            throw new IllegalArgumentException("invalid address: " + this.hostname);
        }
    }

    public Endpoint(String hostname, int port) {
        this(hostname, port, true);
    }

    public Endpoint(InetAddress addr, int port) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (!NetworkUtils.isValidAddress(addr)) {
            throw new IllegalArgumentException("invalid address: " + addr);
        }
        this.addr = addr;
        this.hostname = addr.getHostAddress();
        this.port = port;
    }

    public Endpoint(String hostname, int port, boolean strict) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (strict && !NetworkUtils.isValidAddress(hostname)) {
            throw new IllegalArgumentException("invalid address: " + hostname);
        }
        this.hostname = hostname;
        this.port = port;
    }

    public Endpoint(byte[] hostBytes, int port) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (!NetworkUtils.isValidAddress(hostBytes)) {
            throw new IllegalArgumentException("invalid address");
        }
        this.port = port;
        this.hostname = NetworkUtils.ip2string(hostBytes);
    }

    public Endpoint(String hostname, int port, long files, long kbytes) {
        this(hostname, port);
        this.files = files;
        this.kbytes = kbytes;
    }

    public Endpoint(byte[] hostBytes, int port, long files, long kbytes) {
        this(hostBytes, port);
        this.files = files;
        this.kbytes = kbytes;
    }

    public Endpoint(Endpoint ep) {
        this.files = ep.files;
        this.hostname = ep.hostname;
        this.kbytes = ep.kbytes;
        this.port = ep.port;
    }

    public String toString() {
        return this.hostname + ":" + this.port;
    }

    public String getAddress() {
        return this.hostname;
    }

    public InetAddress getInetAddress() {
        if (this.addr != null) {
            return this.addr;
        }
        try {
            this.addr = InetAddress.getByName(this.hostname);
            return this.addr;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
        this.addr = null;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getInetSocketAddress() {
        InetAddress addr = this.getInetAddress();
        if (addr == null) {
            return null;
        }
        return new InetSocketAddress(addr, this.getPort());
    }

    public long getFiles() {
        return this.files;
    }

    public void setFiles(long files) {
        this.files = files;
    }

    public long getKbytes() {
        return this.kbytes;
    }

    public void normalizeFilesAndSize() {
        try {
            if (this.kbytes > 20000000L) {
                this.kbytes = 0L;
                this.files = 0L;
                return;
            }
            if (this.files > 5000L) {
                this.kbytes = 0L;
                this.files = 0L;
                return;
            }
            if (this.kbytes / this.files > 250000L) {
                this.kbytes = 0L;
                this.files = 0L;
                return;
            }
        }
        catch (ArithmeticException ae) {
            this.kbytes = 0L;
            this.files = 0L;
            return;
        }
    }

    public void setKbytes(long kbytes) {
        this.kbytes = kbytes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Endpoint)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Endpoint e = (Endpoint)o;
        return this.hostname.equals(e.hostname) && this.port == e.port;
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    protected Object clone() {
        return new Endpoint(new String(this.hostname), this.port, this.files, this.kbytes);
    }

    public byte[] getHostBytes() throws UnknownHostException {
        InetAddress ad = this.getInetAddress();
        if (ad == null) {
            throw new UnknownHostException(this.hostname);
        }
        return ad.getAddress();
    }

    public boolean isSameSubnet(Endpoint other) {
        byte[] b;
        int first;
        byte[] a;
        try {
            a = this.getHostBytes();
            first = ByteOrder.ubyte2int(a[0]);
            b = other.getHostBytes();
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (first <= 127) {
            return a[0] == b[0];
        }
        if (first <= 191) {
            return a[0] == b[0] && a[1] == b[1];
        }
        return a[0] == b[0] && a[1] == b[1] && a[2] == b[2];
    }

    public boolean isUDPHostCache() {
        return false;
    }

    public boolean isTLSCapable() {
        return false;
    }
}

