/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import java.io.File;
import java.util.EventObject;

public class FileManagerEvent
extends EventObject {
    private final Type type;
    private final FileDesc[] fds;
    private final File[] files;
    private final int relativeDepth;
    private final File rootShare;

    public FileManagerEvent(FileManager manager, Type type) {
        super(manager);
        this.type = type;
        this.fds = null;
        this.files = null;
        this.relativeDepth = -1;
        this.rootShare = null;
    }

    public FileManagerEvent(FileManager manager, Type type, FileDesc ... fds) {
        super(manager);
        this.type = type;
        this.fds = fds;
        this.relativeDepth = -1;
        this.rootShare = null;
        this.files = new File[fds != null ? fds.length : 0];
        for (int i = 0; fds != null && i < fds.length; ++i) {
            this.files[i] = fds[i].getFile();
        }
    }

    public FileManagerEvent(FileManager manager, Type type, File ... files) {
        super(manager);
        this.type = type;
        this.files = files;
        this.fds = null;
        this.relativeDepth = 0;
        this.rootShare = null;
    }

    public FileManagerEvent(FileManager manager, Type type, File rootShare, int relativeDepth, File ... files) {
        super(manager);
        this.type = type;
        this.files = files;
        this.fds = null;
        this.relativeDepth = relativeDepth;
        this.rootShare = rootShare;
    }

    public Type getType() {
        return this.type;
    }

    public FileManager getFileManager() {
        return (FileManager)this.getSource();
    }

    public FileDesc[] getFileDescs() {
        return this.fds;
    }

    public File[] getFiles() {
        return this.files;
    }

    public int getRelativeDepth() {
        return this.relativeDepth;
    }

    public File getRootShare() {
        return this.rootShare;
    }

    public boolean isAddEvent() {
        return this.type.equals((Object)Type.ADD_FILE);
    }

    public boolean isAddStoreEvent() {
        return this.type.equals((Object)Type.ADD_STORE_FILE);
    }

    public boolean isRemoveEvent() {
        return this.type.equals((Object)Type.REMOVE_FILE);
    }

    public boolean isRenameEvent() {
        return this.type.equals((Object)Type.RENAME_FILE);
    }

    public boolean isChangeEvent() {
        return this.type.equals((Object)Type.CHANGE_FILE);
    }

    public boolean isFailedEvent() {
        return this.type.equals((Object)Type.ADD_FAILED_FILE);
    }

    public boolean isAlreadySharedEvent() {
        return this.type.equals((Object)Type.ALREADY_SHARED_FILE);
    }

    public boolean isAddFolderEvent() {
        return this.type.equals((Object)Type.ADD_FOLDER);
    }

    public boolean isRemoveFolderEvent() {
        return this.type.equals((Object)Type.REMOVE_FOLDER);
    }

    public boolean isFileManagerLoading() {
        return this.type.equals((Object)Type.FILEMANAGER_LOADING);
    }

    public boolean isFileManagerLoaded() {
        return this.type.equals((Object)Type.FILEMANAGER_LOADED);
    }

    public boolean isFileEvent() {
        return !this.isFolderEvent() && !this.isFileManagerEvent();
    }

    public boolean isFolderEvent() {
        return this.isAddFolderEvent() || this.isRemoveFolderEvent();
    }

    public boolean isFileManagerEvent() {
        return this.isFileManagerLoading() || this.isFileManagerLoaded();
    }

    public String toString() {
        int i;
        StringBuilder buffer = new StringBuilder("FileManagerEvent: [event=").append((Object)this.type);
        if (this.fds != null) {
            buffer.append(", fds=").append(this.fds.length).append("\n");
            for (i = 0; i < this.fds.length; ++i) {
                buffer.append(this.fds[i]);
                if (i == this.fds.length - 1) continue;
                buffer.append(", ");
            }
        } else {
            buffer.append(", fds=null");
        }
        if (this.files != null) {
            buffer.append(", files=").append(this.files.length).append("\n");
            for (i = 0; i < this.files.length; ++i) {
                buffer.append(this.files[i]);
                if (i == this.files.length - 1) continue;
                buffer.append(", ");
            }
        } else {
            buffer.append(", files=null");
        }
        return buffer.append("]").toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ADD_FILE,
        REMOVE_FILE,
        RENAME_FILE,
        CHANGE_FILE,
        ADD_FAILED_FILE,
        ALREADY_SHARED_FILE,
        ADD_FOLDER,
        REMOVE_FOLDER,
        FILEMANAGER_LOADING,
        FILEMANAGER_LOADED,
        ADD_STORE_FILE,
        ADD_STORE_FAILED_FILE,
        REMOVE_STORE_FILE,
        ADD_STORE_FOLDER,
        REMOVE_STORE_FOLDER;

    }
}

