/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.FileManagerController;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.library.LibraryData;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.licenses.LicenseType;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.HashFunction;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Comparators;
import org.limewire.collection.Function;
import org.limewire.collection.IntSet;
import org.limewire.collection.MultiCollection;
import org.limewire.collection.MultiIterator;
import org.limewire.collection.StringTrie;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectableForSize;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.setting.StringArraySetting;
import org.limewire.statistic.StatsUtils;
import org.limewire.util.ByteOrder;
import org.limewire.util.FileUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.RPNParser;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileManagerImpl
implements FileManager {
    private static final Log LOG = LogFactory.getLog(FileManagerImpl.class);
    private static final ExecutorService LOADER = ExecutorsHelper.newProcessingQueue("FileManagerLoader");
    private static final int STORE_FILEDESC_INDEX = Integer.MAX_VALUE;
    private static long QRP_DELAY = (LimeWireUtils.isBetaRelease() ? 1 : 60) * 60 * 1000;
    private volatile CopyOnWriteArrayList<FileEventListener> eventListeners = new CopyOnWriteArrayList();
    private final LibraryData _data = new LibraryData();
    private List<FileDesc> _files;
    @InspectablePrimitive(value="total size of shared files")
    private long _filesSize;
    @InspectablePrimitive(value="number of shared files")
    private int _numFiles;
    @InspectablePrimitive(value="number of pending files")
    private int _numPendingFiles;
    @InspectablePrimitive(value="number of incomplete files")
    private int _numIncompleteFiles;
    @InspectablePrimitive(value="number force-shared files")
    private int _numForcedFiles;
    private Map<File, FileDesc> _fileToFileDescMap;
    @InspectableForSize(value="size of keyword trie")
    private StringTrie<IntSet> _keywordTrie;
    @InspectableForSize(value="size of incomplete keyword trie")
    private StringTrie<IntSet> _incompleteKeywordTrie;
    private Map<URN, IntSet> _urnMap;
    private static Set<String> _extensions;
    @InspectableForSize(value="number completely shared directories")
    private Set<File> _completelySharedDirectories;
    @InspectableForSize(value="number incompletely shared files")
    private IntSet _incompletesShared;
    private Set<URN> _requestingValidation = Collections.synchronizedSet(new HashSet());
    @InspectableForSize(value="number of transiently shared files")
    private Set<File> _transientSharedFiles = new HashSet<File>();
    private Map<File, FileDesc> _storeToFileDescMap;
    @InspectableForSize(value="number of directories for the store")
    private Set<File> _storeDirectories;
    @InspectableForSize(value="number of individually shared files")
    private Collection<File> _individualSharedFiles;
    @InspectablePrimitive(value="filemanager revision")
    protected volatile int _revision = 0;
    @InspectablePrimitive(value="revision that finished loading")
    private volatile int _pendingFinished = -1;
    private volatile int _updatingFinished = -1;
    @InspectablePrimitive(value="filemanager currently updating")
    private volatile boolean _isUpdating = false;
    private volatile int _loadingFinished = -1;
    protected volatile boolean shutdown;
    private final FileFilter SHAREABLE_FILE_FILTER = new FileFilter(){

        public boolean accept(File f) {
            return FileManagerImpl.this.isFileShareable(f);
        }
    };
    private static final FileFilter DIRECTORY_FILTER;
    private static final FileEventListener EMPTY_CALLBACK;
    protected static QueryRouteTable _queryRouteTable;
    protected static volatile boolean _needRebuild;
    private final QRPUpdater qrpUpdater = new QRPUpdater();
    private final RareFileDefinition rareDefinition;
    protected final FileManagerController fileManagerController;
    private static final Response[] EMPTY_RESPONSES;

    private static final boolean isDelimiter(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    @Inject
    public FileManagerImpl(FileManagerController fileManagerController) {
        this.fileManagerController = fileManagerController;
        this.rareDefinition = new RareFileDefinition();
        this.resetVariables();
    }

    private void resetVariables() {
        this._filesSize = 0L;
        this._numFiles = 0;
        this._numIncompleteFiles = 0;
        this._numPendingFiles = 0;
        this._numForcedFiles = 0;
        this._files = new ArrayList<FileDesc>();
        this._keywordTrie = new StringTrie(true);
        this._incompleteKeywordTrie = new StringTrie(true);
        this._urnMap = new HashMap<URN, IntSet>();
        _extensions = new HashSet<String>();
        this._completelySharedDirectories = new HashSet<File>();
        this._incompletesShared = new IntSet();
        this._fileToFileDescMap = new HashMap<File, FileDesc>();
        this._individualSharedFiles = Collections.synchronizedCollection(new MultiCollection<File>((Collection<File>)this._transientSharedFiles, (Collection<File>)this._data.SPECIAL_FILES_TO_SHARE));
        this._storeToFileDescMap = new HashMap<File, FileDesc>();
        this._storeDirectories = new HashSet<File>();
    }

    @Override
    public void start() {
        this._data.clean();
        this.cleanIndividualFiles();
        this.loadSettings();
        this.fileManagerController.addSimppListener(this.qrpUpdater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAndWait(long timeout) throws InterruptedException, TimeoutException {
        final CountDownLatch startedLatch = new CountDownLatch(1);
        FileEventListener listener = new FileEventListener(){

            public void handleFileEvent(FileManagerEvent evt) {
                if (evt.getType() == FileManagerEvent.Type.FILEMANAGER_LOADED) {
                    startedLatch.countDown();
                }
            }
        };
        try {
            this.addFileEventListener(listener);
            this.start();
            if (!startedLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Initialization of FileManager did not complete within " + timeout + " ms");
            }
        }
        finally {
            this.removeFileEventListener(listener);
        }
    }

    @Override
    public void stop() {
        this.save();
        this.fileManagerController.removeSimppListener(this.qrpUpdater);
        this.shutdown = true;
    }

    protected void save() {
        this._data.save();
        this.fileManagerController.save();
    }

    @Override
    public int getSize() {
        return ByteOrder.long2int(this._filesSize);
    }

    @Override
    public int getNumFiles() {
        return this._numFiles - this._numForcedFiles;
    }

    @Override
    public int getNumStoreFiles() {
        return this._storeToFileDescMap.size();
    }

    @Override
    public int getNumIncompleteFiles() {
        return this._numIncompleteFiles;
    }

    @Override
    public int getNumPendingFiles() {
        return this._numPendingFiles;
    }

    @Override
    public int getNumForcedFiles() {
        return this._numForcedFiles;
    }

    @Override
    public synchronized FileDesc get(int i) {
        return this._files.get(i);
    }

    @Override
    public synchronized boolean isValidIndex(int i) {
        return i >= 0 && i < this._files.size();
    }

    @Override
    public synchronized URN getURNForFile(File f) {
        FileDesc fd = this.getFileDescForFile(f);
        if (fd != null) {
            return fd.getSHA1Urn();
        }
        return null;
    }

    @Override
    public synchronized FileDesc getFileDescForFile(File f) {
        try {
            f = FileUtils.getCanonicalFile(f);
        }
        catch (IOException ioe) {
            return null;
        }
        if (this._fileToFileDescMap.containsKey(f)) {
            return this._fileToFileDescMap.get(f);
        }
        return this._storeToFileDescMap.get(f);
    }

    @Override
    public synchronized boolean isUrnShared(URN urn) {
        FileDesc fd = this.getFileDescForUrn(urn);
        return fd != null && !(fd instanceof IncompleteFileDesc);
    }

    @Override
    public synchronized FileDesc getFileDescForUrn(URN urn) {
        if (!urn.isSHA1()) {
            throw new IllegalArgumentException();
        }
        IntSet indices = this._urnMap.get(urn);
        if (indices == null) {
            return null;
        }
        IntSet.IntSetIterator iter = indices.iterator();
        FileDesc ret = null;
        while (iter.hasNext() && (ret == null || ret instanceof IncompleteFileDesc)) {
            int index = iter.next();
            ret = this._files.get(index);
        }
        return ret;
    }

    @Override
    public synchronized FileDesc[] getIncompleteFileDescriptors() {
        if (this._incompletesShared == null) {
            return null;
        }
        FileDesc[] ret = new FileDesc[this._incompletesShared.size()];
        IntSet.IntSetIterator iter = this._incompletesShared.iterator();
        int i = 0;
        while (iter.hasNext()) {
            FileDesc fd = this._files.get(iter.next());
            assert (fd != null) : "Directory has null entry";
            ret[i] = fd;
            ++i;
        }
        return ret;
    }

    @Override
    public synchronized FileDesc[] getAllSharedFileDescriptors() {
        FileDesc[] fds = new FileDesc[this._fileToFileDescMap.size()];
        fds = this._fileToFileDescMap.values().toArray(fds);
        return fds;
    }

    @Override
    public synchronized List<FileDesc> getSharedFilesInDirectory(File directory) {
        if (directory == null) {
            throw new NullPointerException("null directory");
        }
        try {
            directory = FileUtils.getCanonicalFile(directory);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        ArrayList<FileDesc> shared = new ArrayList<FileDesc>();
        for (FileDesc fd : this._fileToFileDescMap.values()) {
            if (!directory.equals(fd.getFile().getParentFile())) continue;
            shared.add(fd);
        }
        return shared;
    }

    @Override
    public void loadSettings() {
        final int currentRevision = ++this._revision;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting new library revision: " + currentRevision);
        }
        LOADER.execute(new Runnable(){

            public void run() {
                FileManagerImpl.this.loadStarted(currentRevision);
                FileManagerImpl.this.loadSettingsInternal(currentRevision);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSettingsAndWait(long timeout) throws InterruptedException, TimeoutException {
        final CountDownLatch loadedLatch = new CountDownLatch(1);
        FileEventListener listener = new FileEventListener(){

            public void handleFileEvent(FileManagerEvent evt) {
                if (evt.getType() == FileManagerEvent.Type.FILEMANAGER_LOADED) {
                    loadedLatch.countDown();
                }
            }
        };
        try {
            this.addFileEventListener(listener);
            this.loadSettings();
            if (!loadedLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Loading of FileManager settings did not complete within " + timeout + " ms");
            }
        }
        finally {
            this.removeFileEventListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadWithNewDirectories(Set<? extends File> shared, Set<File> blackListSet) {
        SharingSettings.DIRECTORIES_TO_SHARE.setValue(shared);
        Set<File> set = this._data.DIRECTORIES_NOT_TO_SHARE;
        synchronized (set) {
            this._data.DIRECTORIES_NOT_TO_SHARE.clear();
            this._data.DIRECTORIES_NOT_TO_SHARE.addAll(FileManagerImpl.canonicalize(blackListSet));
            this._storeDirectories.clear();
            this._storeDirectories.add(SharingSettings.getSaveLWSDirectory());
        }
        this.loadSettings();
    }

    protected void loadStarted(int revision) {
        this.fileManagerController.loadStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToFinish() {
        int revision;
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            if (this._pendingFinished != this._updatingFinished || this._pendingFinished != this._revision || this._loadingFinished >= this._revision) {
                return;
            }
            revision = this._loadingFinished = this._revision;
        }
        this.loadFinished(revision);
    }

    protected void loadFinished(int revision) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished loading revision: " + revision);
        }
        this.trim();
        this.fileManagerController.loadFinished();
        this.save();
        this.fileManagerController.loadFinishedPostSave();
        this.dispatchFileEvent(new FileManagerEvent(this, FileManagerEvent.Type.FILEMANAGER_LOADED));
    }

    @Override
    public boolean isLoadFinished() {
        return this._loadingFinished == this._revision;
    }

    @Override
    public boolean isUpdating() {
        return this._isUpdating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettingsInternal(int revision) {
        ArrayList<File> list;
        File[] directories;
        Object array;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading Library Revision: " + revision);
        }
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            String[] extensions;
            this.resetVariables();
            for (String ext : extensions = StringArraySetting.decode(SharingSettings.EXTENSIONS_TO_SHARE.getValue().toLowerCase())) {
                _extensions.add(ext);
            }
            if (SharingSettings.EXTENSIONS_LIST_CUSTOM.getValue().length() > 0) {
                for (String ext : array = StringArraySetting.decode(SharingSettings.EXTENSIONS_LIST_CUSTOM.getValue())) {
                    _extensions.add(ext);
                }
            }
            if (SharingSettings.DISABLE_SENSITIVE.getValue()) {
                for (String ext : SharingSettings.getDefaultDisabledExtensions()) {
                    _extensions.remove(ext);
                }
            }
            if (SharingSettings.EXTENSIONS_LIST_UNSHARED.getValue().length() > 0) {
                for (String ext : array = StringArraySetting.decode(SharingSettings.EXTENSIONS_LIST_UNSHARED.getValue())) {
                    _extensions.remove(ext);
                }
            }
            directories = SharingSettings.DIRECTORIES_TO_SHARE.getValueAsArray();
            Arrays.sort(directories, new Comparator<File>(){

                @Override
                public int compare(File a, File b) {
                    return a.toString().length() - b.toString().length();
                }
            });
        }
        this.fileManagerController.fileManagerLoading();
        this.dispatchFileEvent(new FileManagerEvent(this, FileManagerEvent.Type.FILEMANAGER_LOADING));
        this.updateSharedDirectories(SharingUtils.PROGRAM_SHARE, null, revision);
        this.updateSharedDirectories(SharingUtils.PREFERENCE_SHARE, null, revision);
        this._isUpdating = true;
        for (int i = 0; i < directories.length && this._revision == revision; ++i) {
            this.updateSharedDirectories(directories[i], null, revision);
        }
        Collection<File> specialFiles = this._individualSharedFiles;
        array = specialFiles;
        synchronized (array) {
            list = new ArrayList<File>(specialFiles);
        }
        for (File file : list) {
            if (this._revision != revision) break;
            System.out.println("*****SPECIAL FILE IS: " + file);
            this.addFileIfSharedOrStore(file, EMPTY_DOCUMENTS, true, this._revision, null, AddType.ADD_SHARE);
        }
        this._isUpdating = false;
        this.trim();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished queueing shared files for revision: " + revision);
        }
        FileManagerImpl fileManagerImpl2 = this;
        synchronized (fileManagerImpl2) {
            this._updatingFinished = revision;
            if (this._numPendingFiles == 0) {
                this._pendingFinished = revision;
            }
        }
        this.tryToFinish();
    }

    private void updateSharedDirectories(File directory, File parent, int revision) {
        this.updateSharedDirectories(directory, directory, parent, revision, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSharedDirectories(File rootShare, File directory, File parent, int revision, int depth) {
        try {
            directory = FileUtils.getCanonicalFile(directory);
        }
        catch (IOException e) {
            return;
        }
        if (!directory.exists()) {
            return;
        }
        if (!this.isFolderShareable(directory, true)) {
            return;
        }
        if (SharingUtils.isSensitiveDirectory(directory)) {
            if (this._data.SENSITIVE_DIRECTORIES_NOT_TO_SHARE.contains(directory)) {
                return;
            }
            if (!this._data.SENSITIVE_DIRECTORIES_VALIDATED.contains(directory) && !this.fileManagerController.warnAboutSharingSensitiveDirectory(directory)) {
                return;
            }
        }
        if (this._revision != revision) {
            return;
        }
        boolean isForcedShare = SharingUtils.isForcedShareDirectory(directory);
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            if (this._completelySharedDirectories.contains(directory)) {
                return;
            }
            if (!this._storeDirectories.contains(directory)) {
                this._completelySharedDirectories.add(directory);
            }
            if (!isForcedShare) {
                this.dispatchFileEvent(new FileManagerEvent((FileManager)this, FileManagerEvent.Type.ADD_FOLDER, rootShare, depth, directory, parent));
            }
        }
        File[] file_list = directory.listFiles(this.SHAREABLE_FILE_FILTER);
        if (file_list == null) {
            return;
        }
        for (int i = 0; i < file_list.length && this._revision == revision; ++i) {
            this.addFileIfSharedOrStore(file_list[i], EMPTY_DOCUMENTS, true, this._revision, null, AddType.ADD_SHARE);
        }
        if (this._revision != revision) {
            return;
        }
        if (isForcedShare) {
            return;
        }
        File[] dir_list = directory.listFiles(DIRECTORY_FILTER);
        if (dir_list != null) {
            for (int i = 0; i < dir_list.length && this._revision == revision; ++i) {
                this.updateSharedDirectories(rootShare, dir_list[i], directory, revision, depth + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStoreDirectories(File directory, File parent, int revision) {
        try {
            directory = FileUtils.getCanonicalFile(directory);
        }
        catch (IOException e) {
            return;
        }
        if (!directory.exists()) {
            return;
        }
        if (this._revision != revision) {
            return;
        }
        FileManagerImpl e = this;
        synchronized (e) {
            if (this._storeDirectories.contains(directory)) {
                return;
            }
            this._storeDirectories.add(directory);
            this.dispatchFileEvent(new FileManagerEvent((FileManager)this, FileManagerEvent.Type.ADD_STORE_FOLDER, directory, parent));
        }
        File[] file_list = directory.listFiles();
        if (file_list == null) {
            return;
        }
        for (int i = 0; i < file_list.length && this._revision == revision; ++i) {
            this.addFileIfSharedOrStore(file_list[i], EMPTY_DOCUMENTS, true, this._revision, null, AddType.ADD_STORE);
        }
        if (this._revision != revision) {
            return;
        }
        File[] dir_list = directory.listFiles(DIRECTORY_FILTER);
        if (dir_list != null) {
            for (int i = 0; i < dir_list.length && this._revision == revision; ++i) {
                this.updateStoreDirectories(dir_list[i], directory, revision);
            }
        }
    }

    @Override
    public void removeFolderIfShared(File folder) {
        this._isUpdating = true;
        this.removeFolderIfShared(folder, null);
        this._isUpdating = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFolderIfShared(File folder, File parent) {
        boolean contained;
        if (!folder.isDirectory() && folder.exists()) {
            throw new IllegalArgumentException("Expected a directory, but given: " + folder);
        }
        try {
            folder = FileUtils.getCanonicalFile(folder);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            contained = this._completelySharedDirectories.contains(folder);
        }
        if (contained) {
            boolean explicitlyShared22;
            if (parent != null && SharingSettings.DIRECTORIES_TO_SHARE.contains(folder)) {
                return;
            }
            if (parent == null && (!(explicitlyShared22 = SharingSettings.DIRECTORIES_TO_SHARE.remove(folder)) || this.isFolderShared(folder.getParentFile()))) {
                this._data.DIRECTORIES_NOT_TO_SHARE.add(folder);
            }
            FileManagerImpl explicitlyShared22 = this;
            synchronized (explicitlyShared22) {
                this._completelySharedDirectories.remove(folder);
            }
            File[] subs = folder.listFiles();
            if (subs != null) {
                for (int i = 0; i < subs.length; ++i) {
                    File f = subs[i];
                    if (f.isDirectory()) {
                        this.removeFolderIfShared(f, folder);
                        continue;
                    }
                    if (!f.isFile() || this._individualSharedFiles.contains(f)) continue;
                    if (this.removeFileIfShared(f) == null) {
                        this.fileManagerController.clearPendingShare(f);
                    }
                    if (!this.isStoreFile(f)) continue;
                    this._data.SPECIAL_STORE_FILES.remove(f);
                }
            }
            this.dispatchFileEvent(new FileManagerEvent((FileManager)this, FileManagerEvent.Type.REMOVE_FOLDER, folder));
        }
    }

    @Override
    public void addSharedFolders(Set<File> folders, Set<File> blackListedSet) {
        if (folders.isEmpty()) {
            throw new IllegalArgumentException("Only blacklisting without sharing, not allowed");
        }
        this._data.DIRECTORIES_NOT_TO_SHARE.addAll(FileManagerImpl.canonicalize(blackListedSet));
        for (File folder : folders) {
            this.addSharedFolder(folder);
        }
    }

    private static Set<File> canonicalize(Set<File> files) {
        HashSet<File> canonical = new HashSet(files.size());
        try {
            for (File excluded : files) {
                canonical.add(FileUtils.getCanonicalFile(excluded));
            }
        }
        catch (IOException ie) {
            canonical = files;
        }
        return canonical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<File> getFolderNotToShare() {
        Set<File> set = this._data.DIRECTORIES_NOT_TO_SHARE;
        synchronized (set) {
            return new HashSet<File>(this._data.DIRECTORIES_NOT_TO_SHARE);
        }
    }

    @Override
    public boolean addSharedFolder(File folder) {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("Expected a directory, but given: " + folder);
        }
        try {
            folder = FileUtils.getCanonicalFile(folder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.isFolderShareable(folder, false)) {
            return false;
        }
        this._data.DIRECTORIES_NOT_TO_SHARE.remove(folder);
        if (!this.isFolderShared(folder.getParentFile())) {
            SharingSettings.DIRECTORIES_TO_SHARE.add(folder);
        }
        this._isUpdating = true;
        this.updateSharedDirectories(folder, null, this._revision);
        this._isUpdating = false;
        return true;
    }

    @Override
    public void addFileAlways(File file) {
        this.addFileAlways(file, EMPTY_DOCUMENTS, null);
    }

    @Override
    public void addFileAlways(File file, FileEventListener callback) {
        this.addFileAlways(file, EMPTY_DOCUMENTS, callback);
    }

    @Override
    public void addFileAlways(File file, List<? extends LimeXMLDocument> list) {
        this.addFileAlways(file, list, null);
    }

    @Override
    public void addFileAlways(File file, List<? extends LimeXMLDocument> list, FileEventListener callback) {
        this._data.FILES_NOT_TO_SHARE.remove(file);
        if (!this.isFileShareable(file)) {
            this._data.SPECIAL_FILES_TO_SHARE.add(file);
        }
        this.addFileIfSharedOrStore(file, list, true, this._revision, callback, AddType.ADD_SHARE);
    }

    @Override
    public void addFileForSession(File file) {
        this.addFileForSession(file, null);
    }

    @Override
    public void addFileForSession(File file, FileEventListener callback) {
        this._data.FILES_NOT_TO_SHARE.remove(file);
        if (!this.isFileShareable(file)) {
            this._transientSharedFiles.add(file);
        }
        this.addFileIfSharedOrStore(file, EMPTY_DOCUMENTS, true, this._revision, callback, AddType.ADD_SHARE);
    }

    @Override
    public void addFileIfShared(File file) {
        this.addFileIfSharedOrStore(file, EMPTY_DOCUMENTS, true, this._revision, null, AddType.ADD_SHARE);
    }

    @Override
    public void addFileIfShared(File file, FileEventListener callback) {
        this.addFileIfSharedOrStore(file, EMPTY_DOCUMENTS, true, this._revision, callback, AddType.ADD_SHARE);
    }

    @Override
    public void addFileIfShared(File file, List<? extends LimeXMLDocument> list) {
        this.addFileIfSharedOrStore(file, list, true, this._revision, null, AddType.ADD_SHARE);
    }

    @Override
    public void addFileIfShared(File file, List<? extends LimeXMLDocument> list, FileEventListener callback) {
        this.addFileIfSharedOrStore(file, list, true, this._revision, callback, AddType.ADD_SHARE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileIfSharedOrStore(File file, List<? extends LimeXMLDocument> metadata, boolean notify, int revision, FileEventListener callback, AddType addFileType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to load store or shared file: " + file);
        }
        if (callback == null) {
            callback = EMPTY_CALLBACK;
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException e) {
            callback.handleFileEvent(new FileManagerEvent((FileManager)this, addFileType.getFailureType(), file));
            return;
        }
        if (!this.isFileShareable(file) && !this.isFileLocatedStoreDirectory(file)) {
            this._individualSharedFiles.remove(file);
            callback.handleFileEvent(new FileManagerEvent((FileManager)this, addFileType.getFailureType(), file));
            return;
        }
        if (this.isStoreFile(file)) {
            return;
        }
        if (this.isFileShared(file)) {
            callback.handleFileEvent(new FileManagerEvent((FileManager)this, FileManagerEvent.Type.ALREADY_SHARED_FILE, file));
            return;
        }
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            if (revision != this._revision) {
                callback.handleFileEvent(new FileManagerEvent((FileManager)this, addFileType.getFailureType(), file));
                return;
            }
            ++this._numPendingFiles;
            this._pendingFinished = -1;
        }
        this.fileManagerController.calculateAndCacheUrns(file, this.getNewUrnCallback(file, metadata, notify, revision, callback, addFileType));
    }

    protected UrnCallback getNewUrnCallback(final File file, final List<? extends LimeXMLDocument> metadata, final boolean notify, final int revision, final FileEventListener callback, final AddType addFileType) {
        return new UrnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void urnsCalculated(File f, Set<? extends URN> urns) {
                FileDesc fd = null;
                FileManagerImpl fileManagerImpl = FileManagerImpl.this;
                synchronized (fileManagerImpl) {
                    if (revision != FileManagerImpl.this._revision) {
                        LOG.warn("Revisions changed, dropping share.");
                        callback.handleFileEvent(new FileManagerEvent((FileManager)FileManagerImpl.this, addFileType.getFailureType(), file));
                        return;
                    }
                    FileManagerImpl.this._numPendingFiles--;
                    if (!urns.isEmpty()) {
                        int fileIndex = FileManagerImpl.this._files.size();
                        fd = FileManagerImpl.this.createFileDesc(file, urns, fileIndex);
                    }
                }
                if (fd == null) {
                    callback.handleFileEvent(new FileManagerEvent((FileManager)FileManagerImpl.this, addFileType.getFailureType(), file));
                    return;
                }
                FileManagerImpl.this.loadFile(fd, file, metadata, urns);
                if (FileManagerImpl.this.isStoreXML(fd.getXMLDocument())) {
                    FileManagerImpl.this.addStoreFile(fd, file, urns, addFileType, notify, callback);
                } else if (addFileType == AddType.ADD_SHARE) {
                    FileManagerImpl.this.addSharedFile(file, fd, urns, addFileType, notify, callback);
                }
                boolean finished = false;
                8 var5_7 = this;
                synchronized (var5_7) {
                    if (FileManagerImpl.this._numPendingFiles == 0) {
                        FileManagerImpl.this._pendingFinished = revision;
                        finished = true;
                    }
                }
                if (finished) {
                    FileManagerImpl.this.tryToFinish();
                }
            }

            @Override
            public boolean isOwner(Object o) {
                return o == FileManagerImpl.this.fileManagerController;
            }
        };
    }

    protected void loadFile(FileDesc fd, File file, List<? extends LimeXMLDocument> metadata, Set<? extends URN> urns) {
    }

    private synchronized void addStoreFile(FileDesc fd, File file, Set<? extends URN> urns, AddType addFileType, boolean notify, FileEventListener callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sharing file: " + file);
        }
        if (addFileType == AddType.ADD_SHARE) {
            this._data.SPECIAL_STORE_FILES.add(file);
        }
        FileDesc fileDesc = this.createFileDesc(file, urns, Integer.MAX_VALUE);
        if (fd.getXMLDocument() != null) {
            fileDesc.addLimeXMLDocument(fd.getXMLDocument());
        }
        this._storeToFileDescMap.put(file, fileDesc);
        FileManagerEvent evt = new FileManagerEvent((FileManager)this, FileManagerEvent.Type.ADD_STORE_FILE, fileDesc);
        if (notify) {
            this.dispatchFileEvent(evt);
        }
        callback.handleFileEvent(evt);
    }

    private synchronized void addSharedFile(File file, FileDesc fileDesc, Set<? extends URN> urns, AddType addFileType, boolean notify, FileEventListener callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sharing file: " + file);
        }
        if (fileDesc.getIndex() != this._files.size()) {
            LimeXMLDocument doc = fileDesc.getXMLDocument();
            fileDesc = this.createFileDesc(file, urns, this._files.size());
            if (doc != null) {
                fileDesc.addLimeXMLDocument(doc);
            }
        }
        long fileLength = file.length();
        this._filesSize += fileLength;
        this._files.add(fileDesc);
        this._fileToFileDescMap.put(file, fileDesc);
        ++this._numFiles;
        File parent = file.getParentFile();
        assert (parent != null) : "Null parent to \"" + file + "\"";
        if (SharingUtils.isForcedShareDirectory(parent)) {
            ++this._numForcedFiles;
        }
        this.loadKeywords(this._keywordTrie, fileDesc);
        if (!SharingUtils.isForcedShare(file)) {
            this.fileManagerController.fileAdded(file, fileDesc.getSHA1Urn());
        }
        this.updateUrnIndex(fileDesc);
        _needRebuild = true;
        FileManagerEvent evt = new FileManagerEvent((FileManager)this, addFileType.getSuccessType(), fileDesc);
        if (notify) {
            this.dispatchFileEvent(evt);
        }
        callback.handleFileEvent(evt);
    }

    private void loadKeywords(StringTrie<IntSet> trie, FileDesc fd) {
        String[] keywords = FileManagerImpl.extractKeywords(fd);
        for (int i = 0; i < keywords.length; ++i) {
            String keyword = keywords[i];
            IntSet indices = trie.get(keyword);
            if (indices == null) {
                indices = new IntSet();
                trie.add(keyword, indices);
            }
            indices.add(fd.getIndex());
        }
    }

    private FileDesc createFileDesc(File file, Set<? extends URN> urns, int index) {
        FileDesc fileDesc = new FileDesc(file, urns, index);
        ContentResponseData r = this.fileManagerController.getResponseDataFor(fileDesc.getSHA1Urn());
        if (r != null && !r.isOK()) {
            return null;
        }
        return fileDesc;
    }

    @Override
    public synchronized FileDesc stopSharingFile(File file) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException e) {
            return null;
        }
        boolean removed = this._individualSharedFiles.remove(file);
        FileDesc fd = this.removeFileIfShared(file);
        if (fd == null) {
            this.fileManagerController.clearPendingShare(file);
        } else {
            file = fd.getFile();
            if (!removed) {
                this._data.FILES_NOT_TO_SHARE.add(file);
            }
        }
        return fd;
    }

    @Override
    public synchronized FileDesc removeFileIfShared(File f) {
        return this.removeFileIfShared(f, true);
    }

    protected synchronized FileDesc removeFileIfShared(File f, boolean notify) {
        try {
            f = FileUtils.getCanonicalFile(f);
        }
        catch (IOException e) {
            return null;
        }
        FileDesc fd = this._fileToFileDescMap.get(f);
        if (fd == null) {
            return null;
        }
        int i = fd.getIndex();
        assert (this._files.get(i).getFile().equals(f)) : "invariant broken!";
        this._files.set(i, null);
        this._fileToFileDescMap.remove(f);
        _needRebuild = true;
        if (fd instanceof IncompleteFileDesc) {
            this.removeUrnIndex(fd, false);
            this.removeKeywords(this._incompleteKeywordTrie, fd);
            --this._numIncompleteFiles;
            boolean removed = this._incompletesShared.remove(i);
            assert (removed) : "File " + i + " not found in " + this._incompletesShared;
            if (notify) {
                FileManagerEvent evt = new FileManagerEvent((FileManager)this, FileManagerEvent.Type.REMOVE_FILE, fd);
                this.dispatchFileEvent(evt);
            }
            return fd;
        }
        --this._numFiles;
        this._filesSize -= fd.getFileSize();
        File parent = f.getParentFile();
        if (SharingUtils.isForcedShareDirectory(parent)) {
            notify = false;
            --this._numForcedFiles;
        }
        this.removeKeywords(this._keywordTrie, fd);
        this.removeUrnIndex(fd, true);
        if (notify) {
            FileManagerEvent evt = new FileManagerEvent((FileManager)this, FileManagerEvent.Type.REMOVE_FILE, fd);
            this.dispatchFileEvent(evt);
        }
        return fd;
    }

    private void removeKeywords(StringTrie<IntSet> trie, FileDesc fd) {
        String[] keywords = FileManagerImpl.extractKeywords(fd);
        for (int j = 0; j < keywords.length; ++j) {
            String keyword = keywords[j];
            IntSet indices = trie.get(keyword);
            if (indices == null) continue;
            indices.remove(fd.getIndex());
            if (indices.size() != 0) continue;
            trie.remove(keyword);
        }
    }

    protected synchronized FileDesc removeStoreFile(File f, boolean notify) {
        try {
            f = FileUtils.getCanonicalFile(f);
        }
        catch (IOException e) {
            return null;
        }
        FileDesc fd = this._storeToFileDescMap.get(f);
        if (fd == null) {
            return null;
        }
        this._data.SPECIAL_STORE_FILES.remove(f);
        this._storeToFileDescMap.remove(f);
        if (notify) {
            FileManagerEvent evt = new FileManagerEvent((FileManager)this, FileManagerEvent.Type.REMOVE_STORE_FILE, fd);
            this.dispatchFileEvent(evt);
        }
        return fd;
    }

    @Override
    public synchronized void addIncompleteFile(File incompleteFile, Set<? extends URN> urns, String name, long size, VerifyingFile vf) {
        try {
            incompleteFile = FileUtils.getCanonicalFile(incompleteFile);
        }
        catch (IOException ioe) {
            return;
        }
        for (URN uRN : urns) {
            IntSet shared;
            if (!uRN.isSHA1() || (shared = this._urnMap.get(uRN)) == null) continue;
            IntSet.IntSetIterator isIter = shared.iterator();
            while (isIter.hasNext()) {
                String path;
                String incPath;
                int i = isIter.next();
                FileDesc desc = this._files.get(i);
                if (desc == null || !(incPath = incompleteFile.getAbsolutePath()).equals(path = desc.getFile().getAbsolutePath())) continue;
                return;
            }
        }
        int fileIndex = this._files.size();
        this._incompletesShared.add(fileIndex);
        IncompleteFileDesc incompleteFileDesc = new IncompleteFileDesc(incompleteFile, urns, fileIndex, name, size, vf);
        this._files.add(incompleteFileDesc);
        this._fileToFileDescMap.put(incompleteFile, incompleteFileDesc);
        this.fileURNSUpdated(incompleteFileDesc);
        ++this._numIncompleteFiles;
        _needRebuild = true;
        this.dispatchFileEvent(new FileManagerEvent((FileManager)this, FileManagerEvent.Type.ADD_FILE, incompleteFileDesc));
    }

    @Override
    public abstract void fileChanged(File var1);

    @Override
    public void validate(final FileDesc fd) {
        if (this._requestingValidation.add(fd.getSHA1Urn())) {
            this.fileManagerController.requestValidation(fd.getSHA1Urn(), new ContentResponseObserver(){

                public void handleResponse(URN urn, ContentResponseData r) {
                    FileManagerImpl.this._requestingValidation.remove(fd.getSHA1Urn());
                    if (r != null && !r.isOK()) {
                        FileManagerImpl.this.removeFileIfShared(fd.getFile());
                    }
                }
            });
        }
    }

    @Override
    public synchronized void fileURNSUpdated(FileDesc fd) {
        this.updateUrnIndex(fd);
        if (fd instanceof IncompleteFileDesc) {
            IncompleteFileDesc ifd = (IncompleteFileDesc)fd;
            if (SharingSettings.ALLOW_PARTIAL_SHARING.getValue() && SharingSettings.LOAD_PARTIAL_KEYWORDS.getValue() && ifd.hasUrnsAndPartialData()) {
                this.loadKeywords(this._incompleteKeywordTrie, fd);
                _needRebuild = true;
            }
        }
    }

    private synchronized void updateUrnIndex(FileDesc fileDesc) {
        for (URN urn : fileDesc.getUrns()) {
            if (!urn.isSHA1()) continue;
            IntSet indices = this._urnMap.get(urn);
            if (indices == null) {
                indices = new IntSet();
                this._urnMap.put(urn, indices);
            }
            indices.add(fileDesc.getIndex());
        }
    }

    private static String[] extractKeywords(FileDesc fd) {
        return StringUtils.split(I18NConvert.instance().getNorm(fd.getPath()), " -._+/*()\\,");
    }

    private synchronized void removeUrnIndex(FileDesc fileDesc, boolean purgeState) {
        for (URN urn : fileDesc.getUrns()) {
            if (!urn.isSHA1()) continue;
            IntSet indices = this._urnMap.get(urn);
            if (indices == null) {
                assert (fileDesc instanceof IncompleteFileDesc);
                return;
            }
            indices.remove(fileDesc.getIndex());
            if (indices.size() != 0 || !purgeState) continue;
            this.fileManagerController.lastUrnRemoved(urn);
            this._urnMap.remove(urn);
        }
    }

    @Override
    public void renameFileIfSharedOrStore(File oldName, File newName) {
        this.renameFileIfSharedOrStore(oldName, newName, null);
    }

    @Override
    public synchronized void renameFileIfSharedOrStore(File oldName, File newName, final FileEventListener callback) {
        FileDesc toRemove = this.getFileDescForFile(oldName);
        if (toRemove == null) {
            FileManagerEvent evt = new FileManagerEvent((FileManager)this, FileManagerEvent.Type.ADD_FAILED_FILE, oldName);
            this.dispatchFileEvent(evt);
            if (callback != null) {
                callback.handleFileEvent(evt);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to rename: " + oldName + " to: " + newName);
        }
        LinkedList<LimeXMLDocument> xmlDocs = new LinkedList<LimeXMLDocument>(toRemove.getLimeXMLDocuments());
        if (toRemove.getIndex() != Integer.MAX_VALUE) {
            final FileDesc removed = this.removeFileIfShared(oldName, false);
            assert (removed == toRemove) : "invariant broken.";
            if (this._data.SPECIAL_FILES_TO_SHARE.remove(oldName) && !this.isFileInCompletelySharedDirectory(newName)) {
                this._data.SPECIAL_FILES_TO_SHARE.add(newName);
            }
            this.fileManagerController.addUrns(newName, removed.getUrns());
            this.addFileIfSharedOrStore(newName, xmlDocs, false, this._revision, new FileEventListener(){

                public void handleFileEvent(FileManagerEvent evt) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Add of newFile returned callback: " + evt);
                    }
                    FileManagerEvent newEvt = null;
                    if (evt.isAddEvent()) {
                        FileDesc fd = evt.getFileDescs()[0];
                        newEvt = new FileManagerEvent((FileManager)FileManagerImpl.this, FileManagerEvent.Type.RENAME_FILE, removed, fd);
                    } else {
                        newEvt = new FileManagerEvent((FileManager)FileManagerImpl.this, FileManagerEvent.Type.REMOVE_FILE, removed);
                    }
                    FileManagerImpl.this.dispatchFileEvent(newEvt);
                    if (callback != null) {
                        callback.handleFileEvent(newEvt);
                    }
                }
            }, AddType.ADD_SHARE);
        } else {
            final FileDesc removed = this.removeStoreFile(oldName, false);
            assert (removed == toRemove) : "invariant broken.";
            if (this._data.SPECIAL_STORE_FILES.remove(oldName)) {
                this._data.SPECIAL_STORE_FILES.add(newName);
            }
            this.fileManagerController.addUrns(newName, removed.getUrns());
            this.addFileIfSharedOrStore(newName, xmlDocs, false, this._revision, new FileEventListener(){

                public void handleFileEvent(FileManagerEvent evt) {
                    FileManagerEvent newEvt = null;
                    if (evt.isAddStoreEvent()) {
                        FileDesc fd = evt.getFileDescs()[0];
                        newEvt = new FileManagerEvent((FileManager)FileManagerImpl.this, FileManagerEvent.Type.RENAME_FILE, removed, fd);
                    } else {
                        newEvt = new FileManagerEvent((FileManager)FileManagerImpl.this, FileManagerEvent.Type.REMOVE_STORE_FILE, removed);
                    }
                    FileManagerImpl.this.dispatchFileEvent(newEvt);
                    if (callback != null) {
                        callback.handleFileEvent(newEvt);
                    }
                }
            }, AddType.ADD_STORE);
        }
    }

    private synchronized void trim() {
        this._keywordTrie.trim(new Function<IntSet, IntSet>(){

            @Override
            public IntSet apply(IntSet intSet) {
                intSet.trim();
                return intSet;
            }
        });
    }

    @Override
    public void validateSensitiveFile(File dir) {
        this._data.SENSITIVE_DIRECTORIES_VALIDATED.add(dir);
        this._data.SENSITIVE_DIRECTORIES_NOT_TO_SHARE.remove(dir);
    }

    @Override
    public void invalidateSensitiveFile(File dir) {
        this._data.SENSITIVE_DIRECTORIES_VALIDATED.remove(dir);
        this._data.SENSITIVE_DIRECTORIES_NOT_TO_SHARE.add(dir);
        SharingSettings.DIRECTORIES_TO_SHARE.remove(dir);
    }

    @Override
    public boolean hasIndividualFiles() {
        return !this._data.SPECIAL_FILES_TO_SHARE.isEmpty();
    }

    @Override
    public boolean hasIndividualStoreFiles() {
        return !this._data.SPECIAL_STORE_FILES.isEmpty();
    }

    @Override
    public boolean hasApplicationSharedFiles() {
        File[] files = SharingUtils.APPLICATION_SPECIAL_SHARE.listFiles();
        if (files == null) {
            return false;
        }
        for (File f : files) {
            if (!this.isFileShared(f)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getIndividualFiles() {
        Set<File> candidates;
        Set<File> set = candidates = this._data.SPECIAL_FILES_TO_SHARE;
        synchronized (set) {
            ArrayList<File> files = new ArrayList<File>(candidates.size());
            for (File f : candidates) {
                if (!f.exists()) continue;
                files.add(f);
            }
            if (files.isEmpty()) {
                return new File[0];
            }
            return files.toArray(new File[files.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getIndividualStoreFiles() {
        Set<File> candidates;
        Set<File> set = candidates = this._data.SPECIAL_STORE_FILES;
        synchronized (set) {
            ArrayList<File> files = new ArrayList<File>(candidates.size());
            for (File f : candidates) {
                if (!f.exists()) continue;
                files.add(f);
            }
            if (files.isEmpty()) {
                return new File[0];
            }
            return files.toArray(new File[files.size()]);
        }
    }

    @Override
    public boolean isIndividualStore(File f) {
        return this._data.SPECIAL_STORE_FILES.contains(f);
    }

    @Override
    public boolean isIndividualShare(File f) {
        return this._data.SPECIAL_FILES_TO_SHARE.contains(f) && SharingUtils.isFilePhysicallyShareable(f) && !SharingUtils.isApplicationSpecialShare(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanIndividualFiles() {
        Set<File> files;
        Set<File> set = files = this._data.SPECIAL_FILES_TO_SHARE;
        synchronized (set) {
            Iterator<File> i = files.iterator();
            while (i.hasNext()) {
                File f = i.next();
                if (SharingUtils.isFilePhysicallyShareable(f)) continue;
                i.remove();
            }
        }
    }

    @Override
    public synchronized boolean isFileShared(File file) {
        if (file == null) {
            return false;
        }
        return this._fileToFileDescMap.get(file) != null;
    }

    @Override
    public boolean isRareFile(FileDesc fd) {
        return this.rareDefinition.evaluate(fd);
    }

    private static boolean hasShareableExtension(File file) {
        if (file == null) {
            return false;
        }
        String filename = file.getName();
        int begin = filename.lastIndexOf(".");
        if (begin == -1) {
            return false;
        }
        String ext = filename.substring(begin + 1).toLowerCase();
        return _extensions.contains(ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFileInCompletelySharedDirectory(File f) {
        File dir = f.getParentFile();
        if (dir == null) {
            return false;
        }
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            return this._completelySharedDirectories.contains(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFolderShared(File dir) {
        if (dir == null) {
            return false;
        }
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            return this._completelySharedDirectories.contains(dir);
        }
    }

    @Override
    public boolean isStoreFile(File file) {
        return this._storeToFileDescMap.containsKey(file) || this._storeDirectories.contains(file);
    }

    private boolean isFileShareable(File file) {
        if (!SharingUtils.isFilePhysicallyShareable(file)) {
            return false;
        }
        if (this._individualSharedFiles.contains(file)) {
            return true;
        }
        if (this._data.FILES_NOT_TO_SHARE.contains(file)) {
            return false;
        }
        if (this.isFileInCompletelySharedDirectory(file)) {
            if (file.getName().toUpperCase().startsWith("LIMEWIRE")) {
                return true;
            }
            return FileManagerImpl.hasShareableExtension(file);
        }
        return false;
    }

    private boolean isFileLocatedStoreDirectory(File file) {
        return this._storeDirectories.contains(file.getParentFile());
    }

    private boolean isStoreXML(LimeXMLDocument doc) {
        return doc != null && doc.getLicenseString() != null && doc.getLicenseString().equals(LicenseType.LIMEWIRE_STORE_PURCHASE.name());
    }

    @Override
    public boolean isStoreDirectory(File file) {
        return this._storeDirectories.contains(file);
    }

    @Override
    public boolean isFolderShareable(File folder, boolean includeExcludedDirectories) {
        String parent;
        String name;
        if (!folder.isDirectory() || !folder.canRead()) {
            return false;
        }
        if (folder.equals(SharingSettings.INCOMPLETE_DIRECTORY.getValue())) {
            return false;
        }
        if (SharingUtils.isApplicationSpecialShareDirectory(folder)) {
            return false;
        }
        if (includeExcludedDirectories && this._data.DIRECTORIES_NOT_TO_SHARE.contains(folder)) {
            return false;
        }
        File[] faRoots = File.listRoots();
        if (faRoots != null && faRoots.length > 0) {
            for (int i = 0; i < faRoots.length; ++i) {
                if (!folder.equals(faRoots[i])) continue;
                return false;
            }
        }
        if ((name = folder.getName().toLowerCase(Locale.US)).equals("cookies")) {
            return false;
        }
        return !name.equals("low") || (parent = folder.getParent()) == null || !parent.toLowerCase(Locale.US).equals("cookies");
    }

    @Override
    public synchronized QueryRouteTable getQRT() {
        if (_needRebuild) {
            this.qrpUpdater.cancelRebuild();
            this.buildQRT();
            _needRebuild = false;
        }
        QueryRouteTable qrt = new QueryRouteTable(_queryRouteTable.getSize());
        qrt.addAll(_queryRouteTable);
        return qrt;
    }

    protected synchronized void buildQRT() {
        _queryRouteTable = new QueryRouteTable();
        if (SearchSettings.PUBLISH_LIME_KEYWORDS.getBoolean()) {
            for (String entry : SearchSettings.LIME_QRP_ENTRIES.getValue()) {
                _queryRouteTable.addIndivisible(entry);
            }
        }
        FileDesc[] fds = this.getAllSharedFileDescriptors();
        for (int i = 0; i < fds.length; ++i) {
            if (fds[i] instanceof IncompleteFileDesc) {
                IncompleteFileDesc ifd;
                if (!SharingSettings.ALLOW_PARTIAL_SHARING.getValue() || !SharingSettings.PUBLISH_PARTIAL_QRP.getValue() || !(ifd = (IncompleteFileDesc)fds[i]).hasUrnsAndPartialData()) continue;
                _queryRouteTable.add(ifd.getFileName());
                continue;
            }
            _queryRouteTable.add(fds[i].getPath());
        }
    }

    @Override
    public synchronized Response[] query(QueryRequest request) {
        String str = request.getQuery();
        boolean includeXML = this.shouldIncludeXMLInResponse(request);
        if (request.isWhatIsNewRequest()) {
            return this.respondToWhatIsNewRequest(request, includeXML);
        }
        if (str.equals("    ") || str.equals("*.*")) {
            return this.respondToIndexingQuery(includeXML);
        }
        str = this._keywordTrie.canonicalCase(str);
        IntSet matches = this.search(str, null, request.desiresPartialResults());
        if (request.getQueryUrns().size() > 0) {
            matches = this.urnSearch(request.getQueryUrns(), matches);
        }
        if (matches == null) {
            return EMPTY_RESPONSES;
        }
        LinkedList<Response> responses = new LinkedList<Response>();
        MediaType.Aggregator filter = MediaType.getAggregator(request);
        LimeXMLDocument doc = request.getRichQuery();
        IntSet.IntSetIterator iter = matches.iterator();
        while (iter.hasNext()) {
            int i = iter.next();
            FileDesc desc = this._files.get(i);
            assert (desc != null) : "unexpected null in FileManager for query:\n" + request;
            if (filter != null && !filter.allow(desc.getFileName())) continue;
            desc.incrementHitCount();
            this.fileManagerController.handleSharedFileUpdate(desc.getFile());
            Response resp = this.fileManagerController.createResponse(desc);
            if (includeXML) {
                this.addXMLToResponse(resp, desc);
                if (doc != null && resp.getDocument() != null && !this.isValidXMLMatch(resp, doc)) continue;
            }
            responses.add(resp);
        }
        if (responses.size() == 0) {
            return EMPTY_RESPONSES;
        }
        return responses.toArray(new Response[responses.size()]);
    }

    private Response[] respondToWhatIsNewRequest(QueryRequest request, boolean includeXML) {
        List<URN> urnList = this.fileManagerController.getNewestUrns(request, 3);
        if (urnList.size() == 0) {
            return EMPTY_RESPONSES;
        }
        Response[] resps = new Response[urnList.size()];
        for (int i = 0; i < urnList.size(); ++i) {
            URN currURN = urnList.get(i);
            FileDesc desc = this.getFileDescForUrn(currURN);
            if (desc == null || desc instanceof IncompleteFileDesc) {
                throw new RuntimeException("Bad Rep - No IFDs allowed!");
            }
            Response r = this.fileManagerController.createResponse(desc);
            if (includeXML) {
                this.addXMLToResponse(r, desc);
            }
            resps[i] = r;
        }
        return resps;
    }

    private Response[] respondToIndexingQuery(boolean includeXML) {
        if (this._numFiles == 0) {
            return EMPTY_RESPONSES;
        }
        Response[] ret = new Response[this._numFiles - this._numForcedFiles];
        int j = 0;
        for (int i = 0; i < this._files.size(); ++i) {
            FileDesc desc = this._files.get(i);
            if (desc == null || desc instanceof IncompleteFileDesc || SharingUtils.isForcedShare(desc)) continue;
            assert (j < ret.length) : "_numFiles is too small";
            ret[j] = this.fileManagerController.createResponse(desc);
            if (includeXML) {
                this.addXMLToResponse(ret[j], desc);
            }
            ++j;
        }
        assert (j == ret.length) : "_numFiles is too large";
        return ret;
    }

    protected abstract boolean shouldIncludeXMLInResponse(QueryRequest var1);

    protected abstract void addXMLToResponse(Response var1, FileDesc var2);

    protected abstract boolean isValidXMLMatch(Response var1, LimeXMLDocument var2);

    protected IntSet search(String query, IntSet priors, boolean partial) {
        IntSet ret = priors;
        int i = 0;
        while (i < query.length()) {
            int j;
            if (FileManagerImpl.isDelimiter(query.charAt(i))) {
                ++i;
                continue;
            }
            for (j = i + 1; j < query.length() && !FileManagerImpl.isDelimiter(query.charAt(j)); ++j) {
            }
            Iterator<IntSet> iter = this._keywordTrie.getPrefixedBy(query, i, j);
            if (SharingSettings.ALLOW_PARTIAL_SHARING.getValue() && SharingSettings.ALLOW_PARTIAL_RESPONSES.getValue() && partial) {
                iter = new MultiIterator<IntSet>(iter, this._incompleteKeywordTrie.getPrefixedBy(query, i, j));
            }
            if (iter.hasNext()) {
                IntSet matches = null;
                while (iter.hasNext()) {
                    IntSet s = iter.next();
                    if (matches == null) {
                        if (i == 0 && j == query.length() && !iter.hasNext()) {
                            return s;
                        }
                        matches = new IntSet();
                    }
                    matches.addAll(s);
                }
                if (ret == null) {
                    ret = matches;
                } else {
                    ret.retainAll(matches);
                }
            } else {
                return null;
            }
            if (ret.size() == 0) {
                return null;
            }
            i = j;
        }
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return ret;
    }

    private synchronized IntSet urnSearch(Iterable<URN> urnsIter, IntSet priors) {
        IntSet ret = priors;
        for (URN urn : urnsIter) {
            IntSet hits = this._urnMap.get(urn);
            if (hits == null) continue;
            IntSet.IntSetIterator iter = hits.iterator();
            while (iter.hasNext()) {
                FileDesc fd = this._files.get(iter.next());
                if (fd == null || fd instanceof IncompleteFileDesc || !fd.containsUrn(urn)) continue;
                if (ret == null) {
                    ret = new IntSet();
                }
                ret.add(fd.getIndex());
            }
        }
        return ret;
    }

    @Override
    public boolean isFileApplicationShared(String name) {
        File file = new File(SharingUtils.APPLICATION_SPECIAL_SHARE, name);
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException bad) {
            return false;
        }
        return this.isFileShared(file);
    }

    @Override
    public void addFileEventListener(FileEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("FileEventListener is null");
        }
        this.eventListeners.addIfAbsent(listener);
    }

    @Override
    public void removeFileEventListener(FileEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("FileEventListener is null");
        }
        this.eventListeners.remove(listener);
    }

    protected void dispatchFileEvent(FileManagerEvent evt) {
        for (FileEventListener listener : this.eventListeners) {
            listener.handleFileEvent(evt);
        }
    }

    @Override
    public Iterator<Response> getIndexingIterator(final boolean includeXML) {
        return new Iterator<Response>(){
            int startRevision;
            int index;
            Response preview;
            {
                this.startRevision = FileManagerImpl.this._revision;
                this.index = 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean preview() {
                assert (this.preview == null);
                if (FileManagerImpl.this._revision != this.startRevision) {
                    return false;
                }
                FileManagerImpl fileManagerImpl = FileManagerImpl.this;
                synchronized (fileManagerImpl) {
                    while (this.index < FileManagerImpl.this._files.size()) {
                        FileDesc desc = (FileDesc)FileManagerImpl.this._files.get(this.index);
                        ++this.index;
                        if (desc == null || desc instanceof IncompleteFileDesc || SharingUtils.isForcedShare(desc)) continue;
                        this.preview = FileManagerImpl.this.fileManagerController.createResponse(desc);
                        if (includeXML) {
                            FileManagerImpl.this.addXMLToResponse(this.preview, desc);
                        }
                        return true;
                    }
                    return false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (FileManagerImpl.this._revision != this.startRevision) {
                    return false;
                }
                if (this.preview != null) {
                    FileManagerImpl fileManagerImpl = FileManagerImpl.this;
                    synchronized (fileManagerImpl) {
                        if (FileManagerImpl.this._files.get(this.index - 1) == null) {
                            this.preview = null;
                        }
                    }
                }
                return this.preview != null || this.preview();
            }

            @Override
            public Response next() {
                if (this.hasNext()) {
                    Response item = this.preview;
                    this.preview = null;
                    return item;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        DIRECTORY_FILTER = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        };
        EMPTY_CALLBACK = new FileEventListener(){

            public void handleFileEvent(FileManagerEvent evt) {
            }
        };
        _needRebuild = true;
        EMPTY_RESPONSES = new Response[0];
    }

    private class RareFileDefinition
    implements SimppListener {
        private RPNParser parser;

        RareFileDefinition() {
            this.simppUpdated(0);
            FileManagerImpl.this.fileManagerController.addSimppListener(this);
        }

        public synchronized void simppUpdated(int ignored) {
            this.parser = new RPNParser(DHTSettings.RARE_FILE_DEFINITION.getValue());
        }

        private synchronized boolean evaluate(FileDesc fd) {
            try {
                return this.parser.evaluate(fd);
            }
            catch (IllegalArgumentException badSimpp) {
                return false;
            }
        }
    }

    private class FDInspectable
    implements Inspectable {
        private final boolean nonZero;

        FDInspectable(boolean nonZero) {
            this.nonZero = nonZero;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object inspect() {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("ver", 2);
            ArrayList<Double> hits = new ArrayList<Double>();
            ArrayList<Double> uploads = new ArrayList<Double>();
            ArrayList<Double> completeUploads = new ArrayList<Double>();
            ArrayList<Double> alts = new ArrayList<Double>();
            ArrayList<Double> keywords = new ArrayList<Double>();
            ArrayList<Double> altsHits = new ArrayList<Double>();
            ArrayList<Double> altsUploads = new ArrayList<Double>();
            ArrayList<Double> hitsUpload = new ArrayList<Double>();
            ArrayList<Double> hitsKeywords = new ArrayList<Double>();
            ArrayList<Double> uploadsToComplete = new ArrayList<Double>();
            TreeMap<Integer, FileDesc> topHitsFDs = new TreeMap<Integer, FileDesc>(Comparators.inverseIntegerComparator());
            TreeMap<Integer, FileDesc> topUpsFDs = new TreeMap<Integer, FileDesc>(Comparators.inverseIntegerComparator());
            TreeMap<Integer, FileDesc> topAltsFDs = new TreeMap<Integer, FileDesc>(Comparators.inverseIntegerComparator());
            TreeMap<Integer, FileDesc> topCupsFDs = new TreeMap<Integer, FileDesc>(Comparators.inverseIntegerComparator());
            FileManagerImpl fileManagerImpl = FileManagerImpl.this;
            synchronized (fileManagerImpl) {
                FileDesc[] fds = FileManagerImpl.this.getAllSharedFileDescriptors();
                hits.ensureCapacity(fds.length);
                uploads.ensureCapacity(fds.length);
                int rare = 0;
                int total = 0;
                for (int i = 0; i < fds.length; ++i) {
                    if (fds[i] instanceof IncompleteFileDesc) continue;
                    ++total;
                    if (FileManagerImpl.this.isRareFile(fds[i])) {
                        ++rare;
                    }
                    int numAlts = FileManagerImpl.this.fileManagerController.getAlternateLocationCount(fds[i].getSHA1Urn());
                    if (!this.nonZero || numAlts > 0) {
                        alts.add(Double.valueOf(numAlts));
                        topAltsFDs.put(numAlts, fds[i]);
                    }
                    int hitCount = fds[i].getHitCount();
                    if (!this.nonZero || hitCount > 0) {
                        hits.add(Double.valueOf(hitCount));
                        topHitsFDs.put(hitCount, fds[i]);
                    }
                    int upCount = fds[i].getAttemptedUploads();
                    if (!this.nonZero || upCount > 0) {
                        uploads.add(Double.valueOf(upCount));
                        topUpsFDs.put(upCount, fds[i]);
                    }
                    int cupCount = fds[i].getCompletedUploads();
                    if (!this.nonZero || cupCount > 0) {
                        completeUploads.add(Double.valueOf(upCount));
                        topCupsFDs.put(cupCount, fds[i]);
                    }
                    double keywordsCount = HashFunction.getPrefixes(HashFunction.keywords(fds[i].getPath())).length;
                    keywords.add(keywordsCount);
                    if (this.nonZero) continue;
                    int index = hits.size() - 1;
                    hitsUpload.add(hits.get(index) - uploads.get(index));
                    altsHits.add(alts.get(index) - hits.get(index));
                    altsUploads.add(alts.get(index) - uploads.get(index));
                    hitsKeywords.add(hits.get(index) - keywordsCount);
                    uploadsToComplete.add(uploads.get(index) - completeUploads.get(index));
                }
                ret.put("rare", Double.doubleToLongBits((double)rare / (double)total));
            }
            ret.put("hits", StatsUtils.quickStatsDouble(hits).getMap());
            ret.put("hitsh", StatsUtils.getHistogram(hits, 10));
            ret.put("ups", StatsUtils.quickStatsDouble(uploads).getMap());
            ret.put("upsh", StatsUtils.getHistogram(uploads, 10));
            ret.put("cups", StatsUtils.quickStatsDouble(completeUploads).getMap());
            ret.put("cupsh", StatsUtils.getHistogram(completeUploads, 10));
            ret.put("alts", StatsUtils.quickStatsDouble(alts).getMap());
            ret.put("altsh", StatsUtils.getHistogram(alts, 10));
            ret.put("kw", StatsUtils.quickStatsDouble(keywords).getMap());
            ret.put("kwh", StatsUtils.getHistogram(keywords, 10));
            ret.put("hut", StatsUtils.quickStatsDouble(hitsUpload).getTTestMap());
            ret.put("aht", StatsUtils.quickStatsDouble(altsHits).getTTestMap());
            ret.put("aut", StatsUtils.quickStatsDouble(altsUploads).getTTestMap());
            ret.put("hkt", StatsUtils.quickStatsDouble(hitsKeywords).getTTestMap());
            ret.put("ucut", StatsUtils.quickStatsDouble(uploadsToComplete).getTTestMap());
            QueryRouteTable topHits = new QueryRouteTable();
            QueryRouteTable topUps = new QueryRouteTable();
            QueryRouteTable topCups = new QueryRouteTable();
            QueryRouteTable topAlts = new QueryRouteTable();
            Iterator hitIter = topHitsFDs.values().iterator();
            Iterator upIter = topUpsFDs.values().iterator();
            Iterator cupIter = topCupsFDs.values().iterator();
            Iterator altIter = topAltsFDs.values().iterator();
            for (int i = 0; i < 10; ++i) {
                if (hitIter.hasNext()) {
                    topHits.add(((FileDesc)hitIter.next()).getPath());
                }
                if (upIter.hasNext()) {
                    topUps.add(((FileDesc)upIter.next()).getPath());
                }
                if (altIter.hasNext()) {
                    topAlts.add(((FileDesc)altIter.next()).getPath());
                }
                if (!cupIter.hasNext()) continue;
                topCups.add(((FileDesc)cupIter.next()).getPath());
            }
            ret.put("hitsq", topHits.getRawDump());
            ret.put("upsq", topUps.getRawDump());
            ret.put("cupsq", topCups.getRawDump());
            ret.put("altsq", topAlts.getRawDump());
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @InspectableContainer
    private class FMInspectables {
        private static final int VERSION = 2;
        @InspectionPoint(value="FileManager QRP info")
        public final Inspectable QRP = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                HashMap<String, byte[]> ret = new HashMap<String, byte[]>();
                FMInspectables.this.addVersion(ret);
                FileManagerImpl fileManagerImpl = FileManagerImpl.this;
                synchronized (fileManagerImpl) {
                    ret.put("qrt", FileManagerImpl.this.getQRT().getRawDump());
                }
                return ret;
            }
        };
        @InspectionPoint(value="FileManager h/u/a stats")
        public final Inspectable FDS = new FDInspectable(false);
        @InspectionPoint(value="FileManager h/u/a stats > 0")
        public final Inspectable FDSNZ = new FDInspectable(true);
        @InspectionPoint(value="FileManager custom criteria")
        public final Inspectable CUSTOM = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put("ver", 1);
                ret.put("crit", MessageSettings.CUSTOM_FD_CRITERIA.getValueAsString());
                int total = 0;
                int matched = 0;
                try {
                    RPNParser parser = new RPNParser(MessageSettings.CUSTOM_FD_CRITERIA.getValue());
                    FileManagerImpl fileManagerImpl = FileManagerImpl.this;
                    synchronized (fileManagerImpl) {
                        for (FileDesc fd : FileManagerImpl.this.getAllSharedFileDescriptors()) {
                            ++total;
                            if (!parser.evaluate(fd)) continue;
                            ++matched;
                        }
                    }
                }
                catch (IllegalArgumentException badSimpp) {
                    ret.put("error", badSimpp.toString());
                    return ret;
                }
                ret.put("match", matched);
                ret.put("total", total);
                return ret;
            }
        };

        private FMInspectables() {
        }

        private void addVersion(Map<String, Object> m) {
            m.put("ver", 2);
        }
    }

    private class QRPUpdater
    implements SimppListener {
        private boolean buildInProgress;
        private final Set<String> qrpWords = new HashSet<String>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QRPUpdater() {
            QRPUpdater qRPUpdater = this;
            synchronized (qRPUpdater) {
                for (String entry : SearchSettings.LIME_QRP_ENTRIES.getValue()) {
                    this.qrpWords.add(entry);
                }
            }
        }

        public synchronized void simppUpdated(int newVersion) {
            if (this.buildInProgress) {
                return;
            }
            HashSet<String> newWords = new HashSet<String>();
            for (String entry : SearchSettings.LIME_QRP_ENTRIES.getValue()) {
                newWords.add(entry);
            }
            if (newWords.containsAll(this.qrpWords) && this.qrpWords.containsAll(newWords)) {
                return;
            }
            this.qrpWords.clear();
            this.qrpWords.addAll(newWords);
            this.buildInProgress = true;
            FileManagerImpl.this.fileManagerController.scheduleWithFixedDelay(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    QRPUpdater qRPUpdater = QRPUpdater.this;
                    synchronized (qRPUpdater) {
                        if (!QRPUpdater.this.buildInProgress) {
                            return;
                        }
                        QRPUpdater.this.buildInProgress = false;
                        _needRebuild = true;
                    }
                }
            }, (int)(Math.random() * (double)QRP_DELAY), 0, TimeUnit.MILLISECONDS);
        }

        public synchronized void cancelRebuild() {
            this.buildInProgress = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AddType {
        ADD_SHARE(FileManagerEvent.Type.ADD_FILE, FileManagerEvent.Type.ADD_FAILED_FILE),
        ADD_STORE(FileManagerEvent.Type.ADD_STORE_FILE, FileManagerEvent.Type.ADD_STORE_FAILED_FILE);

        private final FileManagerEvent.Type success;
        private final FileManagerEvent.Type failure;

        private AddType(FileManagerEvent.Type success, FileManagerEvent.Type failure) {
            this.success = success;
            this.failure = failure;
        }

        public FileManagerEvent.Type getSuccessType() {
            return this.success;
        }

        public FileManagerEvent.Type getFailureType() {
            return this.failure;
        }
    }
}

