/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import java.util.Comparator;
import java.util.Locale;
import java.util.Random;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUID
implements Comparable<GUID> {
    private static final int SZ = 16;
    private static Random rand = new Random();
    private byte[] bytes;
    public static final Comparator<GUID> GUID_COMPARATOR = new GUIDComparator();
    public static final Comparator<byte[]> GUID_BYTE_COMPARATOR = new GUIDByteComparator();

    public GUID() {
        this(GUID.makeGuid());
    }

    public GUID(byte[] bytes) {
        assert (bytes.length == 16);
        this.bytes = bytes;
    }

    private static void tagGuid(byte[] guid, int first, int second, int markPoint) {
        short a = ByteOrder.leb2short(guid, first);
        short b = ByteOrder.leb2short(guid, second);
        short tag = GUID.tag(a, b);
        ByteOrder.short2leb(tag, guid, markPoint);
    }

    public static byte[] makeGuid() {
        byte[] ret = new byte[16];
        rand.nextBytes(ret);
        ret[15] = 0;
        GUID.tagGuid(ret, 4, 6, 9);
        return ret;
    }

    public static byte[] makeGuidRequery() {
        byte[] ret = GUID.makeGuid();
        GUID.tagGuid(ret, 0, 11, 13);
        return ret;
    }

    public static void timeStampGuid(byte[] guid) {
        int now = (int)(System.currentTimeMillis() / 1000L);
        guid[4] = (byte)(now >> 24);
        guid[5] = (byte)(now >> 16);
        guid[6] = (byte)(now >> 8);
        guid[15] = (byte)now;
    }

    public static long readTimeStamp(byte[] guid) {
        return (long)(guid[4] << 24 | (guid[5] & 0xFF) << 16 | (guid[6] & 0xFF) << 8 | guid[15] & 0xFF) * 1000L;
    }

    public static byte[] makeAddressEncodedGuid(byte[] ip, int port) throws IllegalArgumentException {
        return GUID.addressEncodeGuid(GUID.makeGuid(), ip, port);
    }

    public static byte[] addressEncodeGuid(byte[] ret, byte[] ip, int port) throws IllegalArgumentException {
        if (ret.length != 16) {
            throw new IllegalArgumentException("Input byte array wrong length.");
        }
        if (!NetworkUtils.isValidAddress(ip)) {
            throw new IllegalArgumentException("IP is invalid!");
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("Port is invalid: " + port);
        }
        for (int i = 0; i < 4; ++i) {
            ret[i] = ip[i];
        }
        ByteOrder.short2leb((short)port, ret, 13);
        return ret;
    }

    static short tag(short a, short b) {
        int product = (a + 2) * (b + 3);
        short productMiddle = (short)(product >> 8);
        return productMiddle;
    }

    public boolean isLimeGUID() {
        return GUID.isLimeGUID(this.bytes);
    }

    public boolean isLimeRequeryGUID(int version) {
        return GUID.isLimeRequeryGUID(this.bytes, version);
    }

    public boolean isLimeRequeryGUID() {
        return GUID.isLimeRequeryGUID(this.bytes);
    }

    public boolean addressesMatch(byte[] ip, int port) throws IllegalArgumentException {
        return GUID.addressesMatch(this.bytes, ip, port);
    }

    public String getIP() {
        return GUID.getIP(this.bytes);
    }

    public boolean matchesIP(byte[] bytes) {
        return GUID.matchesIP(bytes, this.bytes);
    }

    public int getPort() {
        return GUID.getPort(this.bytes);
    }

    private static boolean checkMatching(byte[] bytes, int first, int second, int found) {
        short expectedTag;
        short a = ByteOrder.leb2short(bytes, first);
        short b = ByteOrder.leb2short(bytes, second);
        short foundTag = ByteOrder.leb2short(bytes, found);
        return foundTag == (expectedTag = GUID.tag(a, b));
    }

    public static boolean isLimeGUID(byte[] bytes) {
        return GUID.checkMatching(bytes, 4, 6, 9);
    }

    public static boolean isLimeRequeryGUID(byte[] bytes) {
        return GUID.isLimeRequeryGUID(bytes, 0) || GUID.isLimeRequeryGUID(bytes, 1) || GUID.isLimeRequeryGUID(bytes, 2);
    }

    public static boolean isLimeRequeryGUID(byte[] bytes, int version) {
        if (version == 0) {
            return GUID.checkMatching(bytes, 0, 9, 13);
        }
        if (version == 1) {
            return GUID.checkMatching(bytes, 0, 2, 13);
        }
        return GUID.checkMatching(bytes, 0, 11, 13);
    }

    public static boolean addressesMatch(byte[] guidBytes, byte[] ip, int port) throws IllegalArgumentException {
        if (ip.length != 4) {
            throw new IllegalArgumentException("IP address too big!");
        }
        if (!NetworkUtils.isValidPort(port)) {
            return false;
        }
        if (!NetworkUtils.isValidAddress(ip)) {
            return false;
        }
        byte[] portBytes = new byte[2];
        ByteOrder.short2leb((short)port, portBytes, 0);
        return guidBytes[0] == ip[0] && guidBytes[1] == ip[1] && guidBytes[2] == ip[2] && guidBytes[3] == ip[3] && guidBytes[13] == portBytes[0] && guidBytes[14] == portBytes[1];
    }

    public static String getIP(byte[] guidBytes) {
        return NetworkUtils.ip2string(guidBytes);
    }

    public static boolean matchesIP(byte[] ipBytes, byte[] guidBytes) {
        if (ipBytes.length != 4) {
            throw new IllegalArgumentException("Bad byte[] length = " + ipBytes.length);
        }
        for (int i = 0; i < ipBytes.length; ++i) {
            if (ipBytes[i] == guidBytes[i]) continue;
            return false;
        }
        return true;
    }

    public static int getPort(byte[] guidBytes) {
        return ByteOrder.ushort2int(ByteOrder.leb2short(guidBytes, 13));
    }

    @Override
    public int compareTo(GUID o) {
        if (this == o) {
            return 0;
        }
        return GUID.compare(this.bytes(), o.bytes());
    }

    private static final int compare(byte[] guid, byte[] guid2) {
        for (int i = 0; i < 16; ++i) {
            int diff = guid[i] - guid2[i];
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GUID) {
            byte[] bytes2 = ((GUID)o).bytes();
            assert (this.bytes != null) : "Null bytes in GUID.equals";
            assert (bytes2 != null) : "Null bytes2 in GUID.equals";
            for (int i = 0; i < 16; ++i) {
                if (this.bytes[i] == bytes2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        byte[] ba = this.bytes;
        int M1 = 255;
        int M2 = 65280;
        int M3 = 0xFF0000;
        int a = 0xFF & ba[0] | 0xFF00 & ba[1] << 8 | 0xFF0000 & ba[2] << 16 | ba[3] << 24;
        int b = 0xFF & ba[4] | 0xFF00 & ba[5] << 8 | 0xFF0000 & ba[6] << 16 | ba[7] << 24;
        int c = 0xFF & ba[8] | 0xFF00 & ba[9] << 8 | 0xFF0000 & ba[10] << 16 | ba[11] << 24;
        int d = 0xFF & ba[12] | 0xFF00 & ba[13] << 8 | 0xFF0000 & ba[14] << 16 | ba[15] << 24;
        return a ^ b ^ c ^ d;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public String toString() {
        return this.toHexString();
    }

    public String toHexString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            int val = ByteOrder.ubyte2int(this.bytes[i]);
            String str = Integer.toHexString(val);
            while (str.length() < 2) {
                str = "0" + str;
            }
            buf.append(str);
        }
        return buf.toString().toUpperCase(Locale.US);
    }

    public static byte[] fromHexString(String sguid) throws IllegalArgumentException {
        byte[] bytes = new byte[16];
        try {
            for (int i = 0; i < 16; ++i) {
                bytes[i] = (byte)Integer.parseInt(sguid.substring(i * 2, i * 2 + 2), 16);
            }
            return bytes;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    public static class TimedGUID {
        private final long MAX_LIFE;
        private final GUID _guid;
        private final long _creationTime;

        public GUID getGUID() {
            return this._guid;
        }

        public TimedGUID(GUID guid) {
            this._guid = guid;
            this.MAX_LIFE = -1L;
            this._creationTime = -1L;
        }

        public TimedGUID(GUID guid, long maxLife) {
            this._guid = guid;
            this.MAX_LIFE = maxLife;
            this._creationTime = System.currentTimeMillis();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof TimedGUID) {
                return this._guid.equals(((TimedGUID)other)._guid);
            }
            return false;
        }

        public int hashCode() {
            return this._guid.hashCode();
        }

        public boolean shouldExpire(long now) {
            return now - this._creationTime >= this.MAX_LIFE;
        }

        public String toString() {
            return this._guid.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GUIDByteComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] a, byte[] b) {
            return GUID.compare(a, b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GUIDComparator
    implements Comparator<GUID> {
        @Override
        public int compare(GUID a, GUID b) {
            return GUID.compare(a.bytes, b.bytes);
        }
    }
}

