/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GuidMap;
import com.limegroup.gnutella.GuidMapManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Singleton
class GuidMapManagerImpl
implements GuidMapManager {
    private static long EXPIRE_POLL_TIME = 120000L;
    private static long TIMED_GUID_LIFETIME = 600000L;
    private List<GuidMapImpl> toExpire = new LinkedList<GuidMapImpl>();
    private boolean scheduled = false;
    private final ScheduledExecutorService backgroundExecutor;

    @Inject
    public GuidMapManagerImpl(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor) {
        this.backgroundExecutor = backgroundExecutor;
    }

    public GuidMap getMap() {
        return new GuidMapImpl();
    }

    public synchronized void removeMap(GuidMap expiree) {
        this.toExpire.remove(expiree);
    }

    private synchronized void addMapToExpire(GuidMapImpl expiree) {
        if (!this.scheduled) {
            this.backgroundExecutor.scheduleWithFixedDelay(new GuidExpirer(), 0L, EXPIRE_POLL_TIME, TimeUnit.MILLISECONDS);
            this.scheduled = true;
        }
        this.toExpire.add(expiree);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GuidMapImpl
    implements GuidMap {
        private Map<GUID.TimedGUID, GUID> map;

        private GuidMapImpl() {
        }

        public String toString() {
            return "impl, map: " + this.map;
        }

        Map<GUID.TimedGUID, GUID> getMap() {
            return this.map;
        }

        @Override
        public void addMapping(byte[] origGUID, byte[] newGUID) {
            this.addMapping(origGUID, newGUID, TIMED_GUID_LIFETIME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addMapping(byte[] origGUID, byte[] newGUID, long lifetime) {
            boolean created = false;
            GuidMapImpl guidMapImpl = this;
            synchronized (guidMapImpl) {
                if (this.map == null) {
                    this.map = new HashMap<GUID.TimedGUID, GUID>();
                    created = true;
                }
                GUID.TimedGUID tGuid = new GUID.TimedGUID(new GUID(newGUID), lifetime);
                this.map.put(tGuid, new GUID(origGUID));
            }
            if (created) {
                GuidMapManagerImpl.this.addMapToExpire(this);
            }
        }

        @Override
        public synchronized byte[] getOriginalGUID(byte[] newGUID) {
            GUID.TimedGUID wrapper;
            GUID orig;
            if (this.map != null && (orig = this.map.get(wrapper = new GUID.TimedGUID(new GUID(newGUID), 0L))) != null) {
                return orig.bytes();
            }
            return null;
        }

        @Override
        public synchronized GUID getNewGUID(GUID origGUID) {
            if (this.map != null) {
                for (Map.Entry<GUID.TimedGUID, GUID> next : this.map.entrySet()) {
                    if (!next.getValue().equals(origGUID)) continue;
                    return next.getKey().getGUID();
                }
            }
            return null;
        }
    }

    private class GuidExpirer
    implements Runnable {
        private GuidExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            GuidMapManagerImpl guidMapManagerImpl = GuidMapManagerImpl.this;
            synchronized (guidMapManagerImpl) {
                Iterator i = GuidMapManagerImpl.this.toExpire.iterator();
                while (i.hasNext()) {
                    GuidMapImpl next;
                    GuidMapImpl guidMapImpl = next = (GuidMapImpl)i.next();
                    synchronized (guidMapImpl) {
                        long now = System.currentTimeMillis();
                        Map<GUID.TimedGUID, GUID> currMap = next.getMap();
                        Iterator<GUID.TimedGUID> j = currMap.keySet().iterator();
                        while (j.hasNext()) {
                            if (!j.next().shouldExpire(now)) continue;
                            j.remove();
                        }
                    }
                }
            }
        }
    }
}

