/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.http.HTTPConnectionData;
import com.limegroup.gnutella.http.HttpContextParams;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.limewire.http.BasicHttpAcceptor;
import org.limewire.http.HttpAcceptorListener;
import org.limewire.http.HttpIOSession;
import org.limewire.nio.NIODispatcher;
import org.limewire.statistic.Statistic;

@Singleton
public class HTTPAcceptor
extends BasicHttpAcceptor {
    private static final Log LOG = LogFactory.getLog(HTTPAcceptor.class);
    private static final String[] SUPPORTED_METHODS = new String[]{"GET", "HEAD"};
    private final HttpRequestHandler notFoundHandler = new HttpRequestHandler(){

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setReasonPhrase("Feature Not Active");
            response.setStatusCode(404);
        }
    };

    @Inject
    public HTTPAcceptor(TcpBandwidthStatistics tcpBandwidthStatistics) {
        super(HTTPAcceptor.createDefaultParams(LimeWireUtils.getHttpServer(), 8000), SUPPORTED_METHODS);
        this.addAcceptorListener(new ConnectionEventListener());
        if (tcpBandwidthStatistics != null) {
            this.addResponseInterceptor(new HeaderStatisticTracker(tcpBandwidthStatistics));
        } else {
            LOG.warn("Not tracking TCP header bandwidth!");
        }
        this.inititalizeDefaultHandlers();
    }

    private void inititalizeDefaultHandlers() {
        this.registerHandler("/browser-control", this.notFoundHandler);
        this.registerHandler("/gnutella/file-view*", this.notFoundHandler);
        this.registerHandler("/gnutella/res/*", this.notFoundHandler);
        this.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                response.setStatusCode(400);
            }
        });
    }

    public void acceptConnection(Socket socket, HTTPConnectionData data) {
        assert (NIODispatcher.instance().isDispatchThread());
        if (this.getReactor() == null) {
            LOG.warn("Received upload request before reactor was initialized");
            return;
        }
        NHttpConnection conn = this.getReactor().acceptConnection(null, socket);
        if (conn != null) {
            HttpContextParams.setConnectionData(conn.getContext(), data);
        }
    }

    public HttpRequestHandler getNotFoundHandler() {
        return this.notFoundHandler;
    }

    private class HeaderStatisticTracker
    implements HttpResponseInterceptor {
        private final Statistic headerUpstream;

        HeaderStatisticTracker(TcpBandwidthStatistics tcpBandwidthStatistics) {
            this.headerUpstream = tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_UPSTREAM);
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            HeaderIterator it = response.headerIterator();
            while (it.hasNext()) {
                Header header = (Header)it.next();
                this.headerUpstream.addData(header.getName().length() + 2 + header.getValue().length());
            }
        }
    }

    private class ConnectionEventListener
    implements HttpAcceptorListener {
        private ConnectionEventListener() {
        }

        public void connectionOpen(NHttpConnection conn) {
        }

        public void connectionClosed(NHttpConnection conn) {
        }

        public void connectionTimeout(NHttpConnection conn) {
        }

        public void fatalIOException(IOException e, NHttpConnection conn) {
        }

        public void fatalProtocolException(HttpException e, NHttpConnection conn) {
        }

        public void requestReceived(NHttpConnection conn, HttpRequest request) {
        }

        public void responseSent(NHttpConnection conn, HttpResponse response) {
            HttpIOSession session = HttpContextParams.getIOSession(conn.getContext());
            session.setSocketTimeout(SharingSettings.PERSISTENT_HTTP_CONNECTION_TIMEOUT.getValue());
            session.setThrottle(null);
        }
    }
}

