/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.settings.MojitoProps;
import org.limewire.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class LimeCoreGlue {
    private static final Log LOG = LogFactory.getLog(LimeCoreGlue.class);
    private static AtomicBoolean preinstalled = new AtomicBoolean(false);
    private AtomicBoolean installed = new AtomicBoolean(false);
    private final Provider<SimppManager> simppManager;

    @Inject
    public LimeCoreGlue(Provider<SimppManager> simppManager) {
        this.simppManager = simppManager;
    }

    public static void preinstall() throws InstallFailedException {
        LimeCoreGlue.preinstall(LimeWireUtils.getRequestedUserSettingsLocation());
    }

    public static void preinstall(File userSettingsDir) throws InstallFailedException {
        if (!preinstalled.compareAndSet(false, true)) {
            return;
        }
        try {
            CommonUtils.setUserSettingsDir(userSettingsDir);
        }
        catch (IOException requestedFailed) {
            try {
                File temporaryDir;
                LimeWireUtils.clearTemporarySettingsDirectories();
                try {
                    temporaryDir = LimeWireUtils.getTemporarySettingsDirectory();
                }
                catch (IOException tempFailed) {
                    tempFailed.initCause(requestedFailed);
                    throw tempFailed;
                }
                temporaryDir.deleteOnExit();
                try {
                    CommonUtils.setUserSettingsDir(temporaryDir);
                }
                catch (IOException cannotSet) {
                    cannotSet.initCause(requestedFailed);
                    throw cannotSet;
                }
                LimeWireUtils.setTemporaryDirectoryInUse(true);
            }
            catch (IOException totalFailure) {
                throw new InstallFailedException("Settings Directory Failure", totalFailure);
            }
        }
    }

    public void install() {
        if (!ApplicationSettings.USE_SIMPP.getValue()) {
            LOG.debug("No more SIMPP, turned off");
            return;
        }
        if (!this.installed.compareAndSet(false, true)) {
            return;
        }
        LimeCoreGlue.preinstall();
        SimppSettingsManager core = new SimppSettingsManager();
        SimppSettingsManager mojito = new SimppSettingsManager();
        this.simppManager.get().addSimppSettingsManager(core);
        this.simppManager.get().addSimppSettingsManager(mojito);
        LimeProps.instance().getFactory().setRemoteSettingManager(core);
        MojitoProps.instance().getFactory().setRemoteSettingManager(mojito);
        core.updateSimppSettings(this.simppManager.get().getPropsString());
        mojito.updateSimppSettings(this.simppManager.get().getPropsString());
    }

    public static class InstallFailedException
    extends RuntimeException {
        public InstallFailedException() {
        }

        public InstallFailedException(String message, Throwable cause) {
            super(message, cause);
        }

        public InstallFailedException(String message) {
            super(message);
        }

        public InstallFailedException(Throwable cause) {
            super(cause);
        }
    }
}

