/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.LocalFileDetailsFactory;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Set;

@Singleton
public class LocalFileDetailsFactoryImpl
implements LocalFileDetailsFactory {
    private final NetworkManager networkManager;

    @Inject
    public LocalFileDetailsFactoryImpl(NetworkManager networkManager) {
        this.networkManager = networkManager;
    }

    public FileDetails create(final FileDesc fd) {
        return new FileDetails(){

            @Override
            public String getFileName() {
                return fd.getFileName();
            }

            @Override
            public long getFileSize() {
                return fd.getFileSize();
            }

            @Override
            public InetSocketAddress getInetSocketAddress() {
                try {
                    return new InetSocketAddress(InetAddress.getByAddress(LocalFileDetailsFactoryImpl.this.networkManager.getAddress()), LocalFileDetailsFactoryImpl.this.networkManager.getPort());
                }
                catch (UnknownHostException unknownHostException) {
                    return null;
                }
            }

            @Override
            public boolean isFirewalled() {
                return !LocalFileDetailsFactoryImpl.this.networkManager.acceptedIncomingConnection();
            }

            @Override
            public URN getSHA1Urn() {
                return fd.getSHA1Urn();
            }

            @Override
            public Set<URN> getUrns() {
                return fd.getUrns();
            }

            @Override
            public LimeXMLDocument getXMLDocument() {
                return fd.getXMLDocument();
            }
        };
    }
}

